/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.action.shop;

import java.util.ArrayList;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Sku;
import net.redxyz.top.message.item.ItemSellerGetResponse4_24625_Sku;
import net.redxyz.top.portal.SessionUser;
import net.redxyz.top.service.SkuUtil;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;

public class ShopPriceModifyAction
implements Action {
    public void execute(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        long numIid = request.getParameterLong("numIid");
        request.setAttribute("numIid", (Object)numIid);
        ItemSellerGetResponse4_24625_Sku resp = TaobaoService.getItemService().getItemSku(nick, sessionId, numIid);
        if (!resp.isSuccess()) {
            request.returnCloseDialog(resp.getErrorMsg());
            return;
        }
        String price = resp.getPrice();
        String title = resp.getTitle();
        String picUrl = resp.getPicUrl();
        List<Sku> skuList = null;
        if (Validates.isNotEmpty((String)resp.getSkus())) {
            skuList = resp.getSkuList();
            sessionUser.setValue("skuList", skuList);
        }
        if (skuList == null) {
            skuList = new ArrayList<Sku>();
        }
        request.setAttribute("skuList", skuList);
        request.setAttribute("curPrice", (Object)price);
        request.setAttribute("curTitle", (Object)title);
        request.setAttribute("picUrl", (Object)picUrl);
    }

    public void updateSku(HttpRequest request, long skuId, String price) {
        if (!Validates.isAmount2R((String)price)) {
            request.setResponseError("\u4ef7\u683c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return;
        }
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        List skuList = (List)sessionUser.getValue("skuList");
        Sku sku = SkuUtil.getSku(skuList, skuId);
        if (sku == null) {
            request.setResponseError("\u8be5SKU\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
            return;
        }
        sku.setPrice(price);
    }
}

