/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal;

import java.sql.SQLException;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.dbo.sys.SysArticle;
import net.redxyz.top.dbo.sys.SysPermission;
import net.redxyz.top.dbo.sys.SysPopup;
import net.redxyz.top.dbo.user.User;
import net.redxyz.top.portal.model.SellerCatRoot;
import net.redxyz.top.service.dao.ArticleDao;
import net.redxyz.top.service.dao.PermissionDao;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"SessionUser"})
public class SessionUser
extends HttpSessionUser {
    private User user;
    private SellerCatRoot seRoot;
    private String subNick;
    private String subSessionId;
    private String subSessionTime;
    private int subExpiresIn;
    private int subExpiresInW2;
    private boolean isGift;
    private int giftVersionNo;
    private String giftStartDate;
    private String giftEndDate;
    private boolean isAdmin;
    private boolean isUpdateData;
    private boolean isCloseTopNotice;
    private boolean isClosePopup;
    private SysPopup popup;
    private int from = 0;
    private boolean hasSubNick;

    public String getSessionName() {
        return this.subNick == null ? this.user.getNick() : this.subNick;
    }

    public String getSessionKey() {
        return super.getSessionId();
    }

    public String getLoginTime() {
        return super.getCreateTime();
    }

    public int getRemainMinute(int sessionTimeout) {
        long remain = System.currentTimeMillis() - super.getLastAccessed();
        return (int)((long)sessionTimeout - remain / 1000L) / 60;
    }

    public static String getRemainDayStr(String time) {
        int diff = DateTimes.compareSecond((String)time, (String)DateTimes.getDateTimeString());
        if (diff <= 0) {
            return "-- --";
        }
        long nd = 86400L;
        long nh = 3600L;
        long nm = 60L;
        long day = (long)diff / nd;
        long hour = (long)diff % nd / nh;
        long min = (long)diff % nd % nh / nm;
        return String.valueOf(day) + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static String getRemainHourStr(String time) {
        int diff = DateTimes.compareSecond((String)time, (String)DateTimes.getDateTimeString());
        if (diff <= 0) {
            return "-- --";
        }
        long nd = 3600L;
        long nh = 60L;
        long hour = (long)diff / nd;
        long min = (long)diff % nd / nh;
        long sec = (long)diff % nd % nh;
        return String.valueOf(hour) + "\u5c0f\u65f6" + min + "\u5206\u949f" + sec + "\u79d2";
    }

    public String getNickLogined() {
        if (this.hasSubNick) {
            return this.subNick;
        }
        return this.user.getNick();
    }

    public String getSessionId() {
        if (this.hasSubNick) {
            return this.subSessionId;
        }
        return this.user.getSessionId();
    }

    public long getUserId() {
        return Long.parseLong(this.user.getUserId());
    }

    public String getSessionTime() {
        if (this.hasSubNick) {
            return this.subSessionTime;
        }
        return this.user.getSessionTime();
    }

    public int getExpiresIn() {
        if (this.hasSubNick) {
            return this.subExpiresIn;
        }
        return this.user.getExpiresIn();
    }

    public int getExpiresInW2() {
        if (this.hasSubNick) {
            return this.subExpiresInW2;
        }
        return this.user.getExpiresInW2();
    }

    public long getUserPoint() {
        return this.user.getUserPoint();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getNick() {
        return this.user.getNick();
    }

    public String getUserDomain() {
        return this.user.getUserDomain();
    }

    public int getUserDb() {
        return this.user.getUserDb();
    }

    public int getUserSmsNum() {
        return this.user.getUserSmsNum();
    }

    public int getUserMailNum() {
        return this.user.getUserSmsNum();
    }

    public void setItemNum(int itemNum) {
        this.user.setItemNum(itemNum);
    }

    public int getItemNum() {
        return this.user.getItemNum();
    }

    public String getCreateTime() {
        return this.user.getCreateTime();
    }

    public String getLastLoginTime() {
        return this.user.getLastLoginTime();
    }

    public void setVersionNo(int versionNo) {
        this.user.setVersionNo(versionNo);
    }

    public int getVersionNo() {
        return this.user.getVersionNo();
    }

    public void setStartDate(String startDate) {
        this.user.setStartDate(startDate);
    }

    public String getStartDate() {
        return this.user.getStartDate();
    }

    public void setEndDate(String endDate) {
        this.user.setEndDate(endDate);
    }

    public String getEndDate() {
        if (Validates.isNotEmpty((String)this.user.getEndDate())) {
            return this.user.getEndDate();
        }
        return this.getExpireInTime().substring(0, 10);
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setMobile(String mobile) {
        this.user.setMobile(mobile);
    }

    public String getMobile() {
        return this.user.getMobile();
    }

    public String getType() {
        return this.user.getType();
    }

    public boolean isTypeC() {
        return "C".equals(this.user.getType());
    }

    public boolean isTypeB() {
        return "B".equals(this.user.getType());
    }

    public boolean isAutoRepostLimited() {
        return this.user.getAutoRepostLimited() == 1;
    }

    public String getBirthday() {
        return this.user.getBirthday();
    }

    public String getAvatar() {
        return this.user.getAvatar();
    }

    public int getShopId() {
        return this.user.getShopId();
    }

    public int getShopCid() {
        return this.user.getShopCid();
    }

    public String getShopTitle() {
        return this.user.getShopTitle();
    }

    public String getShopTitle20() {
        String title = this.user.getShopTitle();
        if (Validates.isByteLen((String)title, (int)0, (int)14)) {
            return title;
        }
        return Strings.substringLen((String)title, (int)14);
    }

    public String getShopCreateTime() {
        return this.user.getShopCreateTime().substring(0, 10);
    }

    public int getLevel() {
        return this.user.getLevel();
    }

    public boolean isGift() {
        return this.isGift;
    }

    public void setGift(boolean isGift) {
        this.isGift = isGift;
    }

    public int getGiftVersionNo() {
        if (this.isGift) {
            return this.giftVersionNo;
        }
        return this.user.getVersionNo();
    }

    public void setGiftVersionNo(int giftVersionNo) {
        this.giftVersionNo = giftVersionNo;
    }

    public String getGiftStartDate() {
        if (this.isGift) {
            return this.giftStartDate;
        }
        return this.getStartDate();
    }

    public void setGiftStartDate(String giftStartDate) {
        this.giftStartDate = giftStartDate;
    }

    public String getGiftEndDate() {
        if (this.isGift) {
            return this.giftEndDate;
        }
        return this.getEndDate();
    }

    public String getGiftEndDateTime() {
        if (this.isGift) {
            return String.valueOf(this.giftEndDate) + " 00:00:00";
        }
        if (!Validates.isEmpty((String)this.user.getEndDate())) {
            return String.valueOf(this.user.getEndDate()) + " 00:00:00";
        }
        return this.getExpireInTime();
    }

    public void setGiftEndDate(String giftEndDate) {
        this.giftEndDate = giftEndDate;
    }

    public String getGiftVersionDesc() throws Exception {
        String desc = null;
        SysArticle article = ArticleDao.item(this.getGiftVersionNo());
        desc = article == null ? "\u4e34\u65f6\u7248" : article.getItemName();
        return desc;
    }

    public String getSubNick() {
        return this.subNick;
    }

    public void setSubNick(String subNick) {
        this.subNick = subNick;
    }

    public String getSubSessionId() {
        return this.subSessionId;
    }

    public void setSubSessionId(String subSessionId) {
        this.subSessionId = subSessionId;
    }

    public String getSubSessionTime() {
        return this.subSessionTime;
    }

    public void setSubSessionTime(String subSessionTime) {
        this.subSessionTime = subSessionTime;
    }

    public int getSubExpiresIn() {
        return this.subExpiresIn;
    }

    public void setSubExpiresIn(int subExpiresIn) {
        this.subExpiresIn = subExpiresIn;
    }

    public int getSubExpiresInW2() {
        return this.subExpiresInW2;
    }

    public void setSubExpiresInW2(int subExpiresInW2) {
        this.subExpiresInW2 = subExpiresInW2;
    }

    public SellerCatRoot getSeRoot() {
        return this.seRoot;
    }

    public void setSeRoot(SellerCatRoot seRoot) {
        this.seRoot = seRoot;
    }

    public String getHourString() {
        int hour = DateTimes.getCurrentHour();
        switch (hour) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "\u51cc\u6668\u597d";
            }
            case 6: 
            case 7: {
                return "\u65e9\u4e0a\u597d";
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return "\u4e0a\u5348\u597d";
            }
            case 12: 
            case 13: {
                return "\u4e2d\u5348\u597d";
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return "\u4e0b\u5348\u597d";
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return "\u665a\u4e0a\u597d";
            }
        }
        return "\u60a8\u597d";
    }

    public String getVersionDesc() throws Exception {
        SysArticle article = ArticleDao.item(this.user.getVersionNo());
        if (article == null) {
            return "\u4e34\u65f6\u7248";
        }
        return article.getItemName();
    }

    public String getExpireInTime() {
        String sessionTime = this.user.getSessionTime();
        int seconds = this.user.getExpiresIn();
        String dateTime = DateTimes.getNextDateTimeStringBySecond((String)sessionTime, (int)seconds);
        return dateTime;
    }

    public int getExpireDayNum() {
        String endDate = this.getGiftEndDate();
        String curDate = DateTimes.getDateString();
        return DateTimes.compareDay((String)endDate, (String)curDate) - 1;
    }

    public String getShopUrl() {
        return "http://shop" + this.getShopId() + ".taobao.com";
    }

    public String getShopPic() {
        String shopPic = this.user.getShopPic();
        if (Validates.isEmpty((String)shopPic)) {
            return "/ztmpl/res/shop_no_pic.gif";
        }
        return "http://logo.taobao.com/shop-logo" + shopPic;
    }

    public String getLevelDesc() {
        return this.getLevel(this.user.getLevel());
    }

    public String getLevel(int level) {
        String urlPre = "http://pics.taobaocdn.com/newrank/";
        switch (level) {
            case 1: {
                return String.valueOf(urlPre) + "s_red_1.gif";
            }
            case 2: {
                return String.valueOf(urlPre) + "s_red_2.gif";
            }
            case 3: {
                return String.valueOf(urlPre) + "s_red_3.gif";
            }
            case 4: {
                return String.valueOf(urlPre) + "s_red_4.gif";
            }
            case 5: {
                return String.valueOf(urlPre) + "s_red_5.gif";
            }
            case 6: {
                return String.valueOf(urlPre) + "s_blue_1.gif";
            }
            case 7: {
                return String.valueOf(urlPre) + "s_blue_2.gif";
            }
            case 8: {
                return String.valueOf(urlPre) + "s_blue_3.gif";
            }
            case 9: {
                return String.valueOf(urlPre) + "s_blue_4.gif";
            }
            case 10: {
                return String.valueOf(urlPre) + "s_blue_5.gif";
            }
            case 11: {
                return String.valueOf(urlPre) + "s_cap_1.gif";
            }
            case 12: {
                return String.valueOf(urlPre) + "s_cap_2.gif";
            }
            case 13: {
                return String.valueOf(urlPre) + "s_cap_3.gif";
            }
            case 14: {
                return String.valueOf(urlPre) + "s_cap_4.gif";
            }
            case 15: {
                return String.valueOf(urlPre) + "s_cap_5.gif";
            }
            case 16: {
                return String.valueOf(urlPre) + "s_crown_1.gif";
            }
            case 17: {
                return String.valueOf(urlPre) + "s_crown_2.gif";
            }
            case 18: {
                return String.valueOf(urlPre) + "s_crown_3.gif";
            }
            case 19: {
                return String.valueOf(urlPre) + "s_crown_4.gif";
            }
            case 20: {
                return String.valueOf(urlPre) + "s_crown_5.gif";
            }
        }
        return "/ztmpl/res/s_red_0.gif";
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public boolean isWebLogin() {
        return this.from == 0;
    }

    public boolean isPcLogin() {
        return this.from == 1;
    }

    public boolean isMobileLogin() {
        return this.from == 2;
    }

    public boolean isHasSubNick() {
        return this.hasSubNick;
    }

    public void setHasSubNick(boolean hasSubNick) {
        this.hasSubNick = hasSubNick;
    }

    public List<SysArticle> getArticleList() throws Exception {
        return ArticleDao.list();
    }

    public String getItemName(int versionNo) throws Exception {
        SysArticle article = ArticleDao.item(versionNo);
        if (article == null) {
            return "\u4e34\u65f6\u7248";
        }
        return article.getItemName();
    }

    public boolean isAuthW2() {
        String sessionTime = this.getSessionTime();
        String dateTime = TaobaoService.getToolService().getTaobaoTime();
        return DateTimes.compareMinute((String)dateTime, (String)sessionTime) < 25 && Math.abs(1800 - this.getExpiresInW2()) <= 1;
    }

    public long getAuthW2() {
        if (this.getExpiresInW2() != 1800) {
            return 0L;
        }
        long sessionTime = DateTimes.toDate((String)this.getSessionTime()).getTime() + 1800000L;
        return sessionTime;
    }

    public int getAppRuleByUrl(String appUrl) throws Exception {
        SysPermission permission = PermissionDao.itemPermissionByUrl(appUrl);
        if (permission == null) {
            return 0;
        }
        return permission.getPermissionRule();
    }

    public boolean isAppPermissionUrl(String appUrl) throws Exception {
        return PermissionDao.isAppPermissionUrl(appUrl, this.getGiftVersionNo(), this.getCreateTime());
    }

    public String getAppPermissionId(String appUrl) throws Exception {
        SysPermission permission = PermissionDao.itemPermissionByUrl(appUrl);
        if (permission == null) {
            return null;
        }
        return permission.getPermissionId();
    }

    public boolean isClosePopup() {
        return this.isClosePopup;
    }

    public void setClosePopup() {
        this.isClosePopup = true;
    }

    public SysPopup getPopup() {
        return this.popup;
    }

    public String getPopupHtml() {
        if (this.popup == null) {
            return null;
        }
        String html = this.popup.getPopupFtl();
        html = html.replaceAll("\r", "");
        html = html.replaceAll("\n", "");
        return html;
    }

    public boolean isPopup() throws Exception {
        if (this.isClosePopup) {
            return false;
        }
        if (this.popup != null) {
            return true;
        }
        Selector selector = new Selector("popupStatus", (Object)1);
        selector.addOrderbyAsc("popupIndex");
        List validPopupList = ((ZTable)Global.get(ZTable.class)).list(SysPopup.class, selector);
        if (validPopupList == null || validPopupList.isEmpty()) {
            return false;
        }
        int userVersion = this.getGiftVersionNo();
        int exprieDayNum = this.getExpireDayNum();
        for (SysPopup popup : validPopupList) {
            int expireDay;
            if (userVersion < popup.getLowestVersion() || userVersion > popup.getHighestVersion() || (expireDay = popup.getExpireDay()) > 0 && exprieDayNum > expireDay) continue;
            if (this.isWebLogin() && popup.getPopupType() == 0) {
                this.popup = popup;
                return true;
            }
            if (!this.isPcLogin() || popup.getPopupType() != 1) continue;
            this.popup = popup;
            return true;
        }
        return false;
    }

    public boolean isCloseTopNotice() {
        return this.isCloseTopNotice;
    }

    public void setCloseTopNotice() {
        this.isCloseTopNotice = true;
    }

    public boolean isTopNotice() throws ORMException, SQLException {
        return false;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public boolean isUpdateData() {
        return this.isUpdateData;
    }

    public void setUpdateData(boolean isUpdateData) {
        this.isUpdateData = isUpdateData;
    }

    public boolean isTestFunctionNick() {
        String[] nicks;
        String nickstr = Global.getString((String)"project", (String)"testFunctionNick");
        if (Validates.isEmpty((String)nickstr)) {
            return false;
        }
        String nick = this.getNick();
        String[] stringArray = nicks = nickstr.split(",");
        int n = nicks.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (nick.equals(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getLowestDiscount() {
        return Validates.isEmpty((String)this.user.getLowestDiscount()) ? "7.00" : this.user.getLowestDiscount();
    }

    public void setLowestDiscount(String lowestDiscount) {
        this.user.setLowestDiscount(lowestDiscount);
    }

    public void doRefreshUserInfo() {
    }

    @Deprecated
    public void setValueClean(String key) {
        this.removeValue(key);
    }
}

