/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.message;

import java.util.Map;
import java.util.TreeMap;
import net.redxyz.top.message.TaobaoResponse;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.MD5;

public abstract class TaobaoRequest<T extends TaobaoResponse> {
    private String method;
    private String session;
    private String timestamp;
    private String format = "json";
    private String v = "2.0";
    private String sign;
    private String signMethod = "md5";
    private TreeMap<String, String> paramMap = new TreeMap();
    private int connectResetTimes = 0;

    public TaobaoRequest() {
        this.timestamp = DateTimes.getDateTimeString();
        this.method = this.getMethod();
    }

    public abstract String getMethod();

    public abstract String getNick();

    public abstract T getResponse();

    protected abstract void buildSignBody();

    protected void addParam(String key, int value) {
        if (value == 0) {
            return;
        }
        this.paramMap.put(key, "" + value);
    }

    protected void addParam(String key, long value) {
        if (value == 0L) {
            return;
        }
        this.paramMap.put(key, "" + value);
    }

    protected void addParam(String key, Object value) {
        if (value == null) {
            return;
        }
        this.paramMap.put(key, Jsons.toString((Object)value));
    }

    protected void addParam(String key, String value) {
        if (Validates.isEmpty((String)value)) {
            return;
        }
        this.paramMap.put(key, value);
    }

    protected void addParam(String key, boolean value) {
        this.paramMap.put(key, "" + value);
    }

    protected void addParam(String key, byte[] value) {
        if (value.length == 0) {
            return;
        }
        this.paramMap.put(key, value.toString());
    }

    public void buildSign(String appKey, String appSecret) {
        this.addParam("method", this.method);
        this.addParam("session", this.session);
        this.addParam("timestamp", this.timestamp);
        this.addParam("format", this.format);
        this.addParam("app_key", appKey);
        this.addParam("v", this.v);
        this.addParam("sign_method", this.signMethod);
        this.buildSignBody();
        StringBuffer strb = new StringBuffer(appSecret);
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            strb.append(entry.getKey()).append(entry.getValue());
        }
        strb.append(appSecret);
        this.sign = MD5.encodeUTF8((String)strb.toString()).toUpperCase();
    }

    public String buildQueryString() {
        StringBuffer strb = new StringBuffer("sign=").append(this.sign);
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            String value = Urls.encodeUTF8((String)entry.getValue());
            strb.append("&").append(entry.getKey()).append("=").append(value);
        }
        return strb.toString();
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFormat() {
        return this.format;
    }

    public String getV() {
        return this.v;
    }

    public String getSign() {
        return this.sign;
    }

    public boolean isOverConnectionTimes() {
        return ++this.connectResetTimes > 3;
    }

    public String toString() {
        return new StringBuffer("TaobaoRequest[").append("method:").append(this.method).append(";").append("nick:").append(this.getNick()).append(";").append("session:").append(this.session).append(";").append("timestamp:").append(this.timestamp).append(";").append("]").toString();
    }

    void setMethod(String method) {
        this.method = method;
    }
}

