/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.manage.user;

import java.util.Map;
import net.redxyz.top.dbo.user.UserOrder;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

public class UserOrderListAction
implements Action {
    public void execute(HttpRequest request) throws Exception {
        request.setResponsePrivateCache();
        int currentPage = request.getParameterInt("page", 1);
        int pageSize = 10;
        String nick = request.getParameter("nick");
        int versionNo = request.getParameterInt("versionNo", -1);
        String orderBeginDate = request.getParameter("orderBeginDate");
        String orderEndDate = request.getParameter("orderEndDate");
        String amount = request.getParameter("amount");
        String maxAmount = request.getParameter("maxAmount");
        int bizType = request.getParameterInt("bizType", -1);
        String orderCycle = request.getParameter("orderCycle");
        String endDate = request.getParameter("endDate");
        if (orderBeginDate == null) {
            orderBeginDate = DateTimes.getDateString();
        }
        Selector sel = new Selector();
        sel.addMaybeLike("nick", (Object)nick);
        if (versionNo > -1) {
            sel.addMaybe("versionNo", (Object)versionNo);
        }
        if (Validates.isNotEmpty((String)orderBeginDate)) {
            sel.addMaybeThenGE("orderTime", (Object)(String.valueOf(orderBeginDate) + " 00:00:00"));
        }
        if (Validates.isNotEmpty((String)orderEndDate)) {
            sel.addMaybeThenLE("orderTime", (Object)(String.valueOf(orderEndDate) + " 23:59:59"));
        }
        if (Validates.isNotEmpty((String)endDate)) {
            sel.addMaybeThenGE("endTime", (Object)(String.valueOf(endDate) + " 00:00:00"));
            sel.addMaybeThenLE("endTime", (Object)(String.valueOf(endDate) + " 23:59:59"));
        }
        if (Validates.isInteger((String)amount)) {
            sel.addMaybeThenGE("totalPayFee", (Object)amount);
        }
        if (Validates.isInteger((String)maxAmount)) {
            sel.addMaybeThenLE("totalPayFee", (Object)maxAmount);
        }
        if (bizType > 0) {
            sel.addMaybe("bizType", (Object)bizType);
        }
        sel.addMaybe("orderCycle", (Object)orderCycle);
        sel.addOrderbyDesc("orderTime");
        PageResult pageResult = ((ZTable)Global.get(ZTable.class)).page(UserOrder.class, currentPage, pageSize, sel);
        pageResult.addConditionMap((Map)request.getParameterMap());
        long totalAmount = ((ZTable)Global.get(ZTable.class)).sum(UserOrder.class, sel, "totalPayFee");
        request.setAttribute("totalAmount", (Object)totalAmount);
        request.setAttribute("pageResult", (Object)pageResult);
        request.setAttribute("orderBeginDate", (Object)orderBeginDate);
        request.setAttribute("amount", (Object)amount);
        request.setAttribute("maxAmount", (Object)maxAmount);
    }
}

