/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.manage.app;

import java.util.List;
import net.redxyz.top.dbo.sys.SysSmsProduct;
import net.redxyz.top.dbo.user.UserSmsCharge;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.ones.IsNumericLen;
import org.zhiqim.httpd.validate.ones.IsSelect;
import org.zhiqim.httpd.validate.onex.IsAmount2R;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.Global;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class SmsProductAction
extends StdSwitchAction {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsNumericLen("productId", "\u8bf7\u9009\u62e9\u4ea7\u54c1", 16, 16));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsNumericLen("productId", "\u4ea7\u54c1\u7f16\u53f7\u5fc5\u987b16\u4f4d", 16, 16));
        request.addValidate((Validate)new IsSelect("productStatus", "\u8bf7\u9009\u62e9\u5546\u54c1\u72b6\u6001"));
        request.addValidate((Validate)new IsNotEmpty("productName", "\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsAmount2R("productPrice", "\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4ea7\u54c1\u4ef7\u683c"));
        request.addValidate((Validate)new IsInteger("buySmsNum", "\u8bf7\u586b\u5199\u8d2d\u4e70\u77ed\u4fe1\u6761\u6570"));
        request.addValidate((Validate)new IsInteger("giftSmsNum", "\u8bf7\u586b\u5199\u8d60\u9001\u77ed\u4fe1\u6761\u6570"));
    }

    protected void list(HttpRequest request) throws Exception {
        List productList = ((ZTable)Global.get(ZTable.class)).list(SysSmsProduct.class);
        request.setAttribute("productList", (Object)productList);
    }

    protected void add(HttpRequest request) throws Exception {
        request.setResponsePrivateCache();
    }

    protected void modify(HttpRequest request) throws Exception {
        request.setResponsePrivateCache();
        long productId = request.getParameterLong("productId");
        if (productId == -1L) {
            request.returnHistory("\u8bf7\u9009\u62e9\u4e00\u4e2a\u4ea7\u54c1");
            return;
        }
        SysSmsProduct product = (SysSmsProduct)((ZTable)Global.get(ZTable.class)).item(SysSmsProduct.class, new Object[]{productId});
        request.setAttribute("product", (Object)product);
    }

    protected void insert(HttpRequest request) throws Exception {
        SysSmsProduct product = (SysSmsProduct)request.getParameter(SysSmsProduct.class);
        int productAmount = request.getParameterAmount2R("productPrice");
        product.setProductAmount(productAmount);
        ((ZTable)Global.get(ZTable.class)).insert((Object)product);
    }

    protected void update(HttpRequest request) throws Exception {
        SysSmsProduct product = (SysSmsProduct)request.getParameter(SysSmsProduct.class);
        int productAmount = request.getParameterAmount2R("productPrice");
        product.setProductAmount(productAmount);
        Updater updater = new Updater();
        updater.addMaybe("productId", (Object)product.getProductId());
        updater.addField("productStatus", (Object)product.getProductStatus());
        updater.addField("productName", (Object)product.getProductName());
        updater.addField("productAmount", (Object)productAmount);
        updater.addField("buySmsNum", (Object)product.getBuySmsNum());
        updater.addField("giftSmsNum", (Object)product.getGiftSmsNum());
        ((ZTable)Global.get(ZTable.class)).update(SysSmsProduct.class, updater);
    }

    protected void delete(HttpRequest request) throws Exception {
        long productId = request.getParameterLong("productId");
        if (((ZTable)Global.get(ZTable.class)).count(UserSmsCharge.class, new Selector("productId", (Object)productId)) > 0) {
            request.returnHistory("\u8be5\u4ea7\u54c1\u6709\u5145\u503c\u8bb0\u5f55\uff0c\u4e0d\u80fd\u5220\u9664");
            return;
        }
        ((ZTable)Global.get(ZTable.class)).delete(SysSmsProduct.class, new Object[]{productId});
    }
}

