/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.data.item;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileItem {
    private String fileName;
    private String mimeType;
    private byte[] content;
    private File file;

    public FileItem(File file) {
        this.file = file;
    }

    public FileItem(String filePath) {
        this(new File(filePath));
    }

    public FileItem(String fileName, byte[] content) {
        this.fileName = fileName;
        this.content = content;
    }

    public FileItem(String fileName, byte[] content, String mimeType) {
        this(fileName, content);
        this.mimeType = mimeType;
    }

    public String getFileName() {
        if (this.fileName == null && this.file != null && this.file.exists()) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            this.mimeType = FileItem.getMimeType(this.getContent());
        }
        return this.mimeType;
    }

    public byte[] getContent() throws IOException {
        if (this.content == null && this.file != null && this.file.exists()) {
            FileInputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                int ch;
                in = new FileInputStream(this.file);
                out = new ByteArrayOutputStream();
                while ((ch = ((InputStream)in).read()) != -1) {
                    out.write(ch);
                }
                this.content = out.toByteArray();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        return this.content;
    }

    private static String getMimeType(byte[] bytes) {
        String suffix = FileItem.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    private static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }
}

