/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import net.redxyz.top.TaobaoErrHandler;
import net.redxyz.top.TaobaoInterface;
import net.redxyz.top.TaobaoServer;
import net.redxyz.top.message.ErrorResponse;
import net.redxyz.top.message.TaobaoRequest;
import net.redxyz.top.message.TaobaoResponse;
import net.redxyz.top.message.TaobaoUploader;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.httpclient.HttpGet;
import org.zhiqim.kernel.httpclient.HttpPost;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.httpclient.HttpUpload;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Validates;

public class TaobaoInterfaceImpl
implements TaobaoInterface,
CodeConstants {
    private static final Log log = LogFactory.getLog((String)"taobao.interface.log");
    private TaobaoServer server;
    private TaobaoErrHandler handler;
    private Certificate verisign;

    public TaobaoInterfaceImpl(TaobaoServer server, TaobaoErrHandler handler) {
        if (server == null || !server.isValid()) {
            throw new RuntimeException("\u672a\u4f20\u5165\u53c2\u6570\u6216\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        this.server = server;
        this.handler = handler;
        InputStream input = null;
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                input = Resources.getResourceStream(TaobaoInterfaceImpl.class, (String)"/net/redxyz/top/verisign.crt");
                this.verisign = cf.generateCertificate(input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public HttpResult invokeToken(String queryString) {
        HttpPost conn = new HttpPost(this.server.getAppTokenUrl());
        conn.setConnectionClose();
        conn.setConnectTimeout(this.server.getAppConnectTimeout());
        conn.setReadTimeout(this.server.getAppReadTimeout());
        conn.setQueryString(queryString, "UTF-8");
        conn.execute();
        return conn.getResult();
    }

    @Override
    public <T extends TaobaoResponse> T invokeTaobaoService(TaobaoRequest<T> req) {
        T resp = req.getResponse();
        if (!this.isValid()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u63a5\u53e3\u65f6\uff0c\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf"));
            ((TaobaoResponse)resp).buildResponseError(1, "\u524d\u7f6e\u9519\u8bef", "701", "\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf", req.getClass().toString());
            return resp;
        }
        req.buildSign(this.server.getAppKey(), this.server.getAppSecret());
        String queryString = req.buildQueryString();
        HttpPost client = null;
        if (req instanceof TaobaoUploader) {
            TaobaoUploader upload = (TaobaoUploader)((Object)req);
            String fieldName = upload.getFieldName();
            String fileName = upload.getFileName();
            byte[] fileContent = upload.getContent();
            String suffix = upload.getSuffix();
            HttpUpload conn = new HttpUpload(this.server.getCurrentApiPath());
            conn.setMimeType("img/" + suffix);
            conn.setQueryString(queryString, true);
            conn.setContent(fieldName, fileName, fileContent, "UTF-8");
            client = conn;
        } else {
            HttpPost conn = new HttpPost(this.server.getCurrentApiPath());
            if (this.server.isForward()) {
                conn.setQueryString(queryString, "text/plain", "UTF-8");
            } else {
                conn.setQueryString(queryString, "UTF-8");
            }
            client = conn;
        }
        client.setConnectTimeout(this.server.getAppConnectTimeout());
        client.setReadTimeout(this.server.getAppReadTimeout());
        client.execute();
        int responseStatus = client.getResponseStatus();
        String responseText = client.getResponseText();
        if (responseStatus != 200) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u63a5\u53e3HTTP\u9519\u8bef,\u9519\u8bef\u7801[" + responseStatus + "],\u8bf7\u6c42:[" + req.toString() + "]"));
            ((TaobaoResponse)resp).buildResponseError(2, "\u6dd8\u5b9dHTTP\u54cd\u5e94\u9519\u8bef", "" + responseStatus, responseText, req.getClass().toString());
            return resp;
        }
        ((TaobaoResponse)resp).buildResponseText(responseText);
        if (!((TaobaoResponse)resp).isSuccess()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u63a5\u53e3\u65f6\u6dd8\u5b9d\u54cd\u5e94\u9519\u8bef\u4fe1\u606f,\u8bf7\u6c42:[" + req.toString() + "],\u54cd\u5e94[" + ((TaobaoResponse)resp).toString() + "]"));
            if (this.handler != null) {
                try {
                    this.handler.handle(req, ((TaobaoResponse)resp).getError());
                }
                catch (Exception exception) {}
            }
        }
        return resp;
    }

    @Override
    public <T extends TaobaoResponse> T invokeTaobaoSecretService(TaobaoRequest<T> req) {
        T resp = req.getResponse();
        if (!this.isValid()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u5b58\u50a8\u52a0\u5bc6\u63a5\u53e3\u65f6\uff0c\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf"));
            ((TaobaoResponse)resp).buildResponseError(1, "\u524d\u7f6e\u9519\u8bef", "701", "\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf", req.getClass().toString());
            return resp;
        }
        req.buildSign(this.server.getAppKey(), this.server.getAppSecret());
        String queryString = req.buildQueryString();
        HttpPost conn = new HttpPost(this.server.getCurrentSecretApiPath());
        if (this.server.isSecretForward()) {
            conn.setQueryString(queryString, "text/plain", "UTF-8");
        } else {
            conn.setQueryString(queryString, "UTF-8");
        }
        HttpPost client = conn;
        client.setConnectTimeout(this.server.getAppConnectTimeout());
        client.setReadTimeout(this.server.getAppReadTimeout());
        client.execute();
        int responseStatus = client.getResponseStatus();
        String responseText = client.getResponseText();
        if (responseStatus != 200) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u5b58\u50a8\u52a0\u5bc6\u63a5\u53e3HTTPS\u9519\u8bef,\u9519\u8bef\u7801[" + responseStatus + "],\u8bf7\u6c42:[" + req.toString() + "]"));
            ((TaobaoResponse)resp).buildResponseError(2, "\u6dd8\u5b9d\u5b58\u50a8\u52a0\u5bc6HTTPS\u54cd\u5e94\u9519\u8bef", "" + responseStatus, responseText, req.getClass().toString());
            return resp;
        }
        ((TaobaoResponse)resp).buildResponseText(responseText);
        if (!((TaobaoResponse)resp).isSuccess()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u5b58\u50a8\u52a0\u5bc6\u63a5\u53e3\u65f6\u6dd8\u5b9d\u54cd\u5e94\u9519\u8bef\u4fe1\u606f,\u8bf7\u6c42:[" + req.toString() + "],\u54cd\u5e94[" + ((TaobaoResponse)resp).toString() + "]"));
            if (this.handler != null) {
                try {
                    this.handler.handle(req, ((TaobaoResponse)resp).getError());
                }
                catch (Exception exception) {}
            }
        }
        return resp;
    }

    @Override
    public String invokeTaobaoPageGet(HashMapSO paramMap) {
        HttpPost client = null;
        if (this.server.isTaobaoPageForward()) {
            HttpPost conn = new HttpPost(this.server.getTaobaoPageGetUrl());
            String queryString = Jsons.toString((Object)paramMap);
            conn.setQueryString(queryString, "text/plain", "UTF-8");
            client = conn;
        } else {
            String url = (String)paramMap.get("url");
            String referer = (String)paramMap.get("referer");
            String host = (String)paramMap.get("host");
            client = new HttpGet(url);
            client.setConnectionClose();
            client.addRequestProperty("Accept", "*/*");
            if (Validates.isNotEmpty((String)referer)) {
                client.addRequestProperty("Referer", referer);
            }
            client.addRequestProperty("Accept-Language", "zh-cn");
            client.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:55.0) Gecko/20100101 Firefox/55.0");
            client.addRequestProperty("Accept-Encoding", "gzip, deflate");
            if (Validates.isNotEmpty((String)host)) {
                client.addRequestProperty("Host", host);
            }
        }
        client.execute();
        int responseStatus = client.getResponseStatus();
        if (responseStatus != 200) {
            log.error((Object)("\u67e5\u8be2\u5931\u8d25\uff0c{responseStatus\uff1a" + responseStatus + ",responseText:\"" + client.getResponseText() + "\";"));
            return "";
        }
        String responseText = client.getResponseText();
        return responseText;
    }

    @Override
    public String invokeTaobaoService(String queryString) {
        if (!this.isValid()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u63a5\u53e3\u65f6\uff0c\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf"));
            return new ErrorResponse(1, "\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf").toString();
        }
        HttpPost conn = new HttpPost(this.server.getAppApiUrl());
        conn.setConnectionClose();
        conn.setConnectTimeout(this.server.getAppConnectTimeout());
        conn.setReadTimeout(this.server.getAppReadTimeout());
        conn.setQueryString(queryString, "UTF-8");
        conn.execute();
        int responseStatus = conn.getResponseStatus();
        String responseText = conn.getResponseText();
        if (responseStatus != 200) {
            return new ErrorResponse(1, responseText).toString();
        }
        return responseText;
    }

    @Override
    public String invokeTaobaoSecretService(String queryString) {
        if (!this.isValid()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u5b58\u50a8\u52a0\u5bc6\u63a5\u53e3\u65f6\uff0c\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf"));
            return new ErrorResponse(1, "\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf").toString();
        }
        HttpPost conn = new HttpPost(this.server.getSecretServerUrl());
        conn.setConnectionClose();
        conn.setConnectTimeout(this.server.getAppConnectTimeout());
        conn.setReadTimeout(this.server.getAppReadTimeout());
        conn.setQueryString(queryString, "UTF-8");
        conn.execute();
        int responseStatus = conn.getResponseStatus();
        String responseText = conn.getResponseText();
        if (responseStatus != 200) {
            return new ErrorResponse(1, responseText).toString();
        }
        return responseText;
    }

    @Override
    public String invokeTaobaoService(String name, String fileName, String mimeType, byte[] fileContent, String queryString) {
        if (!this.isValid()) {
            log.error((Object)("\u8c03\u7528\u6dd8\u5b9d\u63a5\u53e3\u65f6\uff0c\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf"));
            return new ErrorResponse(1, "\u8d85\u8fc7\u7cfb\u7edf\u5b9a\u4e49\u7684[" + this.server.getAppInvokeNum() + "]\u8c03\u7528\u91cf").toString();
        }
        HttpUpload conn = new HttpUpload(this.server.getAppApiUrl());
        conn.setConnectionClose();
        conn.setConnectTimeout(this.server.getAppConnectTimeout());
        conn.setReadTimeout(this.server.getAppReadTimeout());
        conn.setMimeType(mimeType);
        conn.setQueryString(queryString, true);
        conn.setContent(name, fileName, fileContent, "UTF-8");
        conn.execute();
        int responseStatus = conn.getResponseStatus();
        String responseText = conn.getResponseText();
        if (responseStatus != 200) {
            return new ErrorResponse(1, responseText).toString();
        }
        return responseText;
    }

    @Override
    public <T extends TaobaoResponse> T invokeSearch(TaobaoRequest<T> req) {
        T resp = req.getResponse();
        if (Validates.isEmpty((String)this.server.getItemsgetUrl())) {
            log.error((Object)"\u8c03\u7528\u5c0f\u535a\u58eb\u67e5\u8be2\u5b9d\u8d1d\u63a5\u53e3\u65f6\uff0c\u6ca1\u6709\u586b\u5199\u5bf9\u5e94\u7684URL");
            ((TaobaoResponse)resp).buildResponseError(1, "\u524d\u7f6e\u9519\u8bef", "702", "\u8c03\u7528\u5c0f\u535a\u58eb\u67e5\u8be2\u5b9d\u8d1d\u63a5\u53e3\u65f6\uff0c\u6ca1\u6709\u586b\u5199\u5bf9\u5e94\u7684URL", req.getClass().toString());
            return resp;
        }
        req.buildSign(this.server.getAppKey(), this.server.getAppApiUrl());
        String queryString = req.buildQueryString();
        HttpPost conn = new HttpPost(this.server.getItemsgetUrl());
        conn.setConnectionClose();
        conn.setConnectTimeout(this.server.getAppConnectTimeout());
        conn.setReadTimeout(this.server.getAppReadTimeout());
        conn.setQueryString(queryString, "UTF-8");
        conn.execute();
        int responseStatus = conn.getResponseStatus();
        String responseText = conn.getResponseText();
        if (responseStatus != 200) {
            log.error((Object)("\u8c03\u7528\u535a\u58eb\u67e5\u8be2\u5b9d\u8d1d\u63a5\u53e3HTTP\u9519\u8bef,\u9519\u8bef\u7801[" + responseStatus + "],\u8bf7\u6c42:[" + req.toString() + "],\u54cd\u5e94[" + ((TaobaoResponse)resp).toString() + "]"));
            ((TaobaoResponse)resp).buildResponseError(2, "\u8c03\u7528\u535a\u58eb\u67e5\u8be2\u5b9d\u8d1d\u63a5\u53e3HTTP\u9519\u8bef", "" + responseStatus, responseText, req.getClass().toString());
            return resp;
        }
        ((TaobaoResponse)resp).buildResponseText(responseText);
        return resp;
    }

    public String invokeTaobaoPageGet(String queryString) {
        HashMapSO paramMap = Jsons.toMapSO((String)queryString.replace("\\", ""));
        return this.invokeTaobaoPageGet(paramMap);
    }

    public class VerisignTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Exception exp = null;
            X509Certificate[] x509CertificateArray = chain;
            int n = chain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                cert.checkValidity();
                try {
                    cert.verify(TaobaoInterfaceImpl.this.verisign.getPublicKey());
                    exp = null;
                    break;
                }
                catch (Exception e) {
                    exp = e;
                    ++n2;
                }
            }
            if (exp != null) {
                throw new CertificateException(exp);
            }
        }
    }
}

