/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.order.server.paceket;

import java.util.HashMap;
import net.redxyz.order.server.paceket.ErrorServerResponse;
import net.redxyz.order.server.paceket.PacketConstants;
import net.redxyz.order.server.paceket.PacketServerRequest;
import net.redxyz.order.server.paceket.PacketServerResponse;
import net.redxyz.order.server.paceket.cainiao.PrintStdtemplatesGetRequest;
import net.redxyz.order.server.paceket.cainiao.WaybillCancelRequest;
import net.redxyz.order.server.paceket.cainiao.WaybillGetRequest;
import net.redxyz.order.server.paceket.cainiao.WaybillProductRequest;
import net.redxyz.order.server.paceket.cainiao.WaybillQueryByWaybillcodeRequest;
import net.redxyz.order.server.paceket.cainiao.WaybillSearchRequest;
import net.redxyz.order.server.paceket.cainiao.WaybillUpdateRequest;
import net.redxyz.order.server.paceket.delivery.LogisticsAddressSearchRequest;
import net.redxyz.order.server.paceket.delivery.LogisticsCompaniesGetRequest;
import net.redxyz.order.server.paceket.delivery.LogisticsDummySendRequest;
import net.redxyz.order.server.paceket.delivery.LogisticsOfflineSendRequest;
import net.redxyz.order.server.paceket.order.OrderAddressUpdateRequest;
import net.redxyz.order.server.paceket.order.OrderBuyerNickGetRequest;
import net.redxyz.order.server.paceket.order.OrderMemoUpdateRequest;
import net.redxyz.order.server.paceket.order.OrderTidGetRequest;
import net.redxyz.order.server.paceket.order.OrderTidSyncRequest;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.control.Handler;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Validates;

public class PacketController
extends Servicer
implements PacketConstants {
    private static final Log log = LogFactory.getLog(PacketController.class);
    private static final int TEN_MINUTE = 600000;
    private static final HashMap<String, Class<?>> requests = new HashMap();
    private static final HashMap<Class<?>, Handler> handlers = new HashMap();

    public boolean create() throws Exception {
        PacketController.init();
        Group group = Global.getGroup((String)this.getId());
        for (Item item : group.list()) {
            Object handler;
            String objClassName;
            block4: {
                objClassName = item.getKey();
                String handlerClassName = item.getString();
                try {
                    Class<?> handlerClass = Global.getClassLoader().loadClass(handlerClassName);
                    handler = handlerClass.newInstance();
                    if (handler instanceof Handler) break block4;
                    log.error((Object)"HandlerController\u6dfb\u52a0\u914d\u7f6e\u65f6[%s]\u7c7b\u672a\u5b9e\u73b0Handler\u63a5\u53e3", new Object[]{handlerClassName});
                    return false;
                }
                catch (Exception e) {
                    log.error((Object)"HandlerController\u6dfb\u52a0\u914d\u7f6e\u65f6[%s][%s]\u7c7b\u7684\u914d\u7f6e\u4e0d\u6b63\u786e", (Throwable)e, new Object[]{objClassName, handlerClassName});
                    return false;
                }
            }
            Class<?> clazz = Global.getClassLoader().loadClass(objClassName);
            handlers.put(clazz, (Handler)handler);
        }
        return true;
    }

    public static void init() {
        requests.put("order.memo.update", OrderMemoUpdateRequest.class);
        requests.put("order.tid.get", OrderTidGetRequest.class);
        requests.put("order.buyerNick.get", OrderBuyerNickGetRequest.class);
        requests.put("order.tid.sync", OrderTidSyncRequest.class);
        requests.put("taobao.trade.shippingaddress.update", OrderAddressUpdateRequest.class);
        requests.put("taobao.logistics.companies.get", LogisticsCompaniesGetRequest.class);
        requests.put("taobao.logistics.address.search", LogisticsAddressSearchRequest.class);
        requests.put("taobao.logistics.offline.send", LogisticsOfflineSendRequest.class);
        requests.put("taobao.logistics.dummy.send", LogisticsDummySendRequest.class);
        requests.put("cainiao.waybill.ii.search", WaybillSearchRequest.class);
        requests.put("cainiao.cloudprint.stdtemplates.get", PrintStdtemplatesGetRequest.class);
        requests.put("cainiao.waybill.ii.product", WaybillProductRequest.class);
        requests.put("cainiao.waybill.ii.get", WaybillGetRequest.class);
        requests.put("cainiao.waybill.ii.update", WaybillUpdateRequest.class);
        requests.put("cainiao.waybill.ii.cancel", WaybillCancelRequest.class);
        requests.put("cainiao.waybill.ii.query.by.waybillcode", WaybillQueryByWaybillcodeRequest.class);
    }

    public static PacketServerRequest<PacketServerResponse> getRequest(String method) {
        Class<?> clazz = requests.get(method);
        try {
            return (PacketServerRequest)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Handler getHandler(PacketServerRequest<PacketServerResponse> req) {
        return handlers.get(req.getClass());
    }

    public static boolean validateSysParam(ErrorServerResponse error, String method, String timestamp, String nick, String sign) {
        if (Validates.isEmpty((String)method) || !Validates.isDateTime((String)timestamp) || Validates.isEmpty((String)nick) || !Validates.isMD5String((String)sign)) {
            error.setError(2, "\u7cfb\u7edf\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
            return false;
        }
        if (!requests.containsKey(method.trim())) {
            error.setError(2, "\u8f93\u5165\u7cfb\u7edf\u53c2\u6570[method]\u6709\u8bef");
            return false;
        }
        long diffTime = System.currentTimeMillis() - DateTimes.toLong((String)timestamp);
        if (diffTime > 0L && diffTime > 600000L || diffTime < 0L && diffTime < -600000L) {
            error.setError(2, "\u8f93\u5165\u7cfb\u7edf\u53c2\u6570[timestamp]\u6709\u8bef\uff0c\u8bef\u5dee\u53ea\u5141\u8bb8\u572810\u5206\u949f\u4ee5\u5185");
            return false;
        }
        return true;
    }
}

