/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.order.client;

import org.zhiqim.kernel.util.Validates;

public class RestClientParameter {
    private String restUrl = "http://word.redxyz.com/rest.htm";
    private String nick;
    private String nickSecret;
    private String appKey;
    private String appSecret;
    private int connectTimeout = 10;
    private int readTimeout = 30;

    public RestClientParameter() {
    }

    public RestClientParameter(String appKey, String appSecret, String restUrl) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.restUrl = restUrl;
    }

    public boolean isValid() {
        if (Validates.isNotEmptyBlank((String)this.appKey) && Validates.isNotEmptyBlank((String)this.appSecret) && Validates.isNotEmptyBlank((String)this.nick)) {
            return true;
        }
        return !Validates.isEmptyBlank((String)this.restUrl) && !Validates.isEmptyBlank((String)this.nick) && !Validates.isEmptyBlank((String)this.nickSecret);
    }

    public String getRestUrl() {
        return this.restUrl;
    }

    public String getNick() {
        return this.nick;
    }

    public String getNickSecret() {
        return this.nickSecret;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public int getConnectTime() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setRestUrl(String restUrl) {
        if (Validates.isEmptyBlank((String)restUrl)) {
            return;
        }
        this.restUrl = restUrl;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public void setNickSecret(String nickSecret) {
        this.nickSecret = nickSecret;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 10 || connectTimeout > 60) {
            return;
        }
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 10 || readTimeout > 180) {
            return;
        }
        this.readTimeout = readTimeout;
    }
}

