/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.model.serialize;

import com.aliyun.mq.http.common.ClientException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class XmlUtil {
    private static TransformerFactory transFactory = TransformerFactory.newInstance();
    public static final String PROPERTY_SEPARATOR = "|";
    public static final String PROPERTY_SEPARATOR_SPLIT = "\\|";
    public static final String PROPERTY_KV_SEPARATOR = ":";
    public static final String PROPERTY_KV_SEPARATOR_SPLIT = "\\:";

    public static void output(Node node, String encoding, OutputStream outputStream) throws TransformerException {
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        DOMSource source = new DOMSource();
        source.setNode(node);
        StreamResult result = new StreamResult();
        result.setOutputStream(outputStream);
        transformer.transform(source, result);
    }

    public static String xmlNodeToString(Node node, String encoding) throws TransformerException {
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        StringWriter strWtr = new StringWriter();
        DOMSource source = new DOMSource();
        source.setNode(node);
        StreamResult result = new StreamResult(strWtr);
        transformer.transform(source, result);
        return strWtr.toString();
    }

    public static String mapToString(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                XmlUtil.checkPropValid(name, value);
                sb.append(name);
                sb.append(PROPERTY_KV_SEPARATOR);
                sb.append(value);
                sb.append(PROPERTY_SEPARATOR);
            }
        }
        return sb.toString();
    }

    public static Map<String, String> stringTopMap(String input) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (input != null) {
            String[] items;
            for (String i : items = input.split(PROPERTY_SEPARATOR_SPLIT)) {
                String[] nv = i.split(PROPERTY_KV_SEPARATOR_SPLIT);
                if (2 != nv.length) continue;
                map.put(nv[0], nv[1]);
            }
        }
        return map;
    }

    public static void checkPropValid(String key, String value) {
        if (key == null || key.length() <= 0 || value == null || value.length() <= 0) {
            throw new ClientException("Message's property can't be null or empty", "Local");
        }
        if (XmlUtil.isContainSpecialChar(key) || XmlUtil.isContainSpecialChar(value)) {
            throw new ClientException("Message's property[" + key + PROPERTY_KV_SEPARATOR + value + "] can't contains: & \" ' < > : |", "LocalClientError");
        }
    }

    public static boolean isContainSpecialChar(String str) {
        return str.contains("&") || str.contains("\"") || str.contains("'") || str.contains("<") || str.contains(">") || str.contains(PROPERTY_KV_SEPARATOR) || str.contains(PROPERTY_SEPARATOR);
    }
}

