/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http;

import com.aliyun.mq.http.MQConsumer;
import com.aliyun.mq.http.MQProducer;
import com.aliyun.mq.http.MQTransProducer;
import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.auth.ServiceCredentials;
import com.aliyun.mq.http.common.http.ClientConfiguration;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.common.http.ServiceClientFactory;
import com.aliyun.mq.http.common.utils.Utils;
import java.net.URI;

public class MQClient {
    private URI endpoint;
    private ServiceClient serviceClient;
    private ServiceCredentials credentials;
    private ClientConfiguration config;

    public MQClient(String accountEndpoint, String accessId, String accessKey) {
        this(accountEndpoint, accessId, accessKey, null, null);
    }

    public MQClient(String accountEndpoint, String accessId, String accessKey, ClientConfiguration config) {
        this(accountEndpoint, accessId, accessKey, null, config);
    }

    public MQClient(String accountEndpoint, String accessId, String accessKey, String securityToken) {
        this(accountEndpoint, accessId, accessKey, securityToken, null);
    }

    public MQClient(String accountEndpoint, String accessId, String accessKey, String securityToken, ClientConfiguration config) {
        this.credentials = new ServiceCredentials(accessId, accessKey, securityToken);
        this.endpoint = Utils.getHttpURI(accountEndpoint);
        this.config = config == null ? new ClientConfiguration() : config;
        try {
            this.serviceClient = ServiceClientFactory.createServiceClient(this.config);
        }
        catch (Exception e) {
            if (this.serviceClient != null) {
                ServiceClientFactory.closeServiceClient(this.serviceClient);
            }
            throw new ClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MQClient mQClient = this;
        synchronized (mQClient) {
            if (this.isOpen()) {
                ServiceClientFactory.closeServiceClient(this.serviceClient);
            }
        }
    }

    public boolean isOpen() {
        return this.serviceClient != null && this.serviceClient.isOpen();
    }

    public MQProducer getProducer(String topicName) {
        return new MQProducer(null, topicName, this.serviceClient, this.credentials, this.endpoint);
    }

    public MQProducer getProducer(String instanceId, String topicName) {
        return new MQProducer(instanceId, topicName, this.serviceClient, this.credentials, this.endpoint);
    }

    public MQTransProducer getTransProducer(String topicName, String groupId) {
        return new MQTransProducer(null, topicName, groupId, this.serviceClient, this.credentials, this.endpoint);
    }

    public MQTransProducer getTransProducer(String instanceId, String topicName, String groupId) {
        return new MQTransProducer(instanceId, topicName, groupId, this.serviceClient, this.credentials, this.endpoint);
    }

    public MQConsumer getConsumer(String topicName, String consumer, String messageTag) {
        return new MQConsumer(null, topicName, consumer, messageTag, this.serviceClient, this.credentials, this.endpoint);
    }

    public MQConsumer getConsumer(String topicName, String consumer) {
        return new MQConsumer(null, topicName, consumer, null, this.serviceClient, this.credentials, this.endpoint);
    }

    public MQConsumer getConsumer(String instanceId, String topicName, String consumer, String messageTag) {
        return new MQConsumer(instanceId, topicName, consumer, messageTag, this.serviceClient, this.credentials, this.endpoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MQClient{");
        sb.append("endpoint=").append(this.endpoint);
        sb.append(", credentials=").append(this.credentials);
        sb.append('}');
        return sb.toString();
    }
}

