/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.process;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessEventListener;
import org.im4java.process.ProcessTask;

public class ProcessExecutor
extends ThreadPoolExecutor
implements ProcessEventListener {
    private Set<Process> iProcesses = new LinkedHashSet<Process>();
    private boolean iShutdownNowInProgress = false;

    public ProcessExecutor() {
        this(ProcessExecutor.getDefaultPoolSize());
    }

    public ProcessExecutor(int n) {
        super(n, n, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.prestartAllCoreThreads();
    }

    private static int getDefaultPoolSize() {
        String string = System.getProperty("im4java.maxProcs");
        int n = string == null || string.equals("auto") ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(string);
        return Math.max(1, n);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        if (this.iShutdownNowInProgress) {
            thread.stop();
            try {
                super.beforeExecute(thread, runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (runnable instanceof ProcessTask) {
            ProcessTask processTask = (ProcessTask)runnable;
            processTask.getProcessStarter().addProcessEventListener(this);
        }
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (runnable instanceof ProcessTask) {
            ProcessTask processTask = (ProcessTask)runnable;
            processTask.getProcessStarter().removeProcessEventListener(this);
        }
    }

    @Override
    public void processInitiated(ProcessEvent processEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStarted(ProcessEvent processEvent) {
        Set<Process> set = this.iProcesses;
        synchronized (set) {
            this.iProcesses.add(processEvent.getProcess());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTerminated(ProcessEvent processEvent) {
        Set<Process> set = this.iProcesses;
        synchronized (set) {
            this.iProcesses.remove(processEvent.getProcess());
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.iShutdownNowInProgress = true;
        this.destroy();
        return super.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Set<Process> set = this.iProcesses;
        synchronized (set) {
            Iterator<Process> iterator = this.iProcesses.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
        }
    }
}

