/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.shapes;

import com.aspose.imaging.Matrix;
import com.aspose.imaging.Pen;
import com.aspose.imaging.PointF;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.Shape;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aK.bf;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public abstract class RectangleProjectedShape
extends Shape {
    private final PointF a = new PointF();
    private final PointF b = new PointF();
    private final PointF c = new PointF();
    private final PointF d = new PointF();

    public RectangleProjectedShape() {
    }

    public RectangleProjectedShape(RectangleF rectangleF) {
        rectangleF.getLocation().CloneTo(this.a);
        this.b.setX(rectangleF.getRight());
        this.b.setY(rectangleF.getTop());
        this.d.setX(rectangleF.getRight());
        this.d.setY(rectangleF.getBottom());
        this.c.setX(rectangleF.getLeft());
        this.c.setY(rectangleF.getBottom());
    }

    public PointF getLeftTop() {
        return this.a;
    }

    public PointF getRightTop() {
        return this.b;
    }

    public PointF getLeftBottom() {
        return this.c;
    }

    public PointF getRightBottom() {
        return this.d;
    }

    @Override
    public PointF getCenter() {
        return bf.a(new PointF[]{this.a, this.b, this.c, this.d});
    }

    @Override
    public RectangleF getBounds() {
        return bf.b(new PointF[]{this.a, this.b, this.c, this.d});
    }

    public double getRectangleWidth() {
        return bf.a(this.a, this.b);
    }

    public double getRectangleHeight() {
        return bf.a(this.a, this.c);
    }

    @Override
    public boolean hasSegments() {
        return bf.a(this.a, this.b) > 0.0 && bf.a(this.a, this.c) > 0.0;
    }

    @Override
    public RectangleF getBounds(Matrix matrix) {
        return bf.a(new PointF[]{this.a, this.b, this.c, this.d}, matrix);
    }

    @Override
    public RectangleF getBounds(Matrix matrix, Pen pen) {
        throw new NotImplementedException();
    }

    @Override
    public void transform(Matrix matrix) {
        if (matrix == null) {
            throw new ArgumentNullException("transform");
        }
        PointF[] pointFArray = new PointF[]{this.a, this.b, this.c, this.d};
        matrix.transformPoints(pointFArray);
        pointFArray[0].CloneTo(this.a);
        pointFArray[1].CloneTo(this.b);
        pointFArray[2].CloneTo(this.c);
        pointFArray[3].CloneTo(this.d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RectangleProjectedShape)) {
            return false;
        }
        RectangleProjectedShape rectangleProjectedShape = (RectangleProjectedShape)object;
        return PointF.op_Equality(this.c, rectangleProjectedShape.c) && PointF.op_Equality(this.d, rectangleProjectedShape.d) && PointF.op_Equality(this.a, rectangleProjectedShape.a) && PointF.op_Equality(this.b, rectangleProjectedShape.b);
    }

    public int hashCode() {
        int n2 = this.a.hashCode();
        n2 = n2 * 397 ^ this.b.hashCode();
        n2 = n2 * 397 ^ this.c.hashCode();
        n2 = n2 * 397 ^ this.d.hashCode();
        return n2;
    }
}

