/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.magicwand.imagemasks;

import com.aspose.imaging.Point;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.magicwand.imagemasks.ImageBitMask;
import com.aspose.imaging.magicwand.imagemasks.ImageMask;

public class CircleMask
extends ImageMask {
    private Point a = new Point();
    private int b;

    @Override
    public Rectangle getSelectionBounds() {
        int n2 = this.a.getX() - this.b < 0 ? 0 : this.a.getX() - this.b;
        int n3 = this.a.getY() - this.b < 0 ? 0 : this.a.getY() - this.b;
        int n4 = this.a.getX() + this.b - n2 + 1;
        int n5 = this.a.getY() + this.b - n3 + 1;
        if (n2 + n4 > this.getWidth()) {
            n4 = this.getWidth() - n2;
        }
        if (n3 + n5 > this.getHeight()) {
            n5 = this.getHeight() - n3;
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    @Override
    public boolean get_Item(int n2, int n3) {
        if (n2 >= this.getWidth() || n2 < 0) {
            throw new ArgumentOutOfRangeException("x");
        }
        if (n3 >= this.getHeight() || n3 < 0) {
            throw new ArgumentOutOfRangeException("y");
        }
        return this.b * this.b >= (n2 - this.a.getX()) * (n2 - this.a.getX()) + (n3 - this.a.getY()) * (n3 - this.a.getY());
    }

    public CircleMask(int n2, int n3, int n4) {
        super(n2 + n4 + 1, n3 + n4 + 1);
        this.a = new Point(n2, n3);
        this.b = n4;
    }

    public CircleMask(Point point, int n2) {
        this(point.getX(), point.getY(), n2);
    }

    @Override
    public ImageMask inflate(int n2) {
        this.b += n2;
        this.setWidth(this.a.getX() + this.b + 1);
        this.setHeight(this.a.getY() + this.b + 1);
        return this;
    }

    @Override
    public ImageMask crop(Rectangle rectangle) {
        this.a.setX(this.a.getX() - rectangle.getX());
        this.a.setY(this.a.getY() - rectangle.getY());
        this.setWidth(rectangle.getWidth());
        this.setHeight(rectangle.getHeight());
        if (this.a.getX() + this.b > this.getWidth() || this.a.getY() + this.b > this.getHeight()) {
            return ImageBitMask.a(this);
        }
        return this;
    }

    @Override
    public Object deepClone() {
        return new CircleMask(this.a.Clone(), this.b);
    }
}

