/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.magicwand;

import com.aspose.imaging.Color;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aK.bn;
import com.aspose.imaging.internal.iW.j;
import com.aspose.imaging.internal.jb.a;
import com.aspose.imaging.internal.jb.b;
import com.aspose.imaging.internal.jb.c;
import com.aspose.imaging.internal.qB.d;
import com.aspose.imaging.magicwand.ColorYUV;
import com.aspose.imaging.magicwand.MagicWandSettings;
import com.aspose.imaging.magicwand.imagemasks.ImageBitMask;

public class MagicWandTool
implements IPartialArgb32PixelLoader {
    private final ImageBitMask a;
    private final Rectangle b = new Rectangle();
    private final int c;
    private final int d;
    private final MagicWandSettings.ColorComparison e;
    private final Color f = new Color();
    private final ColorYUV g;

    private MagicWandTool(RasterImage rasterImage, MagicWandSettings magicWandSettings) {
        if (magicWandSettings.getColorCompareMode() == 3 && magicWandSettings.getColorComparisonDelegate() == null) {
            throw new ArgumentNullException("settings.ColorComparisonDelegate", "Color comparison delegate is not defined.");
        }
        this.c = magicWandSettings.getThreshold();
        MagicWandTool.a(rasterImage, magicWandSettings.getAreaOfInterest()).CloneTo(this.b);
        this.d = magicWandSettings.getColorCompareMode();
        this.e = magicWandSettings.getColorComparisonDelegate();
        if (!this.a(magicWandSettings.getPoint())) {
            throw new ArgumentOutOfRangeException("settings.Point", "The reference point cannot be located outside the area of interest.");
        }
        this.a = new ImageBitMask(rasterImage);
        com.aspose.imaging.internal.jb.c.a(rasterImage, magicWandSettings.getPoint()).CloneTo(this.f);
        this.g = new ColorYUV(this.f);
    }

    public static ImageBitMask select(RasterImage rasterImage, MagicWandSettings magicWandSettings) {
        j.a(rasterImage, com.aspose.imaging.internal.qB.d.a(MagicWandTool.class).u());
        MagicWandTool magicWandTool = new MagicWandTool(rasterImage, magicWandSettings);
        bn bn2 = bn.a();
        bn2.a(rasterImage, bn2.hashCode() ^ rasterImage.hashCode());
        bn2.a(rasterImage, magicWandTool.b, magicWandTool);
        return magicWandSettings.getContiguousMode() ? com.aspose.imaging.internal.jb.b.a(magicWandTool.a, magicWandSettings.getPoint(), magicWandSettings.getDirectionalMode(), magicWandSettings.getAreaOfInterest()) : magicWandTool.a;
    }

    @Override
    public final void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
        int n2 = 0;
        Color color = new Color();
        for (int i2 = rectangle.getTop(); i2 < rectangle.getBottom(); ++i2) {
            for (int i3 = rectangle.getLeft(); i3 < rectangle.getRight(); ++i3) {
                Color.fromArgb(nArray[n2++]).CloneTo(color);
                if ((color.getA() & 0xFF) <= 0) continue;
                this.a.setMaskPixel(i3, i2, this.a(color));
            }
        }
    }

    private boolean a(Color color) {
        switch (this.d) {
            case 0: {
                return com.aspose.imaging.internal.jb.a.a(this.f, color, this.c);
            }
            case 1: {
                return com.aspose.imaging.internal.jb.a.a(this.g, new ColorYUV(color), this.c);
            }
            case 2: {
                return com.aspose.imaging.internal.jb.a.b(this.g, new ColorYUV(color), this.c);
            }
        }
        return this.e.invoke(this.f, color, this.c);
    }

    private boolean a(Point point) {
        return point.getX() >= this.b.getLeft() && point.getX() < this.b.getRight() && point.getY() >= this.b.getTop() && point.getY() < this.b.getBottom();
    }

    private static Rectangle a(RasterImage rasterImage, Rectangle rectangle) {
        if (rectangle.isEmpty()) {
            return new Rectangle(0, 0, rasterImage.getWidth(), rasterImage.getHeight());
        }
        if (rectangle.getLeft() < 0 || rectangle.getTop() < 0 || rectangle.getRight() > rasterImage.getWidth() || rectangle.getBottom() > rasterImage.getHeight()) {
            throw new ArgumentOutOfRangeException("The specification of selection area cannot exceed the size of an image.", new ArgumentOutOfRangeException("areaOfInterest"));
        }
        return rectangle;
    }
}

