/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.auth;

import com.baidu.aip.http.AipHttpClient;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.AipResponse;
import com.baidu.aip.util.AipClientConfiguration;
import com.baidu.aip.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import org.json.JSONObject;

public class DevAuth {
    public static JSONObject oauth(String apiKey, String secretKey, AipClientConfiguration config) {
        try {
            AipRequest request = new AipRequest();
            request.setUri(new URI("https://aip.baidubce.com/oauth/2.0/token"));
            request.addBody("grant_type", "client_credentials");
            request.addBody("client_id", apiKey);
            request.addBody("client_secret", secretKey);
            request.setConfig(config);
            AipResponse response = AipHttpClient.post(request);
            String res = response.getBodyStr();
            int statusCode = response.getStatus();
            if (res != null && !res.equals("")) {
                return new JSONObject(res);
            }
            return Util.getGeneralError(statusCode, "Server response code: " + statusCode);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

