/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.loader;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlCache;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlLoader;
import org.zhiqim.zml.loader.ClassZmlWatcher;

public class ClassZmlLoader
implements ZmlLoader {
    private final ZmlEngine engine;
    private final ZmlCache cache;
    private final ClassZmlWatcher watcher;
    private final Class<?> loadClass;
    private final String contextPath;

    public ClassZmlLoader(ZmlEngine engine, Class<?> loadClass, String contextPath) {
        contextPath = Strings.addStartsWith((String)contextPath, (String)"/");
        contextPath = Strings.removeEndsWith((String)contextPath, (String)"/");
        this.engine = engine;
        this.loadClass = loadClass;
        this.contextPath = contextPath;
        this.cache = new ZmlCache(engine.getMaxIdleTime(), engine.getMaxKeepTime());
        this.watcher = new ClassZmlWatcher(loadClass, contextPath);
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public boolean hasZml(String path) throws Exception {
        return this.getLastModified(path) != -1L;
    }

    @Override
    public Zml loadZml(String path) throws Exception {
        long lastModified = this.getLastModified(path);
        if (lastModified == -1L) {
            this.cache.remove(path);
            return null;
        }
        Zml zml = this.cache.get(path);
        if (zml != null && lastModified == zml.getLastModified()) {
            return zml;
        }
        URL url = Resources.getResource(this.loadClass, (String)(String.valueOf(this.contextPath) + path));
        URLConnection conn = url.openConnection();
        String content = Streams.getString((InputStream)conn.getInputStream(), (String)this.engine.getEncoding());
        zml = new Zml(this.engine, path, lastModified, content);
        this.cache.put(path, zml);
        return zml;
    }

    @Override
    public long getLastModified(String path) throws Exception {
        if (!Strings.startsWith((String)path, (String)"/") || !Validates.isMatch((String)path, (String[])this.engine.getPatterns())) {
            throw new Exception("ZML[" + path + "]\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b/\u5f00\u5934\u4e14\u7b26\u5408\u914d\u7f6e\u7684\u6a21\u5f0f");
        }
        return this.watcher.getLastModified(path);
    }

    @Override
    public void setMaxIdleTime(int maxIdleTime) {
        this.cache.setMaxIdleTime(maxIdleTime);
    }

    @Override
    public void setMaxKeepTime(int maxKeepTime) {
        this.cache.setMaxKeepTime(maxKeepTime);
    }
}

