/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSV;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlVarRuntime;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Function;
import org.zhiqim.zml.statement._Var;

public class ZmlVariable {
    private Zml zml;
    private MapSO variableMap;
    private MapS[] contextMap;
    private MapSV<_Function> functionMap;
    private List<MapSO> localList;

    public void setZml(Zml zml) {
        this.zml = zml;
    }

    public void setVariableMap(MapSO variableMap) {
        this.variableMap = variableMap;
    }

    public void setContextMap(MapS ... contextMap) {
        this.contextMap = contextMap;
    }

    public void setFunctionMap(MapSV<_Function> functionMap) {
        this.functionMap = functionMap;
    }

    public void addFunction(_Function function) throws StatementException {
        if (this.functionMap == null) {
            this.functionMap = new HashMapSV();
        } else if (this.functionMap.containsKey(function.getName())) {
            throw new StatementException(function, "\u5b58\u5728\u76f8\u540c\u7684\u51fd\u6570\u540d[" + function.getName() + "]");
        }
        this.functionMap.put(function.getName(), (Object)function);
    }

    public void addLocalVariable(MapSO localMap) {
        if (this.localList == null) {
            this.localList = new ArrayList<MapSO>(2);
        }
        this.localList.add(localMap);
    }

    public void removeLocalVariable(MapSO localMap) {
        this.localList.remove(localMap);
    }

    public void addVariable(String name, Object value) {
        if (this.localList == null || this.localList.isEmpty()) {
            if (this.variableMap == null) {
                this.variableMap = new HashMapSO();
            }
            this.variableMap.put(name, value);
            return;
        }
        int i = this.localList.size() - 1;
        while (i >= 0) {
            MapSO localMap = this.localList.get(i);
            if (localMap.containsKey(name)) {
                localMap.put(name, value);
                return;
            }
            --i;
        }
        if (this.variableMap != null && this.variableMap.containsKey(name)) {
            this.variableMap.put(name, value);
            return;
        }
        MapSO localMap = this.localList.get(this.localList.size() - 1);
        localMap.put(name, value);
    }

    public Zml getZml() {
        return this.zml;
    }

    public ZmlEngine getEngine() {
        return this.zml.getEngine();
    }

    public MapSO getVariableMap() {
        return this.variableMap;
    }

    public MapS[] getContextMap() {
        return this.contextMap;
    }

    public MapSV<_Function> getFunctionMap() {
        return this.functionMap;
    }

    public Object get(String key) {
        ZmlEngine engine;
        Object value;
        if (this.localList != null && !this.localList.isEmpty()) {
            int i = this.localList.size() - 1;
            while (i >= 0) {
                MapSO loaclMap = this.localList.get(i);
                Object value2 = loaclMap.get(key);
                if (value2 != null) {
                    return ZmlVariable.chkDynamicVar(value2);
                }
                --i;
            }
        }
        if (this.variableMap != null && (value = this.variableMap.get(key)) != null) {
            return ZmlVariable.chkDynamicVar(value);
        }
        if (this.contextMap != null) {
            MapS[] mapSArray = this.contextMap;
            int value2 = this.contextMap.length;
            int loaclMap = 0;
            while (loaclMap < value2) {
                MapS map = mapSArray[loaclMap];
                Object value3 = map.get(key);
                if (value3 != null) {
                    return ZmlVariable.chkDynamicVar(value3);
                }
                ++loaclMap;
            }
        }
        if ((engine = this.zml.getEngine()) != null) {
            Object value4 = engine.getGlobalVariable(key);
            if (value4 != null) {
                return ZmlVariable.chkDynamicVar(value4);
            }
            _Var var = engine.getVar(key);
            if (var != null) {
                try {
                    return var.getExpression().build(this);
                }
                catch (ExpressionException e) {
                    throw Asserts.exception((String)("\u6267\u884c\u5168\u5c40\u53d8\u91cf\u8868\u8fbe\u5f0f\u65f6\u5f02\u5e38[" + var.getVariableName() + "]"), (Exception)e);
                }
            }
        }
        return ZmlEngine.getSystemVariable(key);
    }

    public _Function getFunction(String name) throws StatementException {
        _Function function;
        _Function _Function2 = function = this.functionMap == null ? null : (_Function)this.functionMap.get(name);
        if (function != null) {
            return function;
        }
        return this.zml.getFunction(name);
    }

    public static Object chkDynamicVar(Object value) {
        return value instanceof ZmlVarRuntime ? ((ZmlVarRuntime)value).build() : value;
    }
}

