/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util.qrcode;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import com.zhiqim.media.service.util.qrcode.QrcodeParams;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Validates;

public class QrcodeUtil {
    private static Log log = LogFactory.getLog(QrcodeUtil.class);

    public static void makeQrcode(String text, int width, int height, String filePath, String fileName) throws Exception {
        QrcodeParams param = new QrcodeParams(width, height, text, filePath, fileName);
        QrcodeUtil.makeQrcode(param);
    }

    public static void makeQrcode(String text, int width, int height, String logoPath, String filePath, String fileName) throws Exception {
        QrcodeParams param = new QrcodeParams(width, height, text, filePath, fileName);
        param.setLogoPath(logoPath);
        param.setLogoStyle(1);
        QrcodeUtil.makeQrcode(param);
    }

    public static void makeQrcode(QrcodeParams param) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, param.getCharacterSet());
        hints.put(EncodeHintType.ERROR_CORRECTION, param.getLevel());
        hints.put(EncodeHintType.MARGIN, param.getMargin());
        if (param.getVersion() > 0 && param.getVersion() <= 40) {
            hints.put(EncodeHintType.QR_VERSION, param.getVersion());
        }
        int width = param.getWidth();
        int height = param.getHeight();
        QRCode qrcode = Encoder.encode((String)param.getText(), (ErrorCorrectionLevel)param.getLevel(), hints);
        BitMatrix bitMatrix = QrcodeUtil.renderResult(qrcode, width, height, param.getMargin());
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] pixels = QrcodeUtil.addColorStyle(bitMatrix, qrcode.getVersion().getVersionNumber(), param);
        image.setRGB(0, 0, width, height, pixels, 0, width);
        String logoPath = param.getLogoPath();
        if (Validates.isNotEmpty((String)logoPath)) {
            QrcodeUtil.addLogo(image, param.getLogoPath(), param.getLogoStyle());
        }
        String filePath = param.getFilePath();
        String fileName = param.getFileName();
        if (!Files.exists((String)filePath)) {
            Files.mkDirectory((String)filePath);
        }
        Path path = FileSystems.getDefault().getPath(filePath, fileName);
        if (Validates.isNotEmpty((String)param.getBgPath())) {
            BufferedImage bgImage = ImageIO.read(new File(param.getBgPath()));
            Graphics2D g = bgImage.createGraphics();
            int x = param.getBgX();
            int y = param.getBgY();
            if (x < 0) {
                x = (bgImage.getWidth() - width) / 2;
            }
            if (y < 0) {
                y = (bgImage.getHeight() - height) / 2;
            }
            g.drawImage(image, x, y, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)bgImage, "png", path.toFile());
        } else {
            ImageIO.write((RenderedImage)image, "png", path.toFile());
        }
    }

    private static BitMatrix renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + quietZone * 2;
        int qrHeight = inputHeight + quietZone * 2;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrix output = new BitMatrix(outputWidth, outputHeight);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY) == 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }

    private static int[] addColorStyle(BitMatrix matrix, int version, QrcodeParams param) {
        int width = param.getWidth();
        int height = param.getHeight();
        int outerEyeColor = param.getOuterEyeColor() == null ? param.getOnColor() : param.getOuterEyeColor().intValue();
        int innerEyeColor = param.getInnerEyeColor() == null ? param.getOnColor() : param.getInnerEyeColor().intValue();
        int startModel = 0;
        int endModel = 7;
        int[] tl = matrix.getTopLeftOnBit();
        int totalModelNum = (version - 1) * 4 + 5 + 16;
        int resultWidth = width - 2 * tl[0];
        int modelWidth = resultWidth / totalModelNum;
        int topStartX = tl[0] + modelWidth * startModel;
        int topStartY = tl[0] + modelWidth * startModel;
        int topEndX = tl[0] + modelWidth * endModel;
        int topEndY = tl[0] + modelWidth * endModel;
        int rightStartX = (totalModelNum - endModel) * modelWidth + tl[0];
        int rightEndX = width - modelWidth * startModel - tl[0];
        int leftStartY = height - modelWidth * endModel - tl[1] - 1;
        int leftEndY = height - modelWidth * startModel - tl[1];
        int topInnerStartX = tl[0] + modelWidth * (startModel + 2);
        int topInnerStartY = tl[0] + modelWidth * (startModel + 2);
        int topInnerEndX = tl[0] + modelWidth * (endModel - 2);
        int topInnerEndY = tl[0] + modelWidth * (endModel - 2);
        int rightInnerStartX = (totalModelNum - (endModel - 2)) * modelWidth + tl[0];
        int rightInnerEndX = width - modelWidth * (startModel + 2) - tl[0];
        int leftInnerStartY = height - modelWidth * (endModel - 2) - tl[1] - 1;
        int leftInnerEndY = height - modelWidth * (startModel + 2) - tl[1];
        int[] pixels = new int[width * height];
        int y = 0;
        while (y < matrix.getHeight()) {
            int x = 0;
            while (x < matrix.getWidth()) {
                if (x >= topStartX && x < topEndX && y >= topStartY && y < topEndY) {
                    int n = pixels[y * width + x] = matrix.get(x, y) ? outerEyeColor : param.getOffColor();
                    if (x >= topInnerStartX && x < topInnerEndX && y >= topInnerStartY && y < topInnerEndY) {
                        pixels[y * width + x] = matrix.get(x, y) ? innerEyeColor : param.getOffColor();
                    }
                } else if (x < rightEndX && x >= rightStartX && y >= topStartY && y < topEndY) {
                    int n = pixels[y * width + x] = matrix.get(x, y) ? outerEyeColor : param.getOffColor();
                    if (x < rightInnerEndX && x >= rightInnerStartX && y >= topInnerStartY && y < topInnerEndY) {
                        pixels[y * width + x] = matrix.get(x, y) ? innerEyeColor : param.getOffColor();
                    }
                } else if (x >= topStartX && x < topEndX && y >= leftStartY && y < leftEndY) {
                    int n = pixels[y * width + x] = matrix.get(x, y) ? outerEyeColor : param.getOffColor();
                    if (x >= topInnerStartX && x < topInnerEndX && y >= leftInnerStartY && y < leftInnerEndY) {
                        pixels[y * width + x] = matrix.get(x, y) ? innerEyeColor : param.getOffColor();
                    }
                } else {
                    pixels[y * width + x] = matrix.get(x, y) ? param.getOnColor() : param.getOffColor();
                }
                ++x;
            }
            ++y;
        }
        return pixels;
    }

    private static void addLogo(BufferedImage image, String logoPath, int logoStyle) throws Exception {
        Graphics2D gd = image.createGraphics();
        int ratioWidth = image.getWidth() * 2 / 10;
        int ratioHeight = image.getHeight() * 2 / 10;
        Image logoImage = ImageIO.read(new File(logoPath));
        int logoWidth = ((Image)logoImage).getWidth(null) > ratioWidth ? ratioWidth : ((Image)logoImage).getWidth(null);
        int logoHeight = ((Image)logoImage).getHeight(null) > ratioHeight ? ratioHeight : ((Image)logoImage).getHeight(null);
        int x = (image.getWidth() - logoWidth) / 2;
        int y = (image.getHeight() - logoHeight) / 2;
        if (logoStyle == 1) {
            gd.drawRoundRect(x - 5, y - 5, logoWidth + 10, logoHeight + 10, 30, 30);
            gd.fillRoundRect(x - 5, y - 5, logoWidth + 10, logoHeight + 10, 30, 30);
        } else if (logoStyle == 2) {
            gd.drawRect(x - 5, y - 5, logoWidth + 10, logoHeight + 10);
            gd.fillRect(x - 5, y - 5, logoWidth + 10, logoHeight + 10);
        }
        logoImage = logoImage.getScaledInstance(logoWidth, logoHeight, 4);
        gd.drawImage(logoImage, x, y, logoWidth, logoHeight, null);
        gd.setComposite(AlphaComposite.getInstance(3));
        gd.dispose();
    }

    public static String parseQrcode(String imagePath) {
        File imageFile = new File(imagePath);
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageFile);
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790\u4e8c\u7ef4\u7801\u56fe\u7247\u8def\u5f84\u65f6\u8bfb\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
            return null;
        }
        try {
            return QrcodeUtil.parseQrcode(image, 0);
        }
        catch (NotFoundException e) {
            try {
                return QrcodeUtil.parseQrcode(image, 1);
            }
            catch (NotFoundException notFoundException) {
                log.error((Object)("\u89e3\u6790\u4e8c\u7ef4\u7801\u56fe\u7247\u8def\u5f84\u65f6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
                return null;
            }
        }
    }

    public static String parseQrcode(InputStream in) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790\u4e8c\u7ef4\u7801\u6d41\u65f6\u8bfb\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
            return null;
        }
        try {
            return QrcodeUtil.parseQrcode(image, 0);
        }
        catch (NotFoundException e) {
            try {
                return QrcodeUtil.parseQrcode(image, 1);
            }
            catch (NotFoundException notFoundException) {
                log.error((Object)("\u89e3\u6790\u4e8c\u7ef4\u7801\u6d41\u65f6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
                return null;
            }
        }
    }

    private static String parseQrcode(BufferedImage image, int type) throws NotFoundException {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        if (type > 0) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        Result result = new MultiFormatReader().decode(binaryBitmap, hints);
        return result.getText();
    }

    public static void main(String[] args) throws Exception {
        QrcodeUtil.makeQrcode("https://baijiahao.baidu.com/s?id=1684282657863493228&wfr=spider&for=pc", 320, 320, "D:\\_yangcai", "card.png");
    }
}

