/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.dao;

import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.MD5;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.uploadlarge.ZulConstants;
import org.zhiqim.uploadlarge.dbo.UpllFile;
import org.zhiqim.zml.ZmlConstants;

public class MediaPathDao
implements ZulConstants,
ZmlConstants,
ZmlContextConstants {
    public static String MEDIA_ROOT = Global.getString((String)"media", (String)"mediaRoot", (String)"media");
    public static String MEDIA_PATH_PRE = Global.getString((String)"media", (String)"mediaPathPre", (String)"./upload");
    public static String MEDIA_URL_PRE = Global.getString((String)"media", (String)"mediaUrlPre", (String)"http://127.0.0.1:8088");

    public static String getTempMidPath(String curDate) {
        return String.valueOf(Strings.addEndsWith((String)MEDIA_ROOT, (String)"/")) + "temp/" + curDate;
    }

    public static String getTempLocalPre(String curDate) {
        String path = String.valueOf(Strings.addEndsWith((String)MEDIA_PATH_PRE, (String)"/")) + MediaPathDao.getTempMidPath(curDate);
        if (!Files.exists((String)path)) {
            Files.mkDirectory((String)path);
        }
        return Strings.addEndsWith((String)path, (String)"/");
    }

    public static String getTempUrlPre(String curDate) {
        String midPath = MediaPathDao.getTempMidPath(curDate);
        String path = "/service/upl/" + Base64.encodeFileUrlUTF8((String)midPath) + "/";
        return path;
    }

    public static String getCanvasLocalPathPre(long mediaId) {
        return MEDIA_PATH_PRE;
    }

    public static String getCanvasMidPath(long mediaId) {
        return String.valueOf(Strings.addEndsWith((String)MEDIA_ROOT, (String)"/")) + "canvas/" + mediaId;
    }

    public static String getCanvasLocalPre(long mediaId) {
        String path = String.valueOf(Strings.addEndsWith((String)MEDIA_PATH_PRE, (String)"/")) + MediaPathDao.getCanvasMidPath(mediaId);
        if (!Files.exists((String)path)) {
            Files.mkDirectory((String)path);
        }
        return Strings.addEndsWith((String)path, (String)"/");
    }

    public static String getCanvasUrlPre(long mediaId) {
        String midPath = MediaPathDao.getCanvasMidPath(mediaId);
        String path = "/service/upl/" + Base64.encodeFileUrlUTF8((String)midPath) + "/";
        return path;
    }

    public static String getSysMaterialMidPath(String catCode) {
        return String.valueOf(Strings.addEndsWith((String)MEDIA_ROOT, (String)"/")) + "material/" + catCode;
    }

    public static String getSysMaterialLocalPre(String catCode) {
        String path = String.valueOf(Strings.addEndsWith((String)MEDIA_PATH_PRE, (String)"/")) + MediaPathDao.getSysMaterialMidPath(catCode);
        if (!Files.exists((String)path)) {
            Files.mkDirectory((String)path);
        }
        return Strings.addEndsWith((String)path, (String)"/");
    }

    public static String getSysMaterialUrlPre(String catCode) {
        String midPath = MediaPathDao.getSysMaterialMidPath(catCode);
        String path = "/service/upl/" + Base64.encodeFileUrlUTF8((String)midPath) + "/";
        return path;
    }

    public static String getDesignMaterialMidPath(String curDate) {
        return String.valueOf(Strings.addEndsWith((String)MEDIA_ROOT, (String)"/")) + "design/" + curDate;
    }

    public static String getDesignMaterialLocalPre(String curDate) {
        String path = String.valueOf(Strings.addEndsWith((String)MEDIA_PATH_PRE, (String)"/")) + MediaPathDao.getDesignMaterialMidPath(curDate);
        if (!Files.exists((String)path)) {
            Files.mkDirectory((String)path);
        }
        return Strings.addEndsWith((String)path, (String)"/");
    }

    public static String getDesignMaterialUrlPre(String curDate) {
        String midPath = MediaPathDao.getDesignMaterialMidPath(curDate);
        String path = "/service/upl/" + Base64.encodeFileUrlUTF8((String)midPath) + "/";
        return path;
    }

    public static String getUserMaterialMidPath(String userId) {
        return String.valueOf(Strings.addEndsWith((String)MEDIA_ROOT, (String)"/")) + "user/" + userId;
    }

    public static String getUserMaterialLocalPre(String userId) {
        String path = String.valueOf(Strings.addEndsWith((String)MEDIA_PATH_PRE, (String)"/")) + MediaPathDao.getUserMaterialMidPath(userId);
        if (!Files.exists((String)path)) {
            Files.mkDirectory((String)path);
        }
        return Strings.addEndsWith((String)path, (String)"/");
    }

    public static String getUserMaterialUrlPre(String userId) {
        String midPath = MediaPathDao.getUserMaterialMidPath(userId);
        String path = "/service/upl/" + Base64.encodeFileUrlUTF8((String)midPath) + "/";
        return path;
    }

    public static String parseUplUrl(String url) {
        String filePath = Strings.removeStartsWith((String)url, (String)"/service/upl/");
        String fileDir = Files.getFileDirPath((String)filePath, (String)"/");
        String fileName = Files.getFileNameLinux((String)filePath);
        if (Validates.isNotEmpty((String)fileDir)) {
            fileDir = Base64.decodeFileUrlUTF8((String)fileDir);
        }
        return String.valueOf(Strings.addEndsWith((String)MEDIA_PATH_PRE, (String)"/")) + fileDir + "/" + fileName;
    }

    public static UpllFile createUpllFile(byte[] bytes, String filePath) {
        UpllFile ufile;
        block3: {
            String fileId = Ids.uuid();
            String fileExt = Files.getFileExt((String)filePath);
            String fileName = Files.getFileName((String)filePath);
            ufile = new UpllFile();
            ufile.setFileId(fileId);
            ufile.setFileMd5(MD5.encode((byte[])bytes));
            ufile.setFileExt(fileExt);
            ufile.setFileLength((long)bytes.length);
            ufile.setFilePath(filePath);
            ufile.setFileName(fileName);
            ufile.setFileUrl("/service/upll/" + fileId + Files.fixFileExt((String)fileExt));
            ufile.setFileTime(DateTimes.getDateTimeString());
            try {
                boolean isSuccess = Files.write((String)filePath, (byte[])bytes);
                if (isSuccess) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        ((ZTable)ORM.get(ZTable.class)).replace((Object)ufile);
        return ufile;
    }
}

