/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.dao;

import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaCoverMaterial;
import com.zhiqim.media.dbo.MediaImageUse;
import com.zhiqim.media.dbo.MediaMaterial;
import com.zhiqim.media.dbo.MediaMaterialParam;
import com.zhiqim.media.dbo.MediaMaterialParamEx;
import com.zhiqim.media.service.constants.MaterialConstants;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.dao.PdfDao;
import com.zhiqim.media.service.handler.MediaCanvasController;
import com.zhiqim.media.service.handler.MediaHandleModel;
import com.zhiqim.media.service.handler.MediaHandlePdfModel;
import com.zhiqim.media.service.model.MaterialTextSvg;
import com.zhiqim.media.service.model.MediaBgModel;
import com.zhiqim.media.service.model.MediaModel;
import com.zhiqim.media.service.svg.MediaSvgDocument;
import com.zhiqim.media.service.svg.MediaSvgText;
import com.zhiqim.media.service.util.GraphicsMagickUtil;
import com.zhiqim.media.service.util.SvgUtil;
import com.zhiqim.media.service.util.UnitUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.Zips;
import org.zhiqim.kernel.xml.Xmls;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.ZView;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.uploadlarge.dbo.UpllFile;
import org.zhiqim.zml.Zmls;

public class MediaDao {
    @AnTransaction
    public static void deleteMedia(long mediaId) throws Exception {
        Selector selector = new Selector();
        selector.addMust("mediaId", (Object)mediaId);
        ((ZTable)ORM.get(ZTable.class)).delete(MediaCanvas.class, selector);
        ((ZTable)ORM.get(ZTable.class)).delete(MediaBg.class, selector);
        ((ZTable)ORM.get(ZTable.class)).delete(MediaMaterial.class, selector);
        ((ZTable)ORM.get(ZTable.class)).delete(MediaMaterialParam.class, selector);
    }

    public static MediaModel preSaveMedia(MediaModel media) throws Exception {
        MediaCanvas canvas = media.getCanvas();
        List<MediaBg> bgList = media.getBgList();
        List<MediaMaterialParamEx> materialList = media.getMaterialList();
        List<MediaCoverMaterial> coverMaterialList = media.getCoverMaterialList();
        Iterator<MediaMaterialParamEx> it = materialList.iterator();
        while (it.hasNext()) {
            MediaMaterialParamEx material = it.next();
            if (material.getStatus() != 1) continue;
            it.remove();
        }
        HashMap materialMap = new HashMap();
        for (MediaMaterialParamEx material : materialList) {
            int key = material.getBid();
            if (materialMap.containsKey(key)) {
                ((List)materialMap.get(key)).add(material);
                continue;
            }
            ArrayList<MediaMaterialParamEx> list = new ArrayList<MediaMaterialParamEx>();
            list.add(material);
            materialMap.put(key, list);
        }
        int k = 0;
        while (k < bgList.size()) {
            MediaBg bg = bgList.get(k);
            if (materialMap.containsKey(bg.getBid())) {
                List bgMaterialList = (List)materialMap.get(bg.getBid());
                int i = 0;
                while (i < bgMaterialList.size()) {
                    MediaMaterialParamEx material = (MediaMaterialParamEx)bgMaterialList.get(i);
                    material.setMid(i);
                    material.setPos(i);
                    material.setSource(material.getSource().replaceAll("&nbsp;", " "));
                    ++i;
                }
            }
            ++k;
        }
        String dateTime = DateTimes.getDateTimeString();
        canvas.setUpdateTime(dateTime);
        if (Validates.isEmpty((String)canvas.getCreateTime())) {
            canvas.setCreateTime(dateTime);
        }
        MediaModel newMedia = new MediaModel(canvas, bgList, materialList, coverMaterialList);
        return newMedia;
    }

    @AnTransaction
    public static MediaModel saveMedia(MediaModel media) throws Exception {
        MediaModel newMedia = MediaDao.preSaveMedia(media);
        MediaCanvas canvas = media.getCanvas();
        long mediaId = canvas.getMediaId();
        List<MediaMaterial> mlist = newMedia.getMediaMaterialList();
        List<MediaCoverMaterial> cmlist = newMedia.getCoverMediaMaterialList();
        List<MediaMaterialParam> plist = newMedia.getMaterialParamList();
        List<MediaBg> bgList = media.getBgList();
        ((ZTable)ORM.get(ZTable.class)).replace((Object)canvas);
        List oldBgList = ((ZTable)ORM.get(ZTable.class)).list(MediaBg.class, new Selector("mediaId", (Object)mediaId));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(MediaDao.recordBgRefNum(oldBgList, "del"));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(MediaDao.recordBgRefNum(bgList, "add"));
        ((ZTable)ORM.get(ZTable.class)).delete(MediaBg.class, new Selector("mediaId", (Object)mediaId));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(bgList);
        List oldMaterialList = ((ZTable)ORM.get(ZTable.class)).list(MediaMaterial.class, new Selector("mediaId", (Object)mediaId));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(MediaDao.recordMaterialRefNum(oldMaterialList, "del"));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(MediaDao.recordMaterialRefNum(mlist, "add"));
        ((ZTable)ORM.get(ZTable.class)).delete(MediaMaterial.class, new Selector("mediaId", (Object)mediaId));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(mlist);
        ((ZTable)ORM.get(ZTable.class)).delete(MediaCoverMaterial.class, new Selector("mediaId", (Object)mediaId));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(cmlist);
        ((ZTable)ORM.get(ZTable.class)).delete(MediaMaterialParam.class, new Selector("mediaId", (Object)mediaId));
        ((ZTable)ORM.get(ZTable.class)).replaceBatch(plist);
        return newMedia;
    }

    public static String doCreateMediaImage(long mediaId, MediaCanvas canvas, List<MediaBg> bgList, List<MediaMaterialParamEx> materials, List<MediaCoverMaterial> coverMaterials) throws Exception {
        String source;
        String curDate = DateTimes.getDateTime8String();
        String url = null;
        String string = source = bgList.size() > 0 ? bgList.get(0).getSource() : "";
        if (canvas.getDpi() == 72 && bgList.size() == 1 && (source.indexOf("fill=\"NONE\"") != -1 || source.indexOf("fill=\"none\"") != -1)) {
            double baseWidthmm = canvas.getBaseWidthMm();
            double baseHeigthmm = canvas.getBaseHeightMm();
            String pre_url = MediaPathDao.MEDIA_URL_PRE;
            List<MediaBgModel> bgMList = MediaDao.toSvgList(mediaId, baseWidthmm, baseHeigthmm, pre_url, false, bgList, materials, coverMaterials, "IMAGE");
            String fileName = "imp_" + Ids.longId() + ".png";
            String destPath = String.valueOf(MediaPathDao.getCanvasLocalPre(mediaId)) + fileName;
            SvgUtil.svg2Png(bgMList.get(0).getSvgCode(), destPath, (float)canvas.getWidth(), (float)canvas.getHeight());
            String mediaUrl = String.valueOf(MediaPathDao.getCanvasUrlPre(mediaId)) + fileName;
            if (Validates.isNotEmpty((String)mediaUrl)) {
                Updater updater = new Updater();
                updater.addMust("mediaId", (Object)mediaId);
                updater.addField("mediaUrl", (Object)mediaUrl);
                ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
            }
            url = mediaUrl;
        } else {
            String tempPath = MediaPathDao.getTempLocalPre(curDate);
            List<String> pdfList = PdfDao.getPdfList(canvas, 2, false, bgList, materials, coverMaterials, "IMAGE");
            List<String> imageList = PdfDao.pdfToImage(pdfList, tempPath, "jpg", (int)canvas.getWidth(), (int)canvas.getHeight(), 2);
            String mediaUrl = MediaDao.createMediaEffect(canvas.getMediaId(), canvas.getWidth(), canvas.getHeight(), imageList);
            if (Validates.isNotEmpty((String)mediaUrl)) {
                Updater updater = new Updater();
                updater.addMust("mediaId", (Object)mediaId);
                updater.addField("mediaUrl", (Object)mediaUrl);
                ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
            }
            url = mediaUrl;
        }
        return url;
    }

    public static MediaModel getOrCreateMedia(long mediaId, long mediaType, double baseWidthMm, double baseHeightMm, double width, double height, double fullWidth, double fullHeight, int dpi, int totalPage, double bleedSize, int createMode, boolean isModify) throws Exception {
        MediaModel media = MediaDao.getMedia(mediaId);
        if (media != null) {
            return media;
        }
        return MediaDao.createMedia(mediaType, baseWidthMm, baseHeightMm, width, height, fullWidth, fullHeight, dpi, totalPage, bleedSize, createMode, isModify, 0L, "");
    }

    public static MediaModel createMedia(long mediaType, double baseWidthMm, double baseHeightMm, double width, double height, double fullWidth, double fullHeight, int dpi, int totalPage, double bleedSize, int createMode, boolean isModify, long oddEven, String templateName) throws Exception {
        long mediaId = Ids.longId();
        String time = DateTimes.getDateTimeString();
        MediaCanvas canvas = new MediaCanvas();
        canvas.setMediaId(mediaId);
        canvas.setMediaName(Validates.isEmpty((String)templateName) ? "\u672a\u547d\u540d" : templateName);
        canvas.setBaseWidthMm(baseWidthMm);
        canvas.setBaseHeightMm(baseHeightMm);
        canvas.setMediaType(mediaType);
        canvas.setIsEdit(0);
        canvas.setMediaUrl(null);
        canvas.setDpi(dpi);
        canvas.setOddEven(oddEven);
        canvas.setBleedSize(bleedSize);
        canvas.setCreateMode(createMode);
        canvas.setModify(isModify);
        canvas.setCreateTime(time);
        canvas.setUpdateTime(time);
        if (createMode == 1) {
            canvas.setWidth(width);
            canvas.setHeight(height);
            canvas.setFullWidth(fullWidth);
            canvas.setFullHeight(fullHeight);
            canvas.setWidthMm(UnitUtil.pixel2mm(width, dpi));
            canvas.setHeightMm(UnitUtil.pixel2mm(height, dpi));
            canvas.setFullWidthMm(UnitUtil.pixel2mm(fullWidth, dpi));
            canvas.setFullHeightMm(UnitUtil.pixel2mm(fullHeight, dpi));
        } else {
            canvas.setWidth(UnitUtil.mm2pixel(width, dpi));
            canvas.setHeight(UnitUtil.mm2pixel(height, dpi));
            canvas.setFullWidth(UnitUtil.mm2pixel(fullWidth, dpi));
            canvas.setFullHeight(UnitUtil.mm2pixel(fullHeight, dpi));
            canvas.setWidthMm(width);
            canvas.setHeightMm(height);
            canvas.setFullWidthMm(fullWidth);
            canvas.setFullHeightMm(fullHeight);
        }
        MediaDao.updateCanvasFullSize(canvas, baseWidthMm, baseHeightMm, true);
        ArrayList<MediaBg> bgList = new ArrayList<MediaBg>();
        int i = 0;
        while (i < totalPage) {
            MediaBg bg = new MediaBg();
            bg.setMediaId(mediaId);
            bg.setBid(i);
            bg.setOddEven(oddEven);
            bg.setSource("<svg preserveAspectRatio=\"none\" width=\"" + canvas.getWidth() + "\" height=\"" + canvas.getHeight() + "\"><rect x=\"0\" y=\"0\" width=\"100%\" height=\"100%\" fill=\"#ffffff\"></rect></svg>");
            bgList.add(bg);
            ++i;
        }
        MediaModel media = new MediaModel(canvas, bgList, new ArrayList<MediaMaterialParamEx>(), new ArrayList<MediaCoverMaterial>());
        return media;
    }

    public static MediaModel getMedia(long mediaId) throws Exception {
        if (mediaId == -1L) {
            return null;
        }
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            return null;
        }
        Selector selector = new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid");
        List bgList = ((ZTable)ORM.get(ZTable.class)).list(MediaBg.class, selector);
        List materialList = ((ZView)ORM.get(ZView.class)).list(MediaMaterialParamEx.class, selector.addOrderbyAsc("mid"));
        Selector selector2 = new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid").addOrderbyAsc("mid");
        List coverMaterialList = ((ZTable)ORM.get(ZTable.class)).list(MediaCoverMaterial.class, selector2);
        MediaModel media = new MediaModel(canvas, bgList, materialList, coverMaterialList);
        return media;
    }

    public static String toSvgCode(MediaCanvas canvas, MediaBg bg, int bgIndex, List<? extends MediaMaterial> materialList, List<? extends MediaCoverMaterial> coverMaterialList, String prePath, boolean isEditable, String ResultType) throws Exception {
        if (Validates.isEmpty((String)prePath)) {
            prePath = "";
        }
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        double fullWidth = canvas.getFullWidth();
        double fullHeight = canvas.getFullHeight();
        if (bg.getOddEven() == 1L) {
            width = canvas.getHeight();
            height = canvas.getWidth();
            fullWidth = canvas.getFullHeight();
            fullHeight = canvas.getFullWidth();
        }
        StringBuffer strb = new StringBuffer();
        if ("PDF".equals(ResultType)) {
            fullWidth = fullWidth == 0.0 ? width : fullWidth;
            fullHeight = fullHeight == 0.0 ? height : fullHeight;
            double d = fullWidth - width;
            double viewY = fullHeight - height;
            if (bg.getOddEven() == 0L) {
                d = bgIndex % 2 == 0 ? 0.0 : -d;
                viewY = 0.0;
            } else {
                d = bgIndex % 2 == 0 ? 0.0 : -d;
                viewY = -viewY;
            }
            strb.append("<svg width=\"").append(fullWidth).append("\" height=\"").append(fullHeight);
            strb.append("\" viewBox=\"").append(d == 0.0 ? "0" : Double.valueOf(d)).append(" ").append(viewY == 0.0 ? "0" : Double.valueOf(viewY)).append(" ").append(fullWidth).append(" ").append(fullHeight);
            strb.append("\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        } else {
            strb.append("<svg width=\"").append(width).append("\" height=\"").append(height);
            strb.append("\" viewBox=\"").append("0").append(" ").append("0").append(" ").append(width).append(" ").append(height);
            strb.append("\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        }
        strb.append(MediaDao.buildBgSvg(bg, width, height, prePath));
        if (Validates.isNotEmpty(materialList)) {
            for (MediaMaterial mediaMaterial : materialList) {
                if (mediaMaterial.getBid() != bg.getBid()) continue;
                strb.append(MediaDao.buildMaterialSvg(mediaMaterial, prePath, isEditable));
            }
        }
        if (Validates.isNotEmpty(coverMaterialList) && "PDF".equals(ResultType)) {
            for (MediaCoverMaterial mediaCoverMaterial : coverMaterialList) {
                if (mediaCoverMaterial.getBid() != bg.getBid()) continue;
                strb.append(MediaDao.buildCoverMaterialSvg(mediaCoverMaterial, prePath));
            }
        }
        strb.append("</svg>");
        String string = strb.toString();
        return string;
    }

    public static String toSvgFileContent(long mediaId, String prePath, double baseWidthMm, double baseHeightMm, double fullWidth, double fullHeight, List<MediaBg> bgList, List<MediaMaterialParamEx> materialList, List<MediaCoverMaterial> coverMaterialList, String ResultType) throws Exception {
        List<MediaBgModel> svgList = MediaDao.toSvgList(mediaId, baseWidthMm, baseHeightMm, prePath, false, bgList, materialList, coverMaterialList, ResultType);
        if (svgList.size() == 0) {
            return "";
        }
        StringBuffer strb = new StringBuffer();
        strb.append("<?xml version=\"1.0\" standalone=\"no\"?>").append("\r\n");
        strb.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">").append("\r\n");
        double curHeight = 0.0;
        StringBuffer html = new StringBuffer();
        int i = 0;
        while (i < svgList.size()) {
            MediaBgModel bg = svgList.get(i);
            html.append("<svg y=\"" + curHeight + "\">").append("\r\n");
            html.append(bg.getSvgCode()).append("\r\n");
            html.append("</svg>").append("\r\n");
            curHeight = bg.getOddEven() == 0L ? (curHeight += fullHeight) : (curHeight += fullWidth);
            ++i;
        }
        double curWidth = fullWidth;
        if (fullHeight > fullWidth) {
            curWidth = fullHeight;
        }
        strb.append("<svg width=\"" + curWidth + "\" height=\"" + curHeight + "\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        strb.append(html.toString());
        strb.append("</svg>");
        return strb.toString();
    }

    public static List<MediaBgModel> toSvgList(long mediaId, double baseWidthMm, double baseHeightMm, String prePath, boolean isEditable, List<MediaBg> bgList, List<MediaMaterialParamEx> materials, List<MediaCoverMaterial> coverMaterials, String ResultType) throws Exception {
        Selector selector;
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            return new ArrayList<MediaBgModel>();
        }
        baseWidthMm = baseWidthMm <= 0.0 ? canvas.getBaseWidthMm() : baseWidthMm;
        double d = baseHeightMm = baseHeightMm <= 0.0 ? canvas.getBaseHeightMm() : baseHeightMm;
        if (bgList == null || bgList.size() == 0) {
            selector = new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid");
            bgList = ((ZTable)ORM.get(ZTable.class)).list(MediaBg.class, selector);
        } else {
            Collections.sort(bgList, new Comparator<MediaBg>(){

                @Override
                public int compare(MediaBg o1, MediaBg o2) {
                    return o1.getBid() - o2.getBid();
                }
            });
        }
        if (materials == null || materials.size() == 0) {
            selector = new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid");
            materials = ((ZView)ORM.get(ZView.class)).list(MediaMaterialParamEx.class, selector.addOrderbyAsc("mid"));
        } else {
            Collections.sort(materials, new Comparator<MediaMaterialParamEx>(){

                @Override
                public int compare(MediaMaterialParamEx o1, MediaMaterialParamEx o2) {
                    return o1.getBid() - o2.getBid();
                }
            });
        }
        if (coverMaterials == null || coverMaterials.size() == 0) {
            Selector selector2 = new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid");
            coverMaterials = ((ZTable)ORM.get(ZTable.class)).list(MediaCoverMaterial.class, selector2.addOrderbyAsc("mid"));
        } else {
            Collections.sort(coverMaterials, new Comparator<MediaCoverMaterial>(){

                @Override
                public int compare(MediaCoverMaterial o1, MediaCoverMaterial o2) {
                    int flag = o1.getBid() - o2.getBid();
                    return flag != 0 ? flag : o1.getMid() - o2.getMid();
                }
            });
        }
        ArrayList<MediaBgModel> svgList = new ArrayList<MediaBgModel>();
        int i = 0;
        while (i < bgList.size()) {
            MediaBg bg = (MediaBg)bgList.get(i);
            MediaDao.updateCanvasFullSize(canvas, baseWidthMm, baseHeightMm, true);
            String svgTemplate = MediaDao.toSvgCode(canvas, bg, i, materials, coverMaterials, prePath, isEditable, ResultType);
            MediaBgModel data = new MediaBgModel();
            Objects.copyDeep((Object)bg, (Object)data);
            data.setSvgCode(svgTemplate);
            svgList.add(data);
            ++i;
        }
        return svgList;
    }

    public static String toPageSvgCode(MediaCanvas canvas, MediaBg bg, List<? extends MediaMaterial> materialList, int pageWidth, String prePath) throws Exception {
        if (Validates.isEmpty((String)prePath)) {
            prePath = "";
        }
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        if (bg.getOddEven() == 1L) {
            width = canvas.getHeight();
            height = canvas.getWidth();
        }
        double pageHeight = (double)pageWidth * height / width;
        StringBuffer strb = new StringBuffer();
        strb.append("<svg width=\"").append(pageWidth).append("\" height=\"").append(pageHeight).append("\" viewBox=\"0 0 ").append(width).append(" ").append(height).append("\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        strb.append(MediaDao.buildBgSvg(bg, width, height, prePath));
        if (Validates.isNotEmpty(materialList)) {
            for (MediaMaterial mediaMaterial : materialList) {
                if (mediaMaterial.getBid() != bg.getBid()) continue;
                strb.append(MediaDao.buildMaterialSvg(mediaMaterial, prePath, false));
            }
        }
        strb.append("</svg>");
        String string = strb.toString();
        return string;
    }

    public static String buildBgSvg(MediaBg bg, double width, double height, String prePath) {
        StringBuffer strb = new StringBuffer();
        String source = bg.getSource();
        source = MediaDao.addPrePath(source, prePath);
        strb.append(source);
        return strb.toString();
    }

    public static String buildMaterialSvg(MediaMaterial m, String prePath, boolean isEditable) {
        String source = m.getSource();
        source = m.getType() == 1 ? MediaDao.buildMaterialTextSvg(m, isEditable) : MediaDao.addPrePath(source, prePath);
        StringBuffer strb = new StringBuffer();
        strb.append(source).append("\r\n");
        return strb.toString();
    }

    public static String buildCoverMaterialSvg(MediaCoverMaterial c, String prePath) {
        String source = c.getSource();
        source = MediaDao.addPrePath(source, prePath);
        StringBuffer strb = new StringBuffer();
        strb.append(source).append("\r\n");
        return strb.toString();
    }

    public static String buildMaterialTextSvg(MediaMaterial m, boolean isEditable) {
        String source = m.getSource();
        if (isEditable) {
            MediaSvgText svgText = new MediaSvgText(source);
            try {
                svgText.init();
                source = svgText.toXml();
            }
            catch (Exception e) {
                System.out.println(Strings.formats((String)"bid:[%s]mid:[%s]", (Object[])new Object[]{m.getBid(), m.getMid()}));
                throw e;
            }
        }
        return source;
    }

    public static List<String> toSvgTemplate(long mediaId, String prePath) throws Exception {
        ArrayList<String> templateList = new ArrayList<String>();
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            return templateList;
        }
        Selector selector = new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid");
        List bgList = ((ZTable)ORM.get(ZTable.class)).list(MediaBg.class, selector);
        List materialList = ((ZView)ORM.get(ZView.class)).list(MediaMaterialParamEx.class, selector.addOrderbyAsc("mid"));
        for (MediaBg bg : bgList) {
            String svgTemplate = MediaDao.toSvgTemplate(canvas, bg, materialList, prePath);
            templateList.add(svgTemplate);
        }
        return templateList;
    }

    public static String parseSvgTemplate(long mediaId, String svgTemplate, Map<String, Object> replaceMap) throws Exception {
        Selector selector = new Selector();
        selector.addMust("mediaId", (Object)mediaId);
        List materialList = ((ZView)ORM.get(ZView.class)).list(MediaMaterialParamEx.class, selector.addOrderbyAsc("mid"));
        for (MediaMaterialParamEx m : materialList) {
            if (Validates.isEmpty((String)m.getParamKey()) || m.getType() != 1 || !replaceMap.containsKey(m.getParamKey())) continue;
            String str = (String)replaceMap.get(m.getParamKey());
            String value = MediaDao.replaceMaterialText(m.getSource(), str);
            replaceMap.put(m.getParamKey(), value);
        }
        HashMapSO map = new HashMapSO(replaceMap);
        return Zmls.parse((String)svgTemplate, (MapSO)map, (MapS[])new MapS[0]);
    }

    public static String parseMediaTemplate(long mediaId, String prePath, Map<String, Object> replaceMap) throws Exception {
        String svgTemplate = "";
        List<String> svgCodeList = MediaDao.toSvgTemplate(mediaId, prePath);
        for (String svgCode : svgCodeList) {
            svgTemplate = String.valueOf(svgTemplate) + svgCode;
        }
        return MediaDao.parseSvgTemplate(mediaId, svgTemplate, replaceMap);
    }

    public static String replaceMaterialText(String svgCode, String replaceStr) {
        MaterialTextSvg mts = new MaterialTextSvg(svgCode);
        mts.parse();
        return mts.derive(replaceStr);
    }

    private static String toSvgTemplate(MediaCanvas canvas, MediaBg bg, List<MediaMaterialParamEx> materialList, String prePath) throws Exception {
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        if (bg.getOddEven() == 1L) {
            width = canvas.getHeight();
            height = canvas.getWidth();
        }
        StringBuffer strb = new StringBuffer();
        strb.append("<svg width=\"").append(width).append("\" height=\"").append(height).append("\" viewBox=\"0 0 ").append(width).append(" ").append(height).append("\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        strb.append(MediaDao.buildBgSvg(bg, width, height, prePath));
        if (Validates.isNotEmpty(materialList)) {
            for (MediaMaterialParamEx m : materialList) {
                String value;
                if (m.getBid() != bg.getBid()) continue;
                String source = m.getSource();
                String paramKey = m.getParamKey();
                int type = m.getType();
                if (!Validates.isNotEmpty((String)paramKey) || type == 3) continue;
                if (type == 1) {
                    value = "<#if Validates.isNotEmpty(" + paramKey + ")>" + "${" + paramKey + "}" + "<#else>" + source + "</#if>";
                    strb.append(value);
                    continue;
                }
                value = MediaDao.getImageValue(source);
                String replacement = "<#if Validates.isNotEmpty(" + paramKey + ")>" + "${" + paramKey + "}" + "<#else>" + value + "</#if>";
                m.setSource(source.replace(value, replacement));
                String svgCode = MediaDao.buildMaterialSvg(m, prePath, false);
                strb.append(svgCode);
                m.setSource(source);
            }
        }
        strb.append("</svg>");
        String svgXml = strb.toString();
        return svgXml;
    }

    public static String addPrePath(String svgCode, String prePath) {
        if (Validates.isEmpty((String)svgCode)) {
            return "";
        }
        String regex = "\"/service/upl/";
        String replacement = "\"" + Strings.removeEndsWith((String)prePath, (String)"/") + "/service/upl/";
        svgCode = Strings.replaceAll((String)svgCode, (String)regex, (String)replacement);
        regex = "\"/service/upll/";
        replacement = "\"" + Strings.removeEndsWith((String)prePath, (String)"/") + "/service/upll/";
        svgCode = Strings.replaceAll((String)svgCode, (String)regex, (String)replacement);
        return svgCode;
    }

    public static String getImageValue(String str) {
        if (Validates.isEmpty((String)str)) {
            return "";
        }
        int ind1 = str.indexOf("<image");
        if (ind1 == -1) {
            return "";
        }
        str = str.substring(ind1);
        String value = "";
        try {
            value = Xmls.getString((String)str, (String)"xlink:href");
        }
        catch (Exception exception) {}
        return value;
    }

    public static String toAiZipFile(long mediaId) throws Exception {
        long id = Ids.longId();
        String curDate = DateTimes.getDateTime8String();
        String fileDirPath = MediaPathDao.getTempLocalPre(String.valueOf(curDate) + "/" + id);
        MediaModel mediaModel = MediaDao.getMedia(mediaId);
        for (MediaBg bg : mediaModel.getBgList()) {
            String svgCode = MediaDao.toAiSvg(mediaModel.getCanvas(), bg, mediaModel.getMaterialList(), fileDirPath);
            MediaSvgDocument document = new MediaSvgDocument(svgCode);
            document.init();
            String content = document.toXml();
            String fileName = String.valueOf(bg.getBid() + 1) + ".svg";
            Files.writeUTF8((String)(String.valueOf(fileDirPath) + fileName), (String)content);
        }
        String zipExportPath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + id + ".zip";
        Zips.zip((String)fileDirPath, (String)zipExportPath);
        return String.valueOf(MediaPathDao.getTempUrlPre(curDate)) + id + ".zip";
    }

    public static String toAiSvg(MediaCanvas canvas, MediaBg bg, List<? extends MediaMaterial> materialList, String fileDirPath) throws Exception {
        UpllFile upllFile;
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        StringBuffer strb = new StringBuffer();
        strb.append("<svg width=\"").append(width).append("\" height=\"").append(height).append("\" viewBox=\"0 0 ").append(width).append(" ").append(height).append("\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        if (Validates.isNotEmpty((String)bg.getFileId()) && (upllFile = (UpllFile)((ZTable)ORM.get(ZTable.class)).item(UpllFile.class, new Selector("fileId", (Object)bg.getFileId()).addReplace("id", null))) != null) {
            String ext = Files.getFileExt((String)upllFile.getFileName());
            String value = MediaDao.getImageValue(bg.getSource());
            String fileName = String.valueOf(bg.getFileId()) + "." + ext;
            String source = bg.getSource().replace(value, fileName);
            bg.setSource(source);
            Files.copyFile((String)upllFile.getFilePath(), (String)(String.valueOf(fileDirPath) + fileName));
        }
        strb.append("<g data-type=\"1\">").append(bg.getSource()).append("</g>");
        if (Validates.isNotEmpty(materialList)) {
            for (MediaMaterial mediaMaterial : materialList) {
                if (mediaMaterial.getBid() != bg.getBid()) continue;
                int type = 2;
                if (mediaMaterial.getType() == 0 || mediaMaterial.getType() == 2) {
                    String value = MediaDao.getImageValue(mediaMaterial.getSource());
                    if (Validates.isNotEmpty((String)mediaMaterial.getFileId())) {
                        UpllFile upfile2 = (UpllFile)((ZTable)ORM.get(ZTable.class)).item(UpllFile.class, new Selector("fileId", (Object)mediaMaterial.getFileId()).addReplace("id", null));
                        if (upfile2 != null) {
                            String ext = Files.getFileExt((String)upfile2.getFileName());
                            String fileName = String.valueOf(mediaMaterial.getFileId()) + "." + ext;
                            String source = mediaMaterial.getSource().replace(value, fileName);
                            mediaMaterial.setSource(source);
                            Files.copyFile((String)upfile2.getFilePath(), (String)(String.valueOf(fileDirPath) + fileName));
                        }
                    } else if (mediaMaterial.getType() == 2) {
                        String fileName = Files.getFileName((String)value);
                        String filepath = String.valueOf(MediaPathDao.getSysMaterialLocalPre(MaterialConstants.MATERIAL_QCODE.value())) + fileName;
                        String source = mediaMaterial.getSource().replace(value, fileName);
                        mediaMaterial.setSource(source);
                        Files.copyFile((String)filepath, (String)(String.valueOf(fileDirPath) + fileName));
                    }
                } else {
                    type = mediaMaterial.getType() == 1 ? 3 : 4;
                }
                String mid = "m_" + bg.getBid() + "_" + mediaMaterial.getMid();
                String str = " id=\"" + mid + "\" data-type=\"" + type + "\"";
                strb.append(mediaMaterial.getSource().substring(0, 2)).append(str).append(mediaMaterial.getSource().substring(2));
            }
        }
        strb.append("</svg>");
        String string = strb.toString();
        return string;
    }

    public static List<MediaImageUse> recordBgRefNum(List<MediaBg> bgList, String type) throws Exception {
        ArrayList<MediaImageUse> useList = new ArrayList<MediaImageUse>();
        if (bgList == null || bgList.isEmpty()) {
            return useList;
        }
        for (MediaBg bg : bgList) {
            MediaImageUse ref;
            String fileId = bg.getFileId();
            if (Validates.isEmpty((String)fileId) || (ref = MediaDao.recordRefNum(fileId, 1, type)) == null) continue;
            useList.add(ref);
        }
        return useList;
    }

    public static List<MediaImageUse> recordMaterialRefNum(List<? extends MediaMaterial> materialList, String type) throws Exception {
        ArrayList<MediaImageUse> useList = new ArrayList<MediaImageUse>();
        if (materialList == null || materialList.isEmpty()) {
            return useList;
        }
        for (MediaMaterial mediaMaterial : materialList) {
            MediaImageUse ref;
            String fileId = mediaMaterial.getFileId();
            if (Validates.isEmpty((String)fileId) || (ref = MediaDao.recordRefNum(fileId, 0, type)) == null) continue;
            useList.add(ref);
        }
        return useList;
    }

    public static MediaImageUse recordRefNum(String fileId, int materialType, String type) throws Exception {
        MediaImageUse ref = (MediaImageUse)((ZTable)ORM.get(ZTable.class)).item(MediaImageUse.class, new Object[]{fileId});
        if (ref != null) {
            if ("add".equals(type)) {
                ref.setNum(ref.getNum() + 1);
            } else {
                ref.setNum(ref.getNum() - 1);
            }
            return ref;
        }
        if ("add".equals(type)) {
            UpllFile ufile = (UpllFile)((ZTable)ORM.get(ZTable.class)).item(UpllFile.class, new Selector("fileId", (Object)fileId).addReplace("id", null));
            if (ufile == null) {
                return null;
            }
            ref = new MediaImageUse();
            ref.setFileId(fileId);
            ref.setNum(1);
            ref.setOperateTime(DateTimes.getDateTimeString());
            ref.setUrl(ufile.getFileUrl());
            return ref;
        }
        return null;
    }

    public static String createMediaEffect(long mediaId) throws Exception {
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            return null;
        }
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        List<String> pdfList = PdfDao.getPdfList(canvas, 2, false, null, null, null, "IMAGE");
        String prePath = MediaPathDao.getTempLocalPre(DateTimes.getDateTime8String());
        List<String> imageList = PdfDao.pdfToImage(pdfList, prePath, "jpg", (int)width, (int)height, 2);
        return MediaDao.createMediaEffect(mediaId, width, height, imageList);
    }

    public static String createMediaEffect(long mediaId, double width, double height, List<String> imageList) throws Exception {
        if (imageList == null || imageList.isEmpty()) {
            return null;
        }
        String type = "1";
        if (width > height) {
            type = "2";
        }
        String fileName = "imp_" + Ids.longId() + ".jpg";
        String destPath = String.valueOf(MediaPathDao.getCanvasLocalPre(mediaId)) + fileName;
        int borderWidth = 8;
        if (imageList.size() == 1) {
            borderWidth = 0;
        }
        GraphicsMagickUtil.merge(imageList, (int)width, (int)height, destPath, borderWidth, type);
        return String.valueOf(MediaPathDao.getCanvasUrlPre(mediaId)) + fileName;
    }

    public static long doSaveMediaHandleModel(MediaHandleModel handleModel) {
        return ((MediaCanvasController)((Object)Global.getService(MediaCanvasController.class))).postMediaHandleModelRequest(handleModel);
    }

    public static long doSaveMediaHandleModel(long mediaId, String mediaJson, String paramJson) {
        return ((MediaCanvasController)((Object)Global.getService(MediaCanvasController.class))).postMediaHandleModelRequest(mediaId, mediaJson, paramJson);
    }

    public static long doSaveMediaHandleModel(long mediaId, String mediaJson, String paramJson, boolean isCreateMediaImage, boolean isDoImgCallback) {
        MediaCanvasController controller = (MediaCanvasController)((Object)Global.getService(MediaCanvasController.class));
        return controller.postMediaHandleModelRequest(mediaId, mediaJson, paramJson, isCreateMediaImage, isDoImgCallback);
    }

    public static MediaHandleModel doQueryMediaHandleModel(long handleId, boolean onlyStatus) {
        MediaCanvasController controller = (MediaCanvasController)((Object)Global.getService(MediaCanvasController.class));
        MediaHandleModel model = controller.getMediaHandleModel(handleId);
        MediaHandleModel jsonModel = null;
        if (model != null) {
            jsonModel = onlyStatus ? new MediaHandleModel() : model;
            jsonModel.setErrorMsg(model.getErrorMsg());
            jsonModel.setHandleStatus(model.getHandleStatus());
            jsonModel.setMediaId(model.getMediaId());
            jsonModel.setMediaId(model.getHandleId());
            if (jsonModel.getHandleStatus() == 2 || jsonModel.getHandleStatus() == 3) {
                controller.removeMediaHandleModel(handleId);
            }
        }
        return jsonModel;
    }

    public static long doMediaHandleToPdf(MediaHandlePdfModel model) {
        return ((MediaCanvasController)((Object)Global.getService(MediaCanvasController.class))).postMediaHandlePdfModelRequest(model);
    }

    public static MediaHandlePdfModel doQueryMediaHandlePdfModel(long mediaId, boolean onlyStatus) {
        MediaCanvasController controller = (MediaCanvasController)((Object)Global.getService(MediaCanvasController.class));
        MediaHandlePdfModel model = controller.getMediaHandlePdfModel(mediaId);
        MediaHandlePdfModel jsonModel = null;
        if (model != null) {
            if (onlyStatus) {
                jsonModel = new MediaHandlePdfModel(model.getCanvas(), model.getMegerPdfPage(), model.isEditable(), model.getPdfSavePath());
                jsonModel.setErrorMsg(model.getErrorMsg());
                jsonModel.setHandleStatus(model.getHandleStatus());
                jsonModel.setMediaId(mediaId);
                jsonModel.setImgPathList(model.getImgPathList());
                jsonModel.setHandleId(model.getHandleId());
                jsonModel.setPdfImgDir(model.getPdfImgDir());
                jsonModel.setDownloadUrl(model.getDownloadUrl());
            } else {
                jsonModel = model;
            }
            if (jsonModel.getHandleStatus() == 2 || jsonModel.getHandleStatus() == 3) {
                controller.removeMediaHandlePdfModel(mediaId);
            }
        }
        return jsonModel;
    }

    public static MediaHandlePdfModel doFinishMediaToPdf(long mediaId) {
        MediaCanvasController controller = (MediaCanvasController)((Object)Global.getService(MediaCanvasController.class));
        return controller.getHandlePdfFinish(mediaId);
    }

    public static void main(String[] args) throws Exception {
        String str = "13123<image xlink:href=\"/service/upl/5aqS5L2T57Sg5p2QL21hdGVyaWFsL2ltYWdl/0D99D4F3CE5E47178D5E3E8D64E61326.jpg\" width=\"100%\" height=\"100%\"/>12312 13123<image xlink:href=\"/service/upl/5aqS5L2T57Sg5p2QL21hdGVyaWFsL2ltYWdl/0D99D4F3CE5E47178D5E3E8D64E61326.jpg\" width=\"100%\" height=\"100%\"/>12312";
        String ret = MediaDao.getImageValue(str);
        System.out.println(ret);
        String value = Xmls.getString((String)str, (String)"xlink:href");
        System.out.println(value);
        String text = "<text xml:space=\"preserve\" font-family=\"\u5fae\u8f6f\u96c5\u9ed1\" font-size=\"36\" fill=\"#000000\" font-weight=\"normal\" font-style=\"normal\" text-decoration=\"none\" y=\"38.5\"><tspan x=\"0\" dy=\"0\">\u6d4b\u8bd51</tspan><tspan x=\"0\" dy=\"0\">\u53cc\u51fb\u4fee\u6539\u6587\u5b57</tspan></text>";
        String paramKey = "name";
        String paramValue = "\u53cc\u51fb\u4fee\u6539\u6587\u5b57";
        String replacement = "<#if Validates.isNotEmpty(" + paramKey + ")>" + "${" + paramKey + "}" + "<#else>" + paramValue + "</#if>";
        String res = text.replace(paramValue, replacement);
        System.out.println(res);
    }

    public static void updateCanvasFullSize(MediaCanvas canvas, double baseWidthMm, double baseHeightMm, boolean doSet) {
        if (canvas.getBaseWidthMm() <= 0.0) {
            canvas.setBaseWidthMm(92.0);
        }
        if (canvas.getBaseHeightMm() <= 0.0) {
            canvas.setBaseHeightMm(56.0);
        }
        baseWidthMm = baseWidthMm <= 0.0 ? canvas.getBaseWidthMm() : baseWidthMm;
        baseHeightMm = baseHeightMm <= 0.0 ? canvas.getBaseHeightMm() : baseHeightMm;
        canvas.setBaseWidthMm(baseWidthMm);
        canvas.setBaseHeightMm(baseHeightMm);
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        double widthMm = canvas.getWidthMm();
        double heightMm = canvas.getHeightMm();
        double fullWidth = canvas.getFullWidth();
        double fullHeight = canvas.getFullHeight();
        double fullWidthMm = canvas.getFullWidthMm();
        double fullHeightMm = canvas.getFullHeightMm();
        if (fullWidth >= width && fullHeight >= height && fullWidthMm >= widthMm && fullHeightMm >= heightMm) {
            return;
        }
        int wh = (int)((widthMm - 1.0) / baseHeightMm + 1.0);
        int hw = (int)((heightMm - 1.0) / baseWidthMm + 1.0);
        int ww = (int)((widthMm - 1.0) / baseWidthMm + 1.0);
        int hh = (int)((heightMm - 1.0) / baseHeightMm + 1.0);
        if (wh * hw < ww * hh) {
            widthMm = canvas.getHeightMm();
            heightMm = canvas.getWidthMm();
            fullWidthMm = baseWidthMm * (double)hw;
            fullHeightMm = baseHeightMm * (double)wh;
            if (doSet) {
                canvas.setWidthMm(widthMm);
                canvas.setHeightMm(heightMm);
                canvas.setWidth(UnitUtil.mm2pixel(widthMm, canvas.getDpi()));
                canvas.setHeight(UnitUtil.mm2pixel(heightMm, canvas.getDpi()));
            }
        } else {
            fullWidthMm = baseWidthMm * (double)ww;
            fullHeightMm = baseHeightMm * (double)hh;
        }
        if (doSet) {
            canvas.setFullWidthMm(fullWidthMm);
            canvas.setFullHeightMm(fullHeightMm);
            canvas.setFullWidth(UnitUtil.mm2pixel(fullWidthMm, canvas.getDpi()));
            canvas.setFullHeight(UnitUtil.mm2pixel(fullHeightMm, canvas.getDpi()));
        }
    }
}

