/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.utils;

import com.alibaba.fastjson.JSON;
import com.zhiqim.media.manage.utils.CollectionUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final String APPLICATION_JSON_UTF8_VALUE = "application/json;charset=UTF-8";
    private static RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();

    public static URIBuilder setUriBuilderParameters(URIBuilder uriBuilder, TreeMap<String, String> urlParamsMap) {
        if (!CollectionUtils.isEmpty(urlParamsMap)) {
            Set<Map.Entry<String, String>> entrySet = urlParamsMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (entry == null || entry.getValue() == null) continue;
                String tempKey = entry.getKey();
                String tempValue = entry.getValue();
                uriBuilder.addParameter(tempKey, tempValue);
            }
        }
        return uriBuilder;
    }

    public static HttpGet addAllHeadersOfGet(HttpGet httpGet, TreeMap<String, String> headersMap) {
        if (!CollectionUtils.isEmpty(headersMap)) {
            Set<Map.Entry<String, String>> entrySet = headersMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (entry == null || entry.getValue() == null) continue;
                String tempKey = entry.getKey();
                String tempValue = entry.getValue();
                httpGet.addHeader(tempKey, tempValue);
            }
        }
        return httpGet;
    }

    public static HttpPost addAllHeadersOfPost(HttpPost httpPost, TreeMap<String, String> headersMap) {
        if (!CollectionUtils.isEmpty(headersMap)) {
            Set<Map.Entry<String, String>> entrySet = headersMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (entry == null || entry.getValue() == null) continue;
                String tempKey = entry.getKey();
                String tempValue = entry.getValue();
                httpPost.addHeader(tempKey, tempValue);
            }
        }
        return httpPost;
    }

    public static HttpPost setPostJsonEntity(HttpPost httpPost, LinkedHashMap<String, Object> jsonParamsMap) throws UnsupportedEncodingException {
        if (!CollectionUtils.isEmpty(jsonParamsMap)) {
            StringEntity stringEntity = new StringEntity(JSON.toJSONString(jsonParamsMap), Charset.forName("UTF-8"));
            stringEntity.setContentType(APPLICATION_JSON_VALUE);
            stringEntity.setContentEncoding("UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        return httpPost;
    }

    public static HttpPost setPostJsonStrEntity(HttpPost httpPost, String jsonStr) throws UnsupportedEncodingException {
        if (jsonStr != null && !"".equals(jsonStr)) {
            StringEntity stringEntity = new StringEntity(jsonStr, Charset.forName("UTF-8"));
            stringEntity.setContentType(APPLICATION_JSON_VALUE);
            stringEntity.setContentEncoding("UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        return httpPost;
    }

    public static HttpPost setPostFormEntity(HttpPost httpPost, LinkedHashMap<String, String> formParamsMap) throws UnsupportedEncodingException {
        if (!CollectionUtils.isEmpty(formParamsMap)) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : formParamsMap.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity stringEntity = new UrlEncodedFormEntity(list, "UTF-8");
            stringEntity.setContentType(APPLICATION_FORM_URLENCODED_VALUE);
            stringEntity.setContentEncoding("UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        return httpPost;
    }

    public static String sendGet(String url) throws URISyntaxException, IOException {
        return HttpClientUtil.sendGet(url, null, null, null);
    }

    public static String sendGet(String url, TreeMap<String, String> urlParamsMap) throws URISyntaxException, IOException {
        return HttpClientUtil.sendGet(url, urlParamsMap, null, null);
    }

    public static String sendGet(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, RequestConfig defineRequestConfig) throws URISyntaxException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String result = "";
        URIBuilder uriBuilder = new URIBuilder(url);
        if (!CollectionUtils.isEmpty(urlParamsMap)) {
            uriBuilder = HttpClientUtil.setUriBuilderParameters(uriBuilder, urlParamsMap);
        }
        URI uri = uriBuilder.build();
        HttpGet httpGet = new HttpGet(uri);
        if (!CollectionUtils.isEmpty(headersMap)) {
            httpGet = HttpClientUtil.addAllHeadersOfGet(httpGet, headersMap);
        }
        if (defineRequestConfig != null) {
            httpGet.setConfig(defineRequestConfig);
        } else {
            httpGet.setConfig(defaultRequestConfig);
        }
        httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        HttpClientUtil.doClose(httpClient, httpResponse);
        return result;
    }

    public static String sendJsonPost(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, LinkedHashMap<String, Object> jsonParamsMap) throws URISyntaxException, IOException {
        return HttpClientUtil.sendJsonPost(url, urlParamsMap, headersMap, jsonParamsMap, null);
    }

    public static String sendJsonPost(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, LinkedHashMap<String, Object> jsonParamsMap, RequestConfig defineRequestConfig) throws URISyntaxException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String result = "";
        URIBuilder uriBuilder = new URIBuilder(url);
        if (!CollectionUtils.isEmpty(urlParamsMap)) {
            uriBuilder = HttpClientUtil.setUriBuilderParameters(uriBuilder, urlParamsMap);
        }
        URI uri = uriBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        if (!CollectionUtils.isEmpty(headersMap)) {
            httpPost = HttpClientUtil.addAllHeadersOfPost(httpPost, headersMap);
        }
        if (defineRequestConfig != null) {
            httpPost.setConfig(defineRequestConfig);
        } else {
            httpPost.setConfig(defaultRequestConfig);
        }
        if (!CollectionUtils.isEmpty(jsonParamsMap)) {
            httpPost = HttpClientUtil.setPostJsonEntity(httpPost, jsonParamsMap);
        }
        httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        HttpClientUtil.doClose(httpClient, httpResponse);
        return result;
    }

    public static String sendJsonPost(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, String jsonStr) throws URISyntaxException, IOException {
        return HttpClientUtil.sendJsonPost(url, urlParamsMap, headersMap, jsonStr, null);
    }

    public static String sendJsonPost(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, String jsonStr, RequestConfig defineRequestConfig) throws URISyntaxException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String result = "";
        URIBuilder uriBuilder = new URIBuilder(url);
        if (!CollectionUtils.isEmpty(urlParamsMap)) {
            uriBuilder = HttpClientUtil.setUriBuilderParameters(uriBuilder, urlParamsMap);
        }
        URI uri = uriBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        if (!CollectionUtils.isEmpty(headersMap)) {
            httpPost = HttpClientUtil.addAllHeadersOfPost(httpPost, headersMap);
        }
        if (defineRequestConfig != null) {
            httpPost.setConfig(defineRequestConfig);
        } else {
            httpPost.setConfig(defaultRequestConfig);
        }
        if (jsonStr != null && !"".equals(jsonStr)) {
            httpPost = HttpClientUtil.setPostJsonStrEntity(httpPost, jsonStr);
        }
        httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        HttpClientUtil.doClose(httpClient, httpResponse);
        return result;
    }

    public static String sendFormPost(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, LinkedHashMap<String, String> formParamsMap) throws URISyntaxException, IOException {
        return HttpClientUtil.sendFormPost(url, urlParamsMap, headersMap, formParamsMap, null);
    }

    public static String sendFormPost(String url, TreeMap<String, String> urlParamsMap, TreeMap<String, String> headersMap, LinkedHashMap<String, String> formParamsMap, RequestConfig defineRequestConfig) throws URISyntaxException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        String result = "";
        URIBuilder uriBuilder = new URIBuilder(url);
        if (!CollectionUtils.isEmpty(urlParamsMap)) {
            uriBuilder = HttpClientUtil.setUriBuilderParameters(uriBuilder, urlParamsMap);
        }
        URI uri = uriBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        if (!CollectionUtils.isEmpty(headersMap)) {
            httpPost = HttpClientUtil.addAllHeadersOfPost(httpPost, headersMap);
        }
        if (defineRequestConfig != null) {
            httpPost.setConfig(defineRequestConfig);
        } else {
            httpPost.setConfig(defaultRequestConfig);
        }
        if (!CollectionUtils.isEmpty(formParamsMap)) {
            httpPost = HttpClientUtil.setPostFormEntity(httpPost, formParamsMap);
        }
        httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        HttpClientUtil.doClose(httpClient, httpResponse);
        return result;
    }

    public static void doClose(CloseableHttpClient httpClient, CloseableHttpResponse httpResponse) throws IOException {
        if (httpClient != null) {
            httpClient.close();
        }
        if (httpResponse != null) {
            httpResponse.close();
        }
    }
}

