/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.zhiqim.media.manage.model.DzmpImageModel;
import com.zhiqim.media.manage.model.DzmpUserCardModel;
import com.zhiqim.media.manage.utils.CollectionUtils;
import com.zhiqim.media.manage.utils.HttpClientUtil;
import com.zhiqim.media.manage.utils.QiyeWechatUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;

public class DzmpServiceClientUtil {
    private static final Log log = LogFactory.getLog(DzmpServiceClientUtil.class);
    public static final String GATE_WAY_URL = Global.getString((String)"businessPlatform", (String)"gatewayUrl");
    private static final String CREATE_CARD_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/usercard/createDefaultCard";
    private static final String UPDATE_CARD_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/usercard/update";
    private static final String QUERY_CARD_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/usercard";
    private static final String QUERY_CARD_LIST_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/usercard/list";
    private static final String DELETE_CARD_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/usercard/del";
    private static final String QUERY_CARD_IMAGE_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/image/list";
    private static final String QUERY_IMAGE_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/image";
    private static final String SAVE_CARD_IMAGE_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/image/save";
    private static final String BATCH_SAVE_CARD_IMAGE_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/image/batchSave";
    private static final String DELETE_CARD_IMAGE_URL = String.valueOf(GATE_WAY_URL) + "api-busi/dzmp/image/del";
    private static final String SJPT_SYSTEM_TYPE = "sjpt";

    public static String getAccessToken() throws URISyntaxException, IOException {
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        String url = String.valueOf(GATE_WAY_URL) + "admin-auth/oauth/token";
        paramMap.put("username", "designClientUser");
        paramMap.put("password", "123456");
        paramMap.put("grant_type", "password");
        paramMap.put("scope", "scope_DesignClient_trust");
        paramMap.put("client_id", "DesignClient");
        paramMap.put("client_secret", "secret_DesignClient20190101");
        TreeMap<String, String> headersMap = new TreeMap<String, String>();
        headersMap.put("Content-Type", "application/json");
        LinkedHashMap<String, Object> jsonParamsMap = new LinkedHashMap<String, Object>();
        String access_token = "";
        String resultText = HttpClientUtil.sendJsonPost(url, paramMap, headersMap, jsonParamsMap);
        HashMapSO map = Jsons.toMapSO((String)resultText);
        if (Validates.isNotEmpty((Object)map)) {
            access_token = String.valueOf(map.get("access_token"));
        }
        return access_token;
    }

    public static String doCreateDefaultCard(long designId) {
        String result = "";
        try {
            TreeMap<String, String> headersMap = new TreeMap<String, String>();
            headersMap.put("Content-Type", "application/json");
            TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
            urlParamsMap.put("systemType", SJPT_SYSTEM_TYPE);
            urlParamsMap.put("access_token", DzmpServiceClientUtil.getAccessToken());
            LinkedHashMap<String, Long> jsonParamsMap = new LinkedHashMap<String, Long>();
            jsonParamsMap.put("designId", designId);
            String rsltStr = HttpClientUtil.sendJsonPost(CREATE_CARD_URL, urlParamsMap, headersMap, JSON.toJSONString(jsonParamsMap));
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    String dataStr;
                    HashMapSO dataMaps;
                    if (Validates.isNotEmpty((Object)rsltMaps.get("data")) && Validates.isNotEmpty((Object)(dataMaps = Jsons.toMapSO((String)(dataStr = String.valueOf(rsltMaps.get("data"))))).get("id"))) {
                        result = String.valueOf(dataMaps.get("id"));
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u521b\u5efa\u9ed8\u8ba4\u540d\u7247\u5931\u8d25\uff1a[" + rsltStr + "]";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u521b\u5efa\u9ed8\u8ba4\u540d\u7247\u8bf7\u6c42\u5931\u8d25\uff1a[" + rsltStr + "]";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u521b\u5efa\u9ed8\u8ba4\u540d\u7247\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return result;
    }

    public static String doCreateCardInfo(DzmpUserCardModel dzmpUserCardModel) {
        String result = "";
        try {
            TreeMap<String, String> headersMap = new TreeMap<String, String>();
            headersMap.put("Content-Type", "application/json");
            TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
            urlParamsMap.put("systemType", SJPT_SYSTEM_TYPE);
            urlParamsMap.put("access_token", DzmpServiceClientUtil.getAccessToken());
            String rsltStr = HttpClientUtil.sendJsonPost(CREATE_CARD_URL, urlParamsMap, headersMap, JSON.toJSONString((Object)dzmpUserCardModel));
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    String dataStr;
                    HashMapSO dataMaps;
                    if (Validates.isNotEmpty((Object)rsltMaps.get("data")) && Validates.isNotEmpty((Object)(dataMaps = Jsons.toMapSO((String)(dataStr = String.valueOf(rsltMaps.get("data"))))).get("id"))) {
                        result = String.valueOf(dataMaps.get("id"));
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u521b\u5efa\u540d\u7247\u5931\u8d25\uff1a[" + rsltStr + "]" + JSON.toJSONString((Object)dzmpUserCardModel);
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u521b\u5efa\u540d\u7247\u8bf7\u6c42\u5931\u8d25\uff1a[" + rsltStr + "]" + JSON.toJSONString((Object)dzmpUserCardModel);
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u521b\u5efa\u540d\u7247\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return result;
    }

    public static boolean doUpdateCard(DzmpUserCardModel userCard) {
        boolean flag = Boolean.FALSE;
        if (Validates.isNotEmpty((Object)userCard)) {
            try {
                TreeMap<String, String> headersMap = new TreeMap<String, String>();
                headersMap.put("Content-Type", "application/json");
                TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
                urlParamsMap.put("systemType", SJPT_SYSTEM_TYPE);
                urlParamsMap.put("access_token", DzmpServiceClientUtil.getAccessToken());
                String rsltStr = HttpClientUtil.sendJsonPost(UPDATE_CARD_URL, urlParamsMap, headersMap, JSON.toJSONString((Object)userCard));
                if (Validates.isNotEmpty((String)rsltStr)) {
                    HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                    if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                        flag = Boolean.TRUE;
                    } else {
                        String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u4fee\u6539\u540d\u7247\u4fe1\u606f\u5931\u8d25";
                        log.error((Object)tempMsg);
                        QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u4fee\u6539\u540d\u7247\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            }
            catch (Exception e) {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u4fee\u6539\u540d\u7247\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        return flag;
    }

    public static DzmpUserCardModel doQueryCardById(long cardId) {
        DzmpUserCardModel card = null;
        try {
            String url = String.valueOf(QUERY_CARD_URL) + "/" + cardId;
            String rsltStr = HttpClientUtil.sendGet(url);
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    if (Validates.isNotEmpty((Object)rsltMaps.get("data"))) {
                        String dataStr = String.valueOf(rsltMaps.get("data"));
                        card = (DzmpUserCardModel)JSONObject.parseObject((String)dataStr, DzmpUserCardModel.class);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u5355\u4e2a\u540d\u7247\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u5355\u4e2a\u540d\u7247\u8bf7\u6c42\u5931\u8d25";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u5355\u4e2a\u540d\u7247\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return card;
    }

    public static List<DzmpUserCardModel> doQueryCardListByOrdId(long orderId) {
        List<DzmpUserCardModel> cardList = new ArrayList<DzmpUserCardModel>();
        try {
            TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
            urlParamsMap.put("designId", String.valueOf(orderId));
            String rsltStr = HttpClientUtil.sendGet(QUERY_CARD_LIST_URL, urlParamsMap);
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    if (Validates.isNotEmpty((Object)rsltMaps.get("data"))) {
                        String dataStr = String.valueOf(rsltMaps.get("data"));
                        cardList = (List)JSON.parseObject((String)dataStr, (TypeReference)new TypeReference<List<DzmpUserCardModel>>(){}, (Feature[])new Feature[0]);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u8bbe\u8ba1\u5e73\u53f0\u8ba2\u5355\u53f7\u67e5\u8be2\u540d\u7247\u96c6\u5408\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u8bbe\u8ba1\u5e73\u53f0\u8ba2\u5355\u53f7\u67e5\u8be2\u540d\u7247\u96c6\u5408\u8bf7\u6c42\u5931\u8d25";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u8bbe\u8ba1\u5e73\u53f0\u8ba2\u5355\u53f7\u67e5\u8be2\u540d\u7247\u96c6\u5408\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return cardList;
    }

    public static boolean doDeleteCardById(long cardId) {
        boolean flag = Boolean.FALSE;
        try {
            String url = String.valueOf(DELETE_CARD_URL) + "/" + cardId;
            String rsltStr = HttpClientUtil.sendGet(url);
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    flag = Boolean.TRUE;
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u540d\u7247id\u5220\u9664\u540d\u7247\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u540d\u7247id\u5220\u9664\u540d\u7247\u8bf7\u6c42\u5931\u8d25";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u540d\u7247id\u5220\u9664\u540d\u7247\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return flag;
    }

    public static List<DzmpImageModel> doQueryPersonalAlbum(long cardId) {
        List<DzmpImageModel> imageList = new ArrayList<DzmpImageModel>();
        try {
            TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
            urlParamsMap.put("type", String.valueOf(1));
            urlParamsMap.put("userCardId", String.valueOf(cardId));
            String rsltStr = HttpClientUtil.sendGet(QUERY_CARD_IMAGE_URL, urlParamsMap);
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    if (Validates.isNotEmpty((Object)rsltMaps.get("data"))) {
                        String dataStr = String.valueOf(rsltMaps.get("data"));
                        imageList = (List)JSON.parseObject((String)dataStr, (TypeReference)new TypeReference<List<DzmpImageModel>>(){}, (Feature[])new Feature[0]);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u7528\u6237\u540d\u7247\u5bf9\u5e94\u7684\u4e2a\u4eba\u76f8\u518c\u56fe\u7247\u96c6\u5408\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u7528\u6237\u540d\u7247\u5bf9\u5e94\u7684\u4e2a\u4eba\u76f8\u518c\u56fe\u7247\u96c6\u5408\u8bf7\u6c42\u5931\u8d25";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u67e5\u8be2\u7528\u6237\u540d\u7247\u5bf9\u5e94\u7684\u4e2a\u4eba\u76f8\u518c\u56fe\u7247\u96c6\u5408\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return imageList;
    }

    public static DzmpImageModel doQueryDzmpImage(long imgId) {
        DzmpImageModel newImage = null;
        try {
            String url = String.valueOf(QUERY_IMAGE_URL) + "/" + imgId;
            String rsltStr = HttpClientUtil.sendGet(url);
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    if (Validates.isNotEmpty((Object)rsltMaps.get("data"))) {
                        String dataStr = String.valueOf(rsltMaps.get("data"));
                        newImage = (DzmpImageModel)JSONObject.parseObject((String)dataStr, DzmpImageModel.class);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u56fe\u7247id\u67e5\u8be2\u56fe\u7247\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u56fe\u7247id\u67e5\u8be2\u56fe\u7247\u5931\u8d25";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6839\u636e\u56fe\u7247id\u67e5\u8be2\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return newImage;
    }

    public static DzmpImageModel doCreateImageInfo(DzmpImageModel image) {
        DzmpImageModel newImage = null;
        if (Validates.isNotEmpty((Object)image)) {
            try {
                TreeMap<String, String> headersMap = new TreeMap<String, String>();
                headersMap.put("Content-Type", "application/json");
                TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
                urlParamsMap.put("systemType", SJPT_SYSTEM_TYPE);
                urlParamsMap.put("access_token", DzmpServiceClientUtil.getAccessToken());
                String rsltStr = HttpClientUtil.sendJsonPost(SAVE_CARD_IMAGE_URL, urlParamsMap, headersMap, JSON.toJSONString((Object)image));
                if (Validates.isNotEmpty((String)rsltStr)) {
                    HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                    if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                        if (Validates.isNotEmpty((Object)rsltMaps.get("data"))) {
                            String dataStr = String.valueOf(rsltMaps.get("data"));
                            newImage = (DzmpImageModel)JSONObject.parseObject((String)dataStr, DzmpImageModel.class);
                        }
                    } else {
                        String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u4fdd\u5b58\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u5931\u8d25";
                        log.error((Object)tempMsg);
                        QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u4fdd\u5b58\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            }
            catch (Exception e) {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u4fdd\u5b58\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        return newImage;
    }

    public static boolean doBatchCreateImageInfo(LinkedHashMap<String, Object> jsonParamsMap) {
        boolean flag = Boolean.FALSE;
        if (!CollectionUtils.isEmpty(jsonParamsMap)) {
            try {
                TreeMap<String, String> headersMap = new TreeMap<String, String>();
                headersMap.put("Content-Type", "application/json");
                TreeMap<String, String> urlParamsMap = new TreeMap<String, String>();
                urlParamsMap.put("systemType", SJPT_SYSTEM_TYPE);
                urlParamsMap.put("access_token", DzmpServiceClientUtil.getAccessToken());
                String rsltStr = HttpClientUtil.sendJsonPost(BATCH_SAVE_CARD_IMAGE_URL, urlParamsMap, headersMap, JSON.toJSONString(jsonParamsMap));
                if (Validates.isNotEmpty((String)rsltStr)) {
                    HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                    if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                        flag = Boolean.TRUE;
                    } else {
                        String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6279\u91cf\u4fdd\u5b58\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u5931\u8d25";
                        log.error((Object)tempMsg);
                        QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                    }
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6279\u91cf\u4fdd\u5b58\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            }
            catch (Exception e) {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u6279\u91cf\u4fdd\u5b58\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        return flag;
    }

    public static boolean doDeleteImageById(long imageId) {
        boolean flag = Boolean.FALSE;
        try {
            String url = String.valueOf(DELETE_CARD_IMAGE_URL) + "/" + imageId;
            String rsltStr = HttpClientUtil.sendGet(url);
            if (Validates.isNotEmpty((String)rsltStr)) {
                HashMapSO rsltMaps = Jsons.toMapSO((String)rsltStr);
                if (Validates.isNotEmpty((Object)rsltMaps.get("code")) && "0".equals(rsltMaps.get("code").toString())) {
                    flag = Boolean.TRUE;
                } else {
                    String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u5220\u9664\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u5931\u8d25";
                    log.error((Object)tempMsg);
                    QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
                }
            } else {
                String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u5220\u9664\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25";
                log.error((Object)tempMsg);
                QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
            }
        }
        catch (Exception e) {
            String tempMsg = "\u8c03\u7528\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u5220\u9664\u7528\u6237\u540d\u7247\u56fe\u7247\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + e;
            log.error((Object)tempMsg);
            QiyeWechatUtil.sendMsgToQiyeWechat(tempMsg);
        }
        return flag;
    }
}

