/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.presenter;

import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.dzmp.DzmpImageStorage;
import com.zhiqim.media.dbo.dzmp.DzmpUserCardStorage;
import com.zhiqim.media.manage.utils.CollectionUtils;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.oss.service.oss.OssService;
import com.zhiqim.oss.service.oss.OssUploadService;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.uploadlarge.dbo.UpllFile;

@AnAlias(value={"MediaCardPresenter"})
@AnIntercept(value={"chkZmrLogin"})
public class MediaCardPresenter {
    private static final Log log = LogFactory.getLog(MediaCardPresenter.class);
    private static String bucketName = Global.getString((String)"oss", (String)"yangcai_bucketName");
    private static boolean isInternal = "true".equalsIgnoreCase(Global.getString((String)"oss", (String)"isInternal"));
    private static byte[] lock = new byte[0];

    public static void doUpdateCard(HttpRequest httpRequest) throws Exception {
        long cardId = httpRequest.getParameterLong("cardId");
        long designId = httpRequest.getParameterLong("designId");
        if (cardId < 0L) {
            httpRequest.setResponseError("\u540d\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (designId < 0L) {
            httpRequest.setResponseError("\u8bbe\u8ba1\u5e73\u53f0\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        String cardBackground = httpRequest.getParameter("cardBackground");
        int cardBackgroundType = httpRequest.getParameterInt("cardBackgroundType", 0);
        String userRemark = (String)httpRequest.getParameterMap().get("userRemark");
        String cardAvatar = httpRequest.getParameter("cardAvatar");
        String userCardName = httpRequest.getParameter("userCardName");
        String mobile = httpRequest.getParameter("mobile");
        String landline = httpRequest.getParameter("landline");
        String wxcode = httpRequest.getParameter("wxcode");
        String userQq = httpRequest.getParameter("userQq");
        String userEmail = httpRequest.getParameter("userEmail");
        String userFax = httpRequest.getParameter("userFax");
        String websiteUrl = httpRequest.getParameter("websiteUrl");
        String address = httpRequest.getParameter("address");
        String companyAlias = httpRequest.getParameter("companyAlias");
        String position = httpRequest.getParameter("position");
        if (Validates.isNotEmpty((String)userRemark)) {
            userRemark = userRemark.replaceAll("[\\t|\\x0B| ]", "\u00a0");
        }
        if (Validates.isNotEmpty((String)userRemark)) {
            userRemark = MediaCardPresenter.dealRedundantSpaceAndBlankLine(userRemark);
        }
        Updater updater = new Updater();
        updater.addMust("id", (Object)cardId);
        updater.addField("designId", (Object)designId);
        if (Validates.isNotEmptyBlank((String)cardBackground)) {
            updater.addField("cardBackground", (Object)cardBackground);
        }
        if (Validates.isNotEmptyBlank((String)cardAvatar)) {
            updater.addField("cardAvatar", (Object)cardAvatar);
        }
        updater.addField("cardBackgroundType", (Object)cardBackgroundType);
        updater.addField("userRemark", (Object)userRemark);
        updater.addField("cardAvatar", (Object)cardAvatar);
        updater.addField("userCardName", (Object)userCardName);
        updater.addField("mobile", (Object)mobile);
        updater.addField("landline", (Object)landline);
        updater.addField("wxcode", (Object)wxcode);
        updater.addField("userQq", (Object)userQq);
        updater.addField("userEmail", (Object)userEmail);
        updater.addField("userFax", (Object)userFax);
        updater.addField("websiteUrl", (Object)websiteUrl);
        updater.addField("address", (Object)address);
        updater.addField("companyAlias", (Object)companyAlias);
        updater.addField("position", (Object)position);
        updater.addField("updateOperatorCode", (Object)httpRequest.getSessionName());
        updater.addField("updateTime", (Object)Sqls.nowTimestamp());
        ((ZTable)ORM.get(ZTable.class)).update(DzmpUserCardStorage.class, updater);
    }

    public static void doSubmitDraftOrderCard(HttpRequest httpRequest) {
        long designId = httpRequest.getParameterLong("designId");
        System.out.println("\u8ba2\u5355[" + designId + "]\u5b8c\u6210\u521d\u7a3f");
    }

    public static void doSubmitFinalOrderCard(HttpRequest httpRequest) {
        long designId = httpRequest.getParameterLong("designId");
        String url = httpRequest.getParameter("url");
        System.out.println("\u8ba2\u5355[" + designId + "]\u5b8c\u6210\u5b9a\u7a3f," + url);
    }

    public static void doDelAlbumImgById(HttpRequest httpRequest) throws Exception {
        long imgId = httpRequest.getParameterLong("imgId");
        if (imgId < 0L) {
            httpRequest.setResponseError("\u76f8\u518c\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        DzmpImageStorage image = (DzmpImageStorage)((ZTable)ORM.get(ZTable.class)).item(DzmpImageStorage.class, new Selector("id", (Object)imgId));
        if (Validates.isNotEmpty((Object)image) && Validates.isNotEmpty((String)image.getImgUrl())) {
            OssService ossService = (OssService)Global.get(OssService.class);
            ossService.deleteFile(bucketName, image.getImgUrl());
        }
        ((ZTable)ORM.get(ZTable.class)).delete(DzmpImageStorage.class, new Object[]{imgId});
    }

    public static void doUplaodDzmpFile(HttpRequest httpRequest) throws Exception {
        String operatorCode = httpRequest.getSessionName();
        long cardId = httpRequest.getParameterLong("cardId");
        int renewType = httpRequest.getParameterInt("renewType", 0);
        String fileId = httpRequest.getParameter("fileId");
        if (cardId < 0L) {
            httpRequest.setResponseError("\u540d\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (renewType < 1) {
            httpRequest.setResponseError("\u66f4\u65b0\u6807\u8bb0renewType\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (Validates.isEmpty((String)fileId)) {
            httpRequest.setResponseError("\u4e34\u65f6\u6587\u4ef6fileId\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        UpllFile upllFile = (UpllFile)((ZTable)ORM.get(ZTable.class)).item(UpllFile.class, new Selector("fileId", (Object)fileId).addReplace("id", null));
        if (Validates.isEmpty((Object)upllFile)) {
            httpRequest.setResponseError(String.valueOf(fileId) + "\u5bf9\u5e94\u7684\u6587\u4ef6\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        String tempPath = upllFile.getFilePath();
        File file = new File(tempPath);
        if (!file.exists() || file.isDirectory()) {
            String tempMsg = "\u540d\u7247[" + cardId + "]\u4e0a\u4f20\u5230OSS\u65f6\u6587\u4ef6\u4e0d\u5b58\u5728[" + tempPath + "]";
            log.error((Object)tempMsg);
            httpRequest.setResponseError(tempMsg);
            return;
        }
        String fileKey = MediaCardPresenter.getCardOssKey(renewType, upllFile.getFileName(), null);
        OssUploadService ossUploadService = (OssUploadService)Global.get(OssUploadService.class);
        String ossUrl = ossUploadService.uploadFile(bucketName, fileKey, tempPath, isInternal);
        Files.deleteFile((String)tempPath);
        ((ZTable)ORM.get(ZTable.class)).delete(UpllFile.class, new Selector("fileId", (Object)fileId).addReplace("id", null));
        String imgId = "";
        DzmpImageStorage dzmpImage = null;
        if (Validates.isNotEmpty((String)ossUrl)) {
            Updater updater;
            if (renewType == 1) {
                DzmpImageStorage image = new DzmpImageStorage();
                image.setId(Ids.longId13_4());
                image.setType(1);
                image.setUserCardId(cardId);
                image.setImgUrl(ossUrl);
                image.setState(1);
                image.setAddOperatorCode(operatorCode);
                image.setAddTime(Sqls.nowTimestamp());
                ((ZTable)ORM.get(ZTable.class)).insert((Object)image);
                imgId = String.valueOf(image.getId());
                dzmpImage = image;
            }
            if (renewType == 2) {
                updater = new Updater();
                updater.addMust("id", (Object)cardId);
                updater.addField("cardBackground", (Object)ossUrl);
                updater.addField("updateOperatorCode", (Object)operatorCode);
                updater.addField("updateTime", (Object)Sqls.nowTimestamp());
                ((ZTable)ORM.get(ZTable.class)).update(DzmpUserCardStorage.class, updater);
            }
            if (renewType == 3) {
                if (Validates.isNotEmpty((String)ossUrl)) {
                    ossUrl = ossUrl.replace("https", "http");
                }
                updater = new Updater();
                updater.addMust("id", (Object)cardId);
                updater.addField("cardAvatar", (Object)ossUrl);
                updater.addField("updateOperatorCode", (Object)operatorCode);
                updater.addField("updateTime", (Object)Sqls.nowTimestamp());
                ((ZTable)ORM.get(ZTable.class)).update(DzmpUserCardStorage.class, updater);
            }
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("ossUrl", ossUrl);
        jsonMap.put("imgId", imgId);
        jsonMap.put("dzmpImage", dzmpImage);
        httpRequest.setResponseResult(Jsons.toString(jsonMap));
    }

    public static String getCardOssKey(int renewType, String fileName, String suffixName) {
        StringBuffer newFileName = new StringBuffer();
        String randomCode = MediaCardPresenter.getEightUniqueCode();
        if (Validates.isNotEmpty((String)fileName)) {
            suffixName = fileName.substring(fileName.lastIndexOf("."));
        }
        String fileKey = "";
        if (renewType == 1) {
            newFileName.append("1").append("-").append(randomCode).append(suffixName);
            fileKey = "dzmpImages/" + DateTimes.getDateTime7String() + "/1/" + newFileName.toString();
        }
        if (renewType == 2) {
            newFileName.append("5").append("-").append(randomCode).append(suffixName);
            fileKey = "dzmpImages/" + DateTimes.getDateTime7String() + "/5/" + newFileName.toString();
        }
        if (renewType == 3) {
            newFileName.append("4").append("-").append(randomCode).append(suffixName);
            fileKey = "dzmpImages/" + DateTimes.getDateTime7String() + "/4/" + newFileName.toString();
        }
        return fileKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEightUniqueCode() {
        long r = 0L;
        byte[] byArray = lock;
        synchronized (lock) {
            r = (long)((Math.random() + 1.0) * 1.0E7);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return String.valueOf(r);
        }
    }

    public static void doSaveDzmpCardUrl(HttpRequest httpRequest) throws Exception {
        String operatorCode = httpRequest.getSessionName();
        long cardId = httpRequest.getParameterLong("cardId");
        if (cardId < 0L) {
            httpRequest.setResponseError("\u540d\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        httpRequest.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!httpRequest.chkValidate()) {
            httpRequest.setResponseError(httpRequest.getAlertMsg());
            return;
        }
        DzmpUserCardStorage cardStorage = (DzmpUserCardStorage)((ZTable)ORM.get(ZTable.class)).item(DzmpUserCardStorage.class, new Selector("id", (Object)cardId));
        if (Validates.isEmpty((Object)cardStorage)) {
            httpRequest.setResponseError("\u8bbe\u8ba1\u5e73\u53f0\u4e0d\u5b58\u5728\u3010" + cardId + "\u3011\u7535\u5b50\u540d\u7247");
            return;
        }
        long mediaId = httpRequest.getParameterLong("mediaId");
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            httpRequest.setResponseError("\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f\u540e\u8fdb\u884c\u8be5\u64cd\u4f5c");
            return;
        }
        String urlTemp = MediaPathDao.parseUplUrl(canvas.getMediaUrl());
        if (!Files.exists((String)urlTemp)) {
            return;
        }
        String fileKey = "dzmpImages/" + DateTimes.getDateTime7String() + "/" + cardId + ".png";
        if (Validates.isNotEmpty((String)cardStorage.getCardUrl()) && Validates.isUrl((String)cardStorage.getCardUrl())) {
            OssService ossService = (OssService)Global.get(OssService.class);
            ossService.deleteFile(bucketName, cardStorage.getCardUrl());
            fileKey = "dzmpImages" + cardStorage.getCardUrl().split("dzmpImages")[1];
        }
        OssUploadService ossUploadService = (OssUploadService)Global.get(OssUploadService.class);
        String ossUrl = ossUploadService.uploadFile(bucketName, fileKey, urlTemp, isInternal);
        Updater updater = new Updater();
        updater.addMust("id", (Object)cardId);
        updater.addField("cardUrl", (Object)ossUrl);
        updater.addField("updateOperatorCode", (Object)operatorCode);
        updater.addField("updateTime", (Object)Sqls.nowTimestamp());
        ((ZTable)ORM.get(ZTable.class)).update(DzmpUserCardStorage.class, updater);
    }

    public static void doSortAlbumList(HttpRequest httpRequest) throws Exception {
        String imageIds = httpRequest.getParameter("imageIds");
        if (Validates.isEmptyBlank((String)imageIds)) {
            return;
        }
        ArrayList<Long> imgIdList = new ArrayList<Long>();
        if (imageIds.contains(",")) {
            String[] imgIdArray;
            String[] stringArray = imgIdArray = imageIds.split(",");
            int n = imgIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                String imgId = stringArray[n2];
                if (Validates.isNotEmptyBlank((String)imgId)) {
                    imgIdList.add(Long.parseLong(imgId));
                }
                ++n2;
            }
        } else {
            imgIdList.add(Long.parseLong(imageIds));
        }
        String operatorCode = httpRequest.getSessionName();
        Timestamp nowTimestamp = Sqls.nowTimestamp();
        if (!CollectionUtils.isEmpty(imgIdList)) {
            int i = 0;
            while (i < imgIdList.size()) {
                Updater updater = new Updater();
                updater.addMust("id", imgIdList.get(i));
                updater.addField("sort", (Object)i);
                updater.addField("updateOperatorCode", (Object)operatorCode);
                updater.addField("updateTime", (Object)nowTimestamp);
                ((ZTable)ORM.get(ZTable.class)).update(DzmpImageStorage.class, updater);
                ++i;
            }
        }
    }

    public static String dealRedundantSpaceAndBlankLine(String content) {
        if (Validates.isEmpty((String)content)) {
            return "";
        }
        StringBuilder strAfterRemoveCRSB = new StringBuilder();
        int i = 0;
        while (i < content.length()) {
            if (content.charAt(i) != '\r') {
                strAfterRemoveCRSB.append(content.charAt(i));
            }
            ++i;
        }
        String strAfterRemoveCR = strAfterRemoveCRSB.toString();
        if (strAfterRemoveCR == null || strAfterRemoveCR.length() == 0) {
            return "";
        }
        StringBuilder resultSB = new StringBuilder();
        String[] lines = strAfterRemoveCR.split("\n");
        int blankCount = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null) {
                String lineTrim = line.trim();
                if ("".equals(lineTrim)) {
                    if (++blankCount <= 2) {
                        resultSB.append("\n");
                    }
                } else {
                    blankCount = 0;
                    resultSB.append(line).append("\n");
                }
            }
            ++n2;
        }
        resultSB.deleteCharAt(resultSB.length() - 1);
        return resultSB.toString();
    }

    public static String dealSpace4OneLine(String line) {
        if (line == null || "".equals(line)) {
            return "";
        }
        int spaceCount = 0;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char curChar = line.charAt(i);
            if (curChar == ' ') {
                if (++spaceCount < 10) {
                    sb.append(' ');
                }
            } else {
                spaceCount = 0;
                sb.append(curChar);
            }
            ++i;
        }
        return sb.toString();
    }
}

