/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.presenter;

import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrDeptPresenter"})
@AnIntercept(value={"chkZmrLogin"})
public class ZmrDeptPresenter
implements ZmrConstants {
    public static void doShowDeptOperatorList(HttpRequest request) throws Exception {
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1L) {
            request.setResponseError("\u60a8\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u90e8\u95e8");
            return;
        }
        ZmrDept dept = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
        if (dept == null) {
            request.setResponseError("\u60a8\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u90e8\u95e8");
            return;
        }
        Selector selector = new Selector();
        selector.addMustLike("operatorDept", (Object)deptId);
        List operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class, selector);
        HashMapSO variable = new HashMapSO();
        variable.put("dept", (Object)dept);
        variable.put("operatorList", (Object)operatorList);
        String responseText = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/zhiqim_manager/presenter/deptOperatorInfo.zml", (MapSO)variable);
        request.setResponseResult(responseText);
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        sessionUser.setValue("zmr_session_user_dept_id", deptId);
    }

    public static void doShowDeptRuleList(HttpRequest request) throws Exception {
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1L) {
            request.setResponseError("\u60a8\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u90e8\u95e8");
            return;
        }
        ZmrDept dept = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
        if (dept == null) {
            request.setResponseError("\u60a8\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u90e8\u95e8");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        List ruleList = ZmrBootstrap.table(request).list(ZmrDeptRule.class, new Selector("deptId", (Object)deptId));
        List<ZmrMenu> list = ZmrOrgDao.getMenuList(request, dept.getOrgId());
        Tree tree = TreeBuilder.newTree(list, (String)"parentCode", (String)"menuCode");
        HashMapSO variable = new HashMapSO();
        variable.put("dept", (Object)dept);
        variable.put("tree", (Object)tree);
        variable.put("menuSize", (Object)list.size());
        variable.put("ruleList", (Object)ruleList);
        String responseText = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zview/zhiqim_manager/presenter/deptRuleInfo.zml", (MapSO)variable);
        request.setResponseResult(responseText);
        sessionUser.setValue("zmr_session_user_dept_id", deptId);
    }

    public static void doAddDeptOperator(HttpRequest request) throws Exception {
        String[] operatorCodeArr;
        request.addValidate((Validate)new IsNotEmpty("deptId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u90e8\u95e8"));
        request.addValidate((Validate)new IsNotEmpty("operatorCodes", "\u8bf7\u9009\u62e9\u64cd\u4f5c\u5458"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long deptId = request.getParameterLong("deptId");
        ZmrDept dept = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
        if (dept == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u90e8\u95e8");
            return;
        }
        String[] stringArray = operatorCodeArr = Arrays.toStringArray((String)request.getParameter("operatorCodes"));
        int n = operatorCodeArr.length;
        int n2 = 0;
        while (n2 < n) {
            String operatorCode = stringArray[n2];
            ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
            if (operator != null) {
                String operatorDept = operator.getOperatorDept();
                operatorDept = Validates.isEmpty((String)operatorDept) ? "" + deptId : String.valueOf(operatorDept) + "," + deptId;
                String operatorDeptAll = operator.getOperatorDeptAll();
                operatorDeptAll = Validates.isEmpty((String)operatorDeptAll) ? dept.getDeptParentAll() : String.valueOf(operatorDeptAll) + "," + dept.getDeptParentAll();
                operatorDeptAll = String.valueOf(operatorDeptAll) + "," + operatorDept;
                operatorDeptAll = Arrays.toFilterSameStr((String[])Arrays.toStringArray((String)operatorDeptAll));
                Updater updater = new Updater();
                updater.addField("operatorDept", (Object)operatorDept);
                updater.addField("operatorDeptAll", (Object)operatorDeptAll);
                updater.addMust("operatorCode", (Object)operatorCode);
                ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
                ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
                sessionUser.setValue("zmr_session_user_dept_id", deptId);
            }
            ++n2;
        }
    }
}

