/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOrg;
import org.zhiqim.manager.dbo.ZmrRole;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class OrgAction
extends StdSwitchAction
implements ZmrConstants {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsInteger("orgId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u9009\u9879"));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsLen("orgName", "\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u6c49\u5b57", 1, 32));
        request.addValidate((Validate)new IsIntegerValue("orgSeq", "\u7ec4\u7ec7\u6392\u5e8f\u5fc5\u987b\u662f[0, 999999]\u8303\u56f4\u7684\u975e\u8d1f\u6574\u6570", 0, 999999));
        request.addValidate((Validate)new IsLen("orgDesc", "\u7ec4\u7ec7\u63cf\u8ff0\u53ef\u4e3a\u7a7a\u6216\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u6c49\u5b57", 0, 100));
    }

    protected void list(HttpRequest request) throws Exception {
        List list = ZmrBootstrap.tableOpr(request).list(ZmrOrg.class, new Selector().addOrderbyAsc("orgLevel,orgStatus"));
        request.setAttribute("list", (Object)list);
    }

    protected void add(HttpRequest request) throws Exception {
        ZmrOrg parent = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Selector("orgLevel", (Object)0));
        if (parent == null) {
            request.returnHistory("\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u7ec4\u7ec7");
            return;
        }
        request.setAttribute("parent", (Object)parent);
    }

    protected void modify(HttpRequest request) throws Exception {
        long orgId = request.getParameterLong("orgId");
        ZmrOrg org = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Object[]{orgId});
        if (org == null) {
            request.returnHistory("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u7ec4\u7ec7");
            return;
        }
        request.setAttribute("org", (Object)org);
    }

    protected void insert(HttpRequest request) throws Exception {
        ZmrOrg org = (ZmrOrg)request.getParameter(ZmrOrg.class);
        org.setOrgId(Ids.longId13());
        org.setOrgLevel(1);
        ZmrBootstrap.table(request).insert((Object)org);
        ZmrDept dept = new ZmrDept();
        dept.setOrgId(org.getOrgId());
        dept.setParentId(0L);
        dept.setDeptId(org.getOrgId());
        dept.setDeptName(org.getOrgName());
        dept.setDeptStatus(0);
        dept.setDeptLevel(0);
        dept.setDeptParentAll("0");
        ZmrBootstrap.table(request).insert((Object)dept);
    }

    protected void update(HttpRequest request) throws Exception {
        String oldOrgManager;
        long orgId = request.getParameterLong("orgId");
        ZmrOrg org = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Selector("orgId", (Object)orgId));
        String orgName = request.getParameter("orgName");
        int orgStatus = request.getParameterInt("orgStatus");
        int orgSeq = request.getParameterInt("orgSeq");
        String orgManager = request.getParameter("orgManager");
        String orgManagerArr = request.getParameter("orgManagerArr");
        String orgDesc = request.getParameter("orgDesc");
        Updater updater = new Updater();
        updater.addMust("orgId", (Object)orgId);
        updater.addField("orgName", (Object)orgName);
        updater.addField("orgStatus", (Object)orgStatus);
        updater.addField("orgSeq", (Object)orgSeq);
        updater.addField("orgManager", (Object)orgManager);
        updater.addField("orgManagerArr", (Object)orgManagerArr);
        updater.addField("orgDesc", (Object)orgDesc);
        ZmrBootstrap.tableOpr(request).update(ZmrOrg.class, updater);
        if (Validates.isNotEmpty((String)orgManager)) {
            Updater operatorUpdater = new Updater();
            operatorUpdater.addMust("operatorCode", (Object)orgManager);
            operatorUpdater.addField("operatorType", (Object)1);
            ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, operatorUpdater);
        }
        if (Validates.isNotEmpty((String)(oldOrgManager = org.getOrgManager())) && !oldOrgManager.equals(orgManager)) {
            Updater operatorUpdater = new Updater();
            operatorUpdater.addMust("operatorCode", (Object)oldOrgManager);
            operatorUpdater.addField("operatorType", (Object)2);
            ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, operatorUpdater);
        }
    }

    protected void delete(HttpRequest request) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        long orgId = request.getParameterLong("orgId");
        if (sessionUser.getSelectedOrgId() == orgId) {
            request.returnHistory("\u5f53\u524d\u9009\u4e2d\u7ec4\u7ec7\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5207\u6362\u7ec4\u7ec7");
            return;
        }
        ZmrOrg org = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Object[]{orgId});
        if (org == null) {
            request.returnHistory("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u7ec4\u7ec7");
            return;
        }
        if (org.getOrgLevel() == 0) {
            request.returnHistory("\u9876\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u5220\u9664\uff0c\u53ea\u5141\u8bb8\u4fee\u6539");
            return;
        }
        if (ZmrBootstrap.table(request).count(ZmrDept.class, new Selector("orgId", (Object)orgId)) > 1) {
            request.returnHistory("\u8be5\u7ec4\u7ec7\u5df2\u6709\u90e8\u95e8\uff0c\u8981\u5148\u5220\u9664\u90e8\u95e8\uff08\u6839\u90e8\u95e8\u9664\u5916\uff09\u624d\u80fd\u5220\u9664\u672c\u7ec4\u7ec7");
            return;
        }
        if (ZmrBootstrap.table(request).count(ZmrRole.class, new Selector("orgId", (Object)orgId)) > 0) {
            request.returnHistory("\u8be5\u7ec4\u7ec7\u5df2\u6709\u89d2\u8272\uff0c\u8981\u5148\u5220\u9664\u89d2\u8272\u624d\u80fd\u5220\u9664\u672c\u7ec4\u7ec7");
            return;
        }
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, (Selector)new Selector().addMust("orgId", (Object)orgId)) > 0) {
            request.returnHistory("\u8be5\u7ec4\u7ec7\u5df2\u6709\u64cd\u4f5c\u5458\uff0c\u8bf7\u5220\u9664\u7ec4\u7ec7\u6210\u5458\u540e\u518d\u5220\u9664\u672c\u7ec4\u7ec7");
            return;
        }
        ZmrDept dept = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, (Selector)new Selector("orgId", (Object)orgId).addMust("deptLevel", (Object)0));
        if (dept != null) {
            long deptId = dept.getDeptId();
            ZmrBootstrap.table(request).delete(ZmrDeptRule.class, new Selector("deptId", (Object)deptId));
            ZmrBootstrap.table(request).delete(ZmrDept.class, new Object[]{deptId});
        }
        ZmrBootstrap.tableOpr(request).delete(ZmrOrg.class, new Object[]{orgId});
    }
}

