/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOperatorRule;
import org.zhiqim.orm.dbo.Selector;

public class OperatorRuleAction
extends GetPostAction {
    protected void validate(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u8bf7\u9009\u62e9\u64cd\u4f5c\u5458"));
    }

    protected void doGet(HttpRequest request) throws Exception {
        request.setResponsePrivateCache();
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728");
            return;
        }
        List ruleList = ZmrBootstrap.table(request).list(ZmrOperatorRule.class, new Selector("operatorCode", (Object)operatorCode));
        long orgId = operator.getOrgId();
        List<ZmrMenu> list = ZmrOrgDao.getMenuList(request, orgId);
        if (list.isEmpty()) {
            request.setRedirect("/manager/operator.htm", "\u8bf7\u5148\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650");
            return;
        }
        Tree tree = TreeBuilder.newTree(list, (String)"parentCode", (String)"menuCode");
        request.setAttribute("operator", (Object)operator);
        request.setAttribute("menuSize", (Object)list.size());
        request.setAttribute("tree", (Object)tree);
        request.setAttribute("ruleList", (Object)ruleList);
    }

    protected void doPost(HttpRequest request) throws Exception {
        String operatorCode = request.getParameter("operatorCode");
        String[] itemCodes = request.getParameterValues("rule");
        if (itemCodes == null) {
            itemCodes = new String[]{};
        }
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Object[]{operatorCode}) == 0) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728");
            return;
        }
        ZmrBootstrap.table(request).delete(ZmrOperatorRule.class, new Selector("operatorCode", (Object)operatorCode));
        if (itemCodes.length > 0) {
            ArrayList<ZmrOperatorRule> bathList = new ArrayList<ZmrOperatorRule>();
            int i = 0;
            while (i < itemCodes.length) {
                ZmrOperatorRule rule = new ZmrOperatorRule();
                rule.setOperatorCode(operatorCode);
                rule.setMenuCode(itemCodes[i]);
                bathList.add(rule);
                ++i;
            }
            ZmrBootstrap.table(request).insertBatch(bathList);
        }
        request.setAlertMsg("\u4fdd\u5b58\u6210\u529f");
        request.addParam("operatorCode", (Object)operatorCode);
    }
}

