/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrDeptDao;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.orm.dbo.Selector;

public class DeptRuleAction
extends GetPostAction
implements ZmrConstants {
    protected void validate(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("deptId", "\u8bf7\u9009\u62e9\u90e8\u95e8"));
    }

    protected void doGet(HttpRequest request) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        List<ZmrMenu> menuList = ZmrOrgDao.getMenuList(request, orgId);
        if (menuList.isEmpty()) {
            request.setRedirect("/manager/dept.htm", "\u8bf7\u5148\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650");
            return;
        }
        Tree<ZmrDept> tree = ZmrDeptDao.getOrgDeptTree(request, orgId);
        request.setAttribute("tree", tree);
    }

    protected void doPost(HttpRequest request) throws Exception {
        long deptId = request.getParameterLong("deptId");
        String[] menuCodes = request.getParameterValuesOnCNT("rule");
        if (menuCodes == null) {
            menuCodes = new String[]{};
        }
        if (ZmrBootstrap.table(request).count(ZmrDept.class, new Object[]{deptId}) == 0) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5b58\u5728");
            return;
        }
        ZmrBootstrap.table(request).delete(ZmrDeptRule.class, new Selector("deptId", (Object)deptId));
        if (menuCodes.length > 0) {
            ArrayList<ZmrDeptRule> bathList = new ArrayList<ZmrDeptRule>();
            int i = 0;
            while (i < menuCodes.length) {
                ZmrDeptRule rule = new ZmrDeptRule();
                rule.setDeptId(deptId);
                rule.setMenuCode(menuCodes[i]);
                bathList.add(rule);
                ++i;
            }
            ZmrBootstrap.table(request).insertBatch(bathList);
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        sessionUser.setValue("zmr_session_user_dept_id", deptId);
        request.setAlertMsg("\u4fdd\u5b58\u6210\u529f");
    }
}

