/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager;

import java.util.Collection;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.ItemType;
import org.zhiqim.kernel.control.Configurable;
import org.zhiqim.kernel.extend.SS;
import org.zhiqim.kernel.schedule.Day;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Images;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.RSA;
import org.zhiqim.manager.ZmrBootstrapApi;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrTask;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOrg;
import org.zhiqim.manager.dbo.ZmrOrgRule;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

public class ZmrBootstrap
extends ZmrBootstrapApi {
    private ZmrPassworder passworder;
    private ORMServer zmrServer;
    private ORMServer oprServer;

    public static ZTable table(HttpRequest request) {
        return ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).table();
    }

    public static ZTable tableOpr(HttpRequest request) {
        return ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).tableOpr();
    }

    public static ZTable table(HttpContext context) {
        return ((ZmrBootstrap)context.getAttribute(ZmrBootstrap.class)).table();
    }

    public static ZTable tableOpr(HttpContext context) {
        return ((ZmrBootstrap)context.getAttribute(ZmrBootstrap.class)).tableOpr();
    }

    public ZmrPassworder getPassworder() {
        return this.passworder;
    }

    public ZTable table() {
        return this.zmrServer.table();
    }

    public ZTable tableOpr() {
        return this.oprServer.table();
    }

    protected void initBefore() throws Exception {
        this.context.setAttribute(ZmrBootstrap.class, (Object)this);
        this.initORMServer();
        this.initPassworder();
    }

    protected void initAfter() throws Exception {
        this.initOperator();
        this.initMenu();
        this.initParam();
        this.initAvatar();
        this.initOrg();
        this.initOrgRule();
        this.initDept();
        this.context.setAttribute("themeIndex", (Object)ZmrParamDao.getThemeIndex((HttpContext)this.context));
        this.context.setAttribute("themeMain", (Object)ZmrParamDao.getThemeMain((HttpContext)this.context));
        Scheduler scheduler = (Scheduler)Global.getWithoutNew(Scheduler.class);
        scheduler.addTask((TaskThreader)new Day((Task)new ZmrTask(this), 5, 5, 5));
    }

    private void initORMServer() {
        String zmrOrm = this.context.getTopAttributeString("zmr.orm");
        if (Validates.isEmptyBlank((String)zmrOrm)) {
            this.zmrServer = ORM.server((Configurable)this.context);
        } else {
            this.zmrServer = ORM.server((String)zmrOrm);
            Asserts.asserts((this.zmrServer != null ? 1 : 0) != 0, (String)"\u4e0a\u4e0b\u6587\u73af\u5883[%s]\u914d\u7f6e\u7684\u7ba1\u7406\u53f0\u6570\u636e\u5e93ID[zmr.orm]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u670d\u52a1", (Object[])new Object[]{this.context.getContextName()});
        }
        String zmrOrmOpr = this.context.getTopAttributeString("zmr.orm.opr");
        if (Validates.isEmptyBlank((String)zmrOrmOpr)) {
            this.oprServer = this.zmrServer;
        } else {
            this.oprServer = ORM.server((String)zmrOrmOpr);
            Asserts.asserts((this.oprServer != null ? 1 : 0) != 0, (String)"\u4e0a\u4e0b\u6587\u73af\u5883[%s]\u914d\u7f6e\u7684\u7ba1\u7406\u53f0\u64cd\u4f5c\u5458\u6570\u636e\u5e93ID[zmr.orm.opr]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u670d\u52a1", (Object[])new Object[]{this.context.getContextName()});
        }
    }

    private void initPassworder() {
        String zmrPassworder = this.context.getTopAttributeString("zmr.passworder", "org.zhiqim.manager.ZmrPassworder");
        Object instance = Global.newInstance((String)zmrPassworder);
        Asserts.asserts((boolean)(instance instanceof ZmrPassworder), (String)"\u4e0a\u4e0b\u6587\u73af\u5883[%s]\u7684\u5bc6\u7801\u5668\u914d\u7f6e[zmr.passworder]\u4e0d\u662fZmrPassworder\u6216\u5b50\u7c7b", (Object[])new Object[]{this.context.getContextName()});
        this.passworder = (ZmrPassworder)instance;
    }

    private void initOrg() throws Exception {
        if (this.tableOpr().count(ZmrOrg.class) > 0) {
            return;
        }
        ZmrOrg org = new ZmrOrg();
        org.setOrgId(1000000000000L);
        org.setOrgName("\u6e56\u5357\u79d2\u7ed8\u79d1\u6280\u6709\u9650\u516c\u53f8");
        org.setOrgStatus(0);
        org.setOrgLevel(0);
        this.tableOpr().insert((Object)org);
    }

    private void initOperator() throws Exception {
        int count = this.tableOpr().count(ZmrOperator.class);
        if (count > 0) {
            return;
        }
        String datetime = DateTimes.getDateTimeString();
        String passSalt = Randoms.lettersDigitsSecure((int)64);
        ZmrOperator operator = new ZmrOperator();
        operator.setOrgId(1000000000000L);
        operator.setOperatorCode("miaohui");
        operator.setOperatorPass(this.passworder.encode("miaohui", "miaohui@2020", passSalt));
        operator.setOperatorPassSalt(passSalt);
        operator.setOperatorStatus(0);
        operator.setOperatorType(0);
        operator.setOperatorName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        operator.setOperatorCreated(datetime);
        operator.setOperatorModified(datetime);
        this.table().replace((Object)operator);
    }

    private void initMenu() throws Exception {
        if (this.table().count(ZmrMenu.class) > 0) {
            return;
        }
        String path = this.context.getAttributeString("zmr_menu_sql");
        if (Validates.isEmpty((String)path)) {
            return;
        }
        String sqls = this.context.getResourceString(path);
        if (sqls == null) {
            return;
        }
        List sqlList = Sqls.toSqlList((String)sqls);
        if (sqlList.isEmpty()) {
            return;
        }
        this.zmrServer.sql().execute(sqlList);
    }

    private void initParam() throws Exception {
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "themeIndex", "00_default", 1, ItemType.PROTECTED, "\u9996\u9875\u4e3b\u9898\uff08\u5728\u9996\u9875\u4e3b\u9898\u4e2d\u4fee\u6539\uff09");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "themeMain", "00_default", 2, ItemType.PROTECTED, "\u4e3b\u9875\u4e3b\u9898\uff08\u5728\u4e3b\u9875\u4e3b\u9898\u4e2d\u4fee\u6539\uff09");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "themeFrame", "false", 3, ItemType.PUBLIC, "\u4e3b\u9898\u662f\u5426\u4f7f\u7528iframe\u98ce\u683c");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "hasManageLogin", "false", 4, ItemType.PUBLIC, "\u662f\u5426\u4f7f\u7528\u7ba1\u7406\u9875\u767b\u5f55\u9000\u51fa\u529f\u80fd");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "hasVerificationCode", "false", 5, ItemType.PUBLIC, "\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "hasRememberCode", "true", 6, ItemType.PUBLIC, "\u662f\u5426\u663e\u793a\u8bb0\u4f4f\u7528\u6237\u540d");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "hasRememberPass", "false", 7, ItemType.PUBLIC, "\u662f\u5426\u663e\u793a\u8bb0\u4f4f\u5bc6\u7801");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "mainUrl", "/${zhiqim_manager}/main.htm", 8, ItemType.PUBLIC, "\u767b\u5f55\u4e4b\u540e\u7684\u4e3b\u9875\u5730\u5740");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "remainLogDay", "7", 9, ItemType.PUBLIC, "\u4fdd\u7559\u64cd\u4f5c\u5458\u65e5\u5fd7\u5929\u6570");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "operatorDeptAllRule", "true", 10, ItemType.PUBLIC, "\u64cd\u4f5c\u5458\u6743\u9650\u662f\u5426\u7ee7\u627f\u4e0a\u7ea7\u90e8\u95e8\u6743\u9650");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "cdnPath", "", 11, ItemType.PUBLIC, "\u5982\u679cCDN\u8def\u5f84\u4e0d\u4e3a\u7a7a\uff0cJS\u6587\u4ef6\u4f18\u5148\u53d6CDN\u8def\u5f84");
        SS keys = RSA.buildKeyPair();
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "publicKey", keys.key(), 12, ItemType.PRIVATE, "\u968f\u673a\u751f\u6210\u7684\u516c\u94a5");
        ZmrParamDao.addParam((HttpContext)this.context, "zhiqim.manager", "privateKey", keys.value(), 13, ItemType.PRIVATE, "\u968f\u673a\u751f\u6210\u7684\u79c1\u94a5");
    }

    private void initAvatar() throws Exception {
        if (this.table().count(ZmrAvatar.class) > 0) {
            return;
        }
        long avatarId = 1000000000001L;
        List avatarNameList = Resources.getResourceNameList(ZmrBootstrap.class, (String)"/org/zhiqim/manager/avatar/");
        for (String avatarName : avatarNameList) {
            byte[] data = Streams.getBytesClassPath(ZmrBootstrap.class, (String)("/org/zhiqim/manager/avatar/" + avatarName));
            byte[] bytes50 = Images.resizePNG((byte[])data, (int)50, (int)50);
            byte[] bytes100 = Images.resizePNG((byte[])data, (int)100, (int)100);
            byte[] bytes150 = Images.resizePNG((byte[])data, (int)150, (int)150);
            ZmrAvatar avatar = new ZmrAvatar();
            avatar.setAvatarId(avatarId++);
            avatar.setAvatarType(0);
            avatar.setAvatarTime(System.currentTimeMillis());
            avatar.setAvatar50(bytes50);
            avatar.setAvatar100(bytes100);
            avatar.setAvatar150(bytes150);
            this.table().insert((Object)avatar);
        }
    }

    private void initOrgRule() throws Exception {
        List list = this.table().list(ZmrOrgRule.class, new Selector("orgId", (Object)1000000000000L));
        if (list.size() > 0) {
            return;
        }
        List menuList = this.table().list(ZmrMenu.class);
        if (Validates.isEmpty((Collection)menuList)) {
            return;
        }
        int i = 0;
        while (i < menuList.size()) {
            ZmrOrgRule rule = new ZmrOrgRule();
            rule.setOrgId(1000000000000L);
            rule.setMenuCode(((ZmrMenu)menuList.get(i)).getMenuCode());
            list.add(rule);
            ++i;
        }
        this.table().insertBatch(list);
    }

    private void initDept() throws Exception {
        if (this.table().count(ZmrDept.class) > 0) {
            return;
        }
        ZmrDept dept = new ZmrDept();
        dept.setOrgId(1000000000000L);
        dept.setParentId(0L);
        dept.setDeptId(1000000000000L);
        dept.setDeptName("\u6e56\u5357\u79d2\u7ed8\u79d1\u6280\u6709\u9650\u516c\u53f8");
        dept.setDeptStatus(0);
        dept.setDeptLevel(0);
        dept.setDeptParentAll("0");
        this.table().insert((Object)dept);
    }
}

