/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.zhiqim.httpd.HttpInputStream;
import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.httpd.nio.HttpNioHeader;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Zips;

public class HttpNioRequest
extends HttpRequestAbs {
    private byte[] contentBytes;
    private int offset;

    public HttpNioRequest(HttpNioHeader header) {
        super(header);
    }

    @Override
    public boolean parseContent() throws IOException {
        byte[] buf;
        int cLen = this.getContentLength();
        if (cLen <= 0) {
            this.bis = new ByteArrayInputStream(new byte[0]);
            return true;
        }
        if (this.contentBytes == null) {
            this.contentBytes = new byte[cLen];
            this.offset = 0;
        }
        if ((buf = ((HttpInputStream)this.input).read(cLen - this.offset)) != null && buf.length > 0) {
            this.offset = Bytes.putBytes((byte[])this.contentBytes, (int)this.offset, (byte[])buf);
        }
        if (this.offset != cLen) {
            return false;
        }
        this.bis = new ByteArrayInputStream(this.contentBytes, 0, cLen);
        if (this.isRequestGZip()) {
            this.bis = Zips.unGZip((InputStream)this.bis);
        }
        if ("POST".equals(this.header.getMethod()) && "application/x-www-form-urlencoded".equals(this.header.getMimeType())) {
            String line = new String(this.contentBytes, this.header.getCharacterEncoding());
            Urls.toMap((String)line, (Map)this.cntParamMap.instance(), (String)this.header.getCharacterEncoding());
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.contentBytes != null) {
            this.contentBytes = null;
        }
    }
}

