/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.service;

import java.io.IOException;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.service.RmiService;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class AjaxService
implements HttpExecutor,
ZmlContextConstants {
    @Override
    public boolean isMatch(String pathInContext) {
        return "/service/ajax".equals(pathInContext);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        if (!(request.isXMLHttpRequest() && "POST".equals(request.getMethod()) && ("text/plain".equals(request.getMimeType()) || "application/x-www-form-urlencoded".equals(request.getMimeType())) && "UTF-8".equalsIgnoreCase(request.getCharacterEncodingHeader()))) {
            response.sendError(403);
            return;
        }
        String path = request.getParameterOnURL("path");
        String serviceId = Strings.trim((String)request.getHeader("X-RMI-Service"), (String)"");
        String clazz = Strings.trim((String)request.getHeader("X-RMI-Class"), (String)"");
        String method = request.getHeader("X-RMI-Method");
        if (Validates.isEmptyBlank((String)path) || Validates.isEmptyBlank((String)clazz) && Validates.isEmptyBlank((String)serviceId) || Validates.isEmptyBlank((String)method)) {
            response.sendError(412);
            return;
        }
        RmiService service = ((Context)request.getContext()).getServiceExecutor().getRmiService();
        String classNameId = Validates.isEmpty((String)clazz) ? serviceId : clazz;
        String interceptors = request.getContextAttributeString("ajax.interceptor");
        if (!service.chkInterceptor(request, response, interceptors, classNameId, method)) {
            return;
        }
        service.service(request, response);
    }
}

