/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpContextLoader;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpHandler;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResource;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.httpd.HttpWebsocketManager;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.entities.CrossdomainEntity;
import org.zhiqim.httpd.entities.FaviconEnitiy;
import org.zhiqim.httpd.entities.NotFoundEntity;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashSetS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class StaticContext
implements HttpContext,
HttpdConstants {
    protected static final NotFoundEntity _notFound = new NotFoundEntity();
    protected String id;
    protected boolean isRunning;
    protected HttpServer server;
    protected ClassLoader contextLoader;
    protected HashSetS contextDomains = new HashSetS();
    protected String contextPath;
    protected String encoding = "UTF-8";
    protected HttpResource resource;
    protected List<HttpResource> cResourceList = new ArrayList<HttpResource>();
    protected boolean cookieUse = true;
    protected String cookieDomain;
    protected int cookiePort;
    protected String cookiePath;
    protected String welcomeUrl;
    protected String notFoundUrl;
    protected int maxContentLength;
    protected int chunkSize;
    protected int expires;
    protected HashMapSO attributes = new HashMapSO();
    protected List<HttpHandler> handlers = new ArrayList<HttpHandler>();
    protected List<String> filters = new ArrayList<String>(2);
    protected HttpHandler defaultHandler;

    public StaticContext() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        this.contextLoader = new HttpContextLoader(parent);
    }

    @Override
    public boolean create(Group group) throws Exception {
        this.id = group.getId();
        this.contextPath = group.getString("path");
        Asserts.as(Validates.isNotEmpty((String)this.contextPath) ? null : "HttpContext[" + this.id + "]\u7684\u672a\u627e\u5230[path]\u914d\u7f6e\u9879");
        String contextDomain = group.getString("domain", null);
        if (Validates.isNotEmptyBlank((String)contextDomain)) {
            String[] domains = Arrays.toStringArray((String)contextDomain);
            String[] stringArray = domains;
            int n = domains.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                this.contextDomains.add((Object)d);
                ++n2;
            }
        }
        this.server.chkContextDomainPath(this.contextDomains, this.contextPath);
        String resourceType = group.getString("resourceType", null);
        String resourcePath = group.getString("resourcePath", null);
        this.resource = new HttpResource(resourceType, resourcePath);
        this.addHandler(new FaviconEnitiy(this));
        this.addHandler(new CrossdomainEntity(this));
        this.setWelcomeUrl(group.getString("welcomeUrl", null));
        this.setNotFoundUrl(group.getString("notFoundUrl", null));
        this.maxContentLength = group.getInt("maxContentLength", 0x800000);
        this.chunkSize = group.getInt("chunkSize", 0x100000);
        this.expires = group.getInt("expires", 3600);
        String filterPattern = group.getString("filter");
        if (Validates.isNotEmpty((String)filterPattern)) {
            String[] filters;
            String[] stringArray = filters = Arrays.toStringArray((String)filterPattern);
            int n = filters.length;
            int n3 = 0;
            while (n3 < n) {
                String filter = stringArray[n3];
                this.addFilter(filter);
                ++n3;
            }
        }
        for (Item item : group.list()) {
            this.setAttribute(item.getKey(), item.getString());
        }
        this.isRunning = true;
        return true;
    }

    @Override
    public void destroy() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.attributes.clear();
        this.handlers.clear();
        this.filters.clear();
        this.server.removeContext(this);
    }

    public String getConfiguration() {
        return this.getAttributeString("orm");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setServer(HttpServer server) {
        this.server = server;
    }

    public void setEncoding(String encoding) {
        this.encoding = Strings.trimEmpty((String)encoding, (String)"UTF-8");
    }

    @Override
    public String getResourcePath() {
        return this.resource.getResourcePath();
    }

    @Override
    public HttpServer getServer() {
        return this.server;
    }

    @Override
    public HashSetS getContextDomains() {
        return this.contextDomains;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getRootPath(String path) {
        if (!Strings.startsWith((String)(path = Strings.trim((String)path)), (String)"/")) {
            return path;
        }
        return String.valueOf(Strings.trimRight((String)this.contextPath, (String)"/")) + path;
    }

    @Override
    public String getRealPath(String path) {
        Asserts.as((String)(this.resource.getResourcePath() != null ? null : "\u7cfb\u7edf\u672a\u914d\u7f6e\u8d44\u6e90\u6839\u76ee\u5f55\uff0c\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\u67e5\u627e\u5730\u5740"));
        path = Files.toLinuxPath((String)Strings.trim((String)path));
        if (Validates.isEmpty((String)path) || "/".equals(path)) {
            return this.resource.getResourcePath();
        }
        return String.valueOf(this.resource.getResourcePath()) + "/" + Strings.removeStartsWith((String)path, (String)"/");
    }

    @Override
    public boolean isClasspath() {
        return this.resource.isClasspath();
    }

    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.contextLoader.loadClass(className);
    }

    public boolean addComponentResource(int resourceIndex, String resourceType, String resourcePath) {
        HttpResource cResource = new HttpResource(resourceIndex, resourceType, resourcePath);
        if (this.cResourceList.contains(cResource)) {
            return false;
        }
        this.cResourceList.add(cResource);
        Collections.sort(this.cResourceList, HttpResource._resourceCompor);
        return true;
    }

    @Override
    public String getResourceString(String path) throws IOException {
        return this.getResourceString(path, "UTF-8");
    }

    @Override
    public String getResourceString(String path, String encoding) throws IOException {
        String value = null;
        if (this.resource != null && (value = this.resource.getResourceString(path, encoding)) != null) {
            return value;
        }
        for (HttpResource cResource : this.cResourceList) {
            value = cResource.getResourceString(path, encoding);
            if (value == null) continue;
            return value;
        }
        return value;
    }

    @Override
    public List<String> getResourceNameList(String folderPath) throws IOException {
        ArrayList<String> nameList = new ArrayList<String>();
        if (this.resource != null) {
            nameList.addAll(this.resource.getResourceNameList(folderPath));
        }
        for (HttpResource cResource : this.cResourceList) {
            nameList.addAll(cResource.getResourceNameList(folderPath));
        }
        return nameList;
    }

    public boolean addFilter(String match) {
        if ("/".equals(match) || !this.isValidMatch(match)) {
            return false;
        }
        this.filters.add(match);
        return true;
    }

    public void setDefaultHandler(HttpHandler handler) {
        this.defaultHandler = handler;
    }

    public boolean addHandler(HttpHandler handler) {
        this.handlers.add(handler);
        return true;
    }

    @Override
    public HttpHandler getMatchHandler(String pathInContext) {
        for (HttpHandler handler : this.handlers) {
            if (!handler.isMatch(pathInContext)) continue;
            return handler;
        }
        return this.defaultHandler;
    }

    @Override
    public boolean isFilterPath(String pathInContext) {
        for (String filter : this.filters) {
            if (filter.equals(pathInContext)) {
                return true;
            }
            if (filter.endsWith("/*") && pathInContext.startsWith(filter = filter.substring(0, filter.length() - 1))) {
                return true;
            }
            if (filter.startsWith("*.") && pathInContext.endsWith(filter = filter.substring(1))) {
                return true;
            }
            int ind = filter.indexOf("/*.");
            if (ind == -1) continue;
            String pathPrefix = filter.substring(0, ind + 1);
            String pathSuffix = filter.substring(ind + 2);
            if (!pathInContext.startsWith(pathPrefix) || !pathInContext.endsWith(pathSuffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidMatch(String match) {
        if (match == null) {
            return false;
        }
        if ("/".equals(match)) {
            return true;
        }
        int times = Strings.getTimes((String)match, (char)'*');
        if (times == 0 && match.startsWith("/")) {
            return true;
        }
        if (times == 1 && match.startsWith("/") && match.endsWith("/*")) {
            return true;
        }
        return times == 1 && (match.indexOf("/*.") != -1 || match.startsWith("*.")) && !match.endsWith(".");
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String pathInContext = request.getPathInContext();
        if (this.isFilterPath(pathInContext)) {
            response.sendError(403);
            return;
        }
        HttpHandler handler = this.getMatchHandler(pathInContext);
        if (handler instanceof HttpExecutor) {
            ((HttpExecutor)handler).handle(request, response);
            return;
        }
        if (handler instanceof HttpEntity) {
            ((HttpEntity)handler).handle(request, response);
            return;
        }
        this.handleResource(request, response);
    }

    @Override
    public void handleResource(HttpHeader header, HttpSender sender) throws HttpException, IOException {
        if (this.resource != null && this.resource.handleResource(header, sender)) {
            return;
        }
        for (HttpResource cResource : this.cResourceList) {
            if (!cResource.handleResource(header, sender)) continue;
            return;
        }
        _notFound.handle(header, sender);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public <T> void setAttribute(Class<T> key, T value) {
        this.attributes.put(key.getName(), value);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public HashMapSO getAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public <T> T getAttribute(Class<T> key) {
        return (T)this.attributes.get(key.getName());
    }

    @Override
    public Object getAttribute(String key, Object defaultValue) {
        Object value = this.getAttribute(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public String getContextName() {
        String name = this.getAttributeString("name");
        return name == null ? Global.getName() : name;
    }

    @Override
    public String getContextVersion() {
        String version = this.getAttributeString("version");
        return version == null ? Global.getVersion() : version;
    }

    @Override
    public String getAttributeString(String key) {
        return this.getAttributeString(key, null);
    }

    @Override
    public String getAttributeString(String key, String defaultValue) {
        Object value = this.getAttribute(key);
        return value == null ? defaultValue : Strings.trim((String)String.valueOf(value));
    }

    @Override
    public int getAttributeInt(String key) {
        return this.getAttributeInt(key, -1);
    }

    @Override
    public int getAttributeInt(String key, int defaultValue) {
        return Ints.toInt((Object)this.getAttribute(key), (int)defaultValue);
    }

    @Override
    public long getAttributeLong(String key) {
        return this.getAttributeLong(key, -1L);
    }

    @Override
    public long getAttributeLong(String key, long defaultValue) {
        return Longs.toLong((Object)this.getAttribute(key), (long)defaultValue);
    }

    @Override
    public boolean getAttributeBoolean(String key, boolean defaultValue) {
        Object value = this.getAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    @Override
    public String getWelcomeUrl() {
        return this.welcomeUrl;
    }

    @Override
    public String getNotFoundUrl() {
        return this.notFoundUrl;
    }

    @Override
    public HttpEntity getNotFoundHandler() {
        return _notFound;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public int getExpires() {
        return this.expires;
    }

    public void setWelcomeUrl(String welcomeUrl) {
        this.welcomeUrl = Validates.isEmptyBlank((String)welcomeUrl) ? null : Strings.addStartsWith((String)welcomeUrl, (String)"/");
    }

    public void setNotFoundUrl(String notFoundUrl) {
        this.notFoundUrl = Validates.isEmptyBlank((String)notFoundUrl) ? null : Strings.addStartsWith((String)notFoundUrl, (String)"/");
    }

    @Override
    public String getDefaultEncoding() {
        return this.encoding;
    }

    @Override
    public boolean isCookieUse() {
        return this.cookieUse;
    }

    @Override
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    @Override
    public int getCookiePort() {
        return this.cookiePort;
    }

    @Override
    public String getCookiePath() {
        return this.contextPath;
    }

    public void setCookieUse(boolean cookieUse) {
        this.cookieUse = cookieUse;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookiePort(int cookiePort) {
        this.cookiePort = cookiePort;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    @Override
    public HttpSessionManager getSessionManager() {
        return null;
    }

    @Override
    public void invalidateSession(String sessionId) {
    }

    @Override
    public HttpWebsocketManager getWebsocketManager() {
        return null;
    }
}

