/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.zhiqim.httpd.HttpCertificate;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.HttpSslConfig;
import org.zhiqim.httpd.bio.HttpBioConnection;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.Sockets;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.SSL;

public class HttpBioSslListener
extends HttpListener {
    private static final String SSL_SESSION_CACHE = HttpCertificate.class.getName();
    private static final String SSL_NULL_WITH_NULL_NULL = "SSL_NULL_WITH_NULL_NULL";
    private final HttpSslConfig ssl = new HttpSslConfig();
    private SSLServerSocket serverSocket;

    public HttpBioSslListener(HttpServer server) {
        super(server);
    }

    @Override
    public String getScheme() {
        return "https";
    }

    @Override
    protected boolean openBefore() {
        try {
            this.ssl.initParam(this.listenerGroup);
            super.openBefore();
            SSLServerSocketFactory factory = this.ssl.createFactory();
            this.serverSocket = Validates.isEmpty((String)this.listenerIp) ? (SSLServerSocket)factory.createServerSocket(this.listenerPort) : (SSLServerSocket)factory.createServerSocket(this.listenerPort, 50, InetAddress.getByName(this.listenerIp));
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.setNeedClientAuth(this.ssl.isClientAuth());
            this.serverSocket.setWantClientAuth(this.ssl.isClientAuth());
            return true;
        }
        catch (Exception e) {
            throw Asserts.exception((Exception)e);
        }
    }

    @Override
    protected void closeAfter() {
        if (this.serverSocket != null) {
            Threads.closeIgnoreException((AutoCloseable)this.serverSocket);
            this.serverSocket = null;
        }
        super.closeAfter();
        log.info((Object)(String.valueOf(this.toString()) + "\u9000\u51fa"));
    }

    protected void loop() {
        try {
            Socket socket = this.serverSocket.accept();
            Sockets.setOption((Socket)socket, (boolean)true, (int)this.soTimeoutMs, (int)this.soLingerS, (boolean)false);
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            if (cipherSuite == null || SSL_NULL_WITH_NULL_NULL.equals(cipherSuite)) {
                socket.close();
                return;
            }
            String sslSessionId = null;
            X509Certificate[] x509Certs = null;
            HttpCertificate sslSessionCache = (HttpCertificate)sslSession.getValue(SSL_SESSION_CACHE);
            if (sslSessionCache != null) {
                x509Certs = sslSessionCache.getCerts();
                sslSessionId = sslSessionCache.getSessionId();
            } else {
                x509Certs = SSL.getCertChain((SSLSession)sslSession);
                byte[] bytes = sslSession.getId();
                sslSessionId = Hexs.toHexString((byte[])bytes);
                sslSessionCache = new HttpCertificate(sslSessionId, x509Certs);
                sslSession.putValue(SSL_SESSION_CACHE, sslSessionCache);
            }
            if (x509Certs == null && this.ssl.isClientAuth()) {
                socket.close();
                return;
            }
            this.controller.execute((Runnable)this.add(this.newConnection(socket, x509Certs)));
        }
        catch (SocketException e) {
            if (!"Socket closed".equalsIgnoreCase(e.getMessage())) {
                log.error((Object)(String.valueOf(this.toString()) + "SocketException\u5f02\u5e38"), (Throwable)e, new Object[0]);
            }
        }
        catch (IOException e) {
            log.error((Object)(String.valueOf(this.toString()) + "IO\u5f02\u5e38"), (Throwable)e, new Object[0]);
        }
    }

    private HttpBioConnection newConnection(Socket socket, X509Certificate[] x509Certs) throws IOException {
        return new HttpBioConnection(this, socket, socket.getInputStream(), socket.getOutputStream(), x509Certs);
    }
}

