/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpCookie;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpHeaderAbs;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpRequestResponse;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.util.Amounts;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;

public abstract class HttpRequestAbs
extends HttpRequestResponse {
    protected HttpHeaderAbs header;
    protected HttpConnection conn;
    protected HttpServer server;
    protected HttpContext context;
    protected InputStream input;
    protected HashMapSS urlParamMap;
    protected HashMapSS cntParamMap;
    protected HashMapSS cookieMap;
    protected HashMapSO attributeMap;
    protected ByteArrayInputStream bis;
    protected HttpSession session;
    protected String requestName;
    protected transient boolean hasForward;

    public HttpRequestAbs(HttpHeaderAbs header) {
        this.header = header;
        this.conn = header.getConnection();
        this.server = header.getServer();
        this.context = header.getContext();
        this.input = header.getInputStream();
        this.urlParamMap = new HashMapSS();
        this.cntParamMap = new HashMapSS();
        this.cookieMap = new HashMapSS();
        this.attributeMap = new HashMapSO();
    }

    public abstract boolean parseContent() throws IOException;

    public void parseHeaderByContextOK() throws HttpException {
        int cLen;
        int maxContentLength = this.context.getMaxContentLength();
        if (maxContentLength > 0 && (cLen = this.getContentLength()) > maxContentLength) {
            throw new HttpException(413);
        }
        String sslCert = this.getHeader("SSL_CERT");
        if (Validates.isNotEmpty((String)sslCert)) {
            this.parseHeaderCert(sslCert);
        }
        this.setAttribute("zhiqimClientType", this.getZhiqimClientType());
        String queryString = this.header.getUri().getQuery();
        Urls.toMap((String)queryString, (Map)this.urlParamMap.instance(), (String)this.header.getCharacterEncoding());
        String cookieString = this.getHeader("Cookie");
        if (cookieString != null) {
            String[] cookieArray;
            String[] stringArray = cookieArray = cookieString.split(";");
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                String cookieInfo = stringArray[n2];
                String[] cookieNameValue = cookieInfo.split("=");
                if (cookieNameValue.length >= 2 && !this.cookieMap.containsKey(name = cookieNameValue[0].trim())) {
                    String value = cookieNameValue[1].trim();
                    this.cookieMap.put(name, Urls.decodeUTF8((String)value));
                }
                ++n2;
            }
        }
    }

    public void parseGetPostCookieSession() throws IOException {
        HttpSessionManager sessionManager = this.context.getSessionManager();
        if (sessionManager == null) {
            return;
        }
        String sessionId = null;
        sessionId = !this.context.isCookieUse() ? this.urlParamMap.get(sessionManager.getSessionIdName()) : this.cookieMap.get(sessionManager.getSessionIdName());
        if (Validates.isEmptyBlank((String)sessionId) || !sessionManager.hasSession(sessionId)) {
            this.session = sessionManager.newSession(Ids.uuid());
            this.session.setSessionIp(this.getRemoteAddr());
            this.session.setUserAgent(this.getUserAgent());
            sessionManager.setSession(this.session);
        } else {
            this.session = sessionManager.getSession(sessionId);
            this.session.updateInfo(this.getRemoteAddr(), this.getUserAgent());
        }
    }

    private void parseHeaderCert(String sslCert) {
        try {
            sslCert = sslCert.replaceAll("\t", "\n");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(sslCert.getBytes());
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
            this.header.setCertificates(new X509Certificate[]{cert});
        }
        catch (CertificateException certificateException) {}
    }

    @Override
    public Log getLog() {
        return this.header.getLog();
    }

    @Override
    public HttpSender getSender() {
        return this.header.getSender();
    }

    @Override
    public String getId() {
        return this.header.getId();
    }

    @Override
    public long getTimeMillis() {
        return this.header.getReceiveTimeMillis();
    }

    public HttpListener getListener() {
        return this.header.getListener();
    }

    @Override
    public int getListenerPort() {
        return this.header.getListener().getPort();
    }

    @Override
    public HttpServer getServer() {
        return this.server;
    }

    public HttpConnection getConnection() {
        return this.header.getConnection();
    }

    @Override
    public boolean isWebSocket() {
        return this.header.isWebSocket();
    }

    @Override
    public HttpResponse getResponse() {
        return this.header.getResponse();
    }

    public String getConfiguration() {
        return this.context.getConfiguration();
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public String getContextPath() {
        return this.context.getContextPath();
    }

    @Override
    public String getContextName() {
        return this.context.getContextName();
    }

    @Override
    public String getContextVersion() {
        return this.context.getContextVersion();
    }

    @Override
    public void setContextAttribute(String key, Object value) {
        this.context.setAttribute(key, value);
    }

    @Override
    public <T> void setContextAttribute(Class<T> key, T value) {
        this.context.setAttribute(key, value);
    }

    @Override
    public Object getContextAttribute(String key) {
        return this.context.getAttribute(key);
    }

    @Override
    public <T> T getContextAttribute(Class<T> key) {
        return this.context.getAttribute(key);
    }

    @Override
    public Object getContextAttribute(String key, Object defaultValue) {
        return this.context.getAttribute(key, defaultValue);
    }

    @Override
    public String getContextAttributeString(String key) {
        return this.context.getAttributeString(key);
    }

    @Override
    public String getContextAttributeString(String key, String defaultValue) {
        return this.context.getAttributeString(key, defaultValue);
    }

    @Override
    public int getContextAttributeInt(String key) {
        return this.context.getAttributeInt(key);
    }

    @Override
    public int getContextAttributeInt(String key, int defaultValue) {
        return this.context.getAttributeInt(key, defaultValue);
    }

    @Override
    public long getContextAttributeLong(String key) {
        return this.context.getAttributeLong(key);
    }

    @Override
    public long getContextAttributeLong(String key, long defaultValue) {
        return this.context.getAttributeLong(key, defaultValue);
    }

    @Override
    public boolean getContextAttributeBoolean(String key, boolean defaultValue) {
        return this.context.getAttributeBoolean(key, defaultValue);
    }

    @Override
    public boolean hasContextAttribute(String key) {
        return this.context.hasAttribute(key);
    }

    @Override
    public String getResourcePath() {
        return this.context.getResourcePath();
    }

    @Override
    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    @Override
    public String getRootPath(String path) {
        return this.context.getRootPath(path);
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.header.getCertificates();
    }

    @Override
    public boolean isRead() {
        return this.header.isRead();
    }

    @Override
    public boolean isEditable() {
        return this.header.isEditable();
    }

    @Override
    public boolean isCommitted() {
        return this.header.isCommitted();
    }

    @Override
    public void setStepInterceptor() {
        this.header.setStep(8);
    }

    @Override
    public void setStepAction() {
        this.header.setStep(9);
    }

    @Override
    public int getStep() {
        return this.header.getStep();
    }

    @Override
    public String getStepDesc() {
        return this.header.getStepDesc();
    }

    @Override
    public String getRequestName() {
        return this.requestName;
    }

    @Override
    public void setRequestName(String name) {
        this.requestName = name;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public void invalidateSession() {
        if (this.session != null) {
            this.context.invalidateSession(this.session.getId());
        }
        this.session = null;
    }

    @Override
    public boolean hasSessionUser() {
        return this.session != null && this.session.hasSessionUser();
    }

    @Override
    public void bindSessionUser(HttpSessionUser sessionUser) {
        if (this.session != null) {
            this.session.bindSessionUser(sessionUser);
        }
    }

    @Override
    public void unbindSessionUser() {
        if (this.session != null) {
            this.session.unbindSessionUser();
        }
    }

    @Override
    public HttpSessionUser getSessionUser() {
        return this.session == null ? null : this.session.getSessionUser();
    }

    @Override
    public String getSessionName() {
        return this.session == null ? null : this.session.getSessionName();
    }

    @Override
    public <T extends HttpSessionUser> boolean hasSessionUser(Class<T> clazz) {
        return this.session == null ? null : Boolean.valueOf(this.session.hasSessionUser(clazz));
    }

    @Override
    public <T extends HttpSessionUser> T getSessionUser(Class<T> clazz) {
        return this.session == null ? null : (T)this.session.getSessionUser(clazz);
    }

    @Override
    public String getSessionId() {
        this.assertSession();
        return this.session.getId();
    }

    @Override
    public void setSessionAttribute(String name, Object value) {
        this.assertSession();
        this.session.setAttribute(name, value);
    }

    @Override
    public Object getSessionAttribute(String name) {
        this.assertSession();
        return this.session.getAttribute(name);
    }

    @Override
    public Object getSessionAttribute(String name, Object defaultValue) {
        this.assertSession();
        return this.session.getAttribute(name, defaultValue);
    }

    @Override
    public String getSessionAttributeString(String name) {
        this.assertSession();
        return this.session.getAttributeString(name);
    }

    @Override
    public String getSessionAttributeString(String name, String defaultValue) {
        this.assertSession();
        return this.session.getAttributeString(name, defaultValue);
    }

    @Override
    public int getSessionAttributeInt(String name) {
        this.assertSession();
        return this.session.getAttributeInt(name);
    }

    @Override
    public int getSessionAttributeInt(String name, int defaultValue) {
        this.assertSession();
        return this.session.getAttributeInt(name, defaultValue);
    }

    @Override
    public long getSessionAttributeLong(String name) {
        this.assertSession();
        return this.session.getAttributeLong(name);
    }

    @Override
    public long getSessionAttributeLong(String name, long defaultValue) {
        this.assertSession();
        return this.session.getAttributeLong(name, defaultValue);
    }

    @Override
    public boolean hasSessionAttribute(String name) {
        this.assertSession();
        return this.session.hasAttribute(name);
    }

    private void assertSession() {
        Asserts.as((String)(this.session != null ? null : "[HttpSession]\u672a\u521b\u5efa\u6216\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u8c03\u7528"));
    }

    @Override
    public String getCookie(String name) {
        return this.cookieMap.get(name);
    }

    @Override
    public String getCookie(String name, String defaultValue) {
        String value = this.cookieMap.get(name);
        return Validates.isEmpty((String)value) ? defaultValue : value;
    }

    @Override
    public HttpCookie[] getCookies() {
        HttpCookie[] cookieArr = new HttpCookie[this.cookieMap.size()];
        int i = 0;
        for (Map.Entry entry : this.cookieMap.entrySet()) {
            HttpCookie cookie = new HttpCookie((String)entry.getKey(), (String)entry.getValue());
            cookieArr[i++] = cookie;
        }
        return cookieArr;
    }

    @Override
    public void removeCookie(String name) {
        this.cookieMap.remove(name);
    }

    @Override
    public void addCookieToResponse(String name, String value) {
        this.getResponse().addCookie(name, value);
    }

    @Override
    public void addCookieToResponse(String name, String value, int seconds) {
        this.getResponse().addCookie(name, value, seconds);
    }

    @Override
    public void addCookieToResponse(HttpCookie cookie) {
        this.getResponse().addCookie(cookie);
    }

    @Override
    public void removeCookieToResponse(String name) {
        this.getResponse().removeCookie(name);
    }

    @Override
    public String getHeaderLine() {
        return this.header.getHeaderLine();
    }

    @Override
    public String getVersion() {
        return this.header.getVersion();
    }

    @Override
    public String getPath() {
        return this.header.getPath();
    }

    @Override
    public String getMethod() {
        return this.header.getMethod();
    }

    @Override
    public boolean isMethodHead() {
        return this.header.isMethodHead();
    }

    @Override
    public boolean isMethodGet() {
        return this.header.isMethodGet();
    }

    @Override
    public boolean isMethodPost() {
        return this.header.isMethodPost();
    }

    @Override
    public boolean isMethodResponseContent() {
        return this.header.isMethodResponseContent();
    }

    @Override
    public String getRemoteAddr() {
        return this.header.getRemoteAddr();
    }

    @Override
    public String getRequestURI() {
        return this.header.getUri().toString();
    }

    @Override
    public String getRequestURL() {
        String scheme = this.getScheme();
        String hostPort = this.getHostPort();
        return scheme + "://" + hostPort + this.getRequestURI();
    }

    @Override
    public String getQueryString() {
        return this.header.getQueryString();
    }

    @Override
    public String getScheme() {
        String proxy = this.getHeader("X-Forwarded-Proto");
        return Validates.isEmpty((String)proxy) ? this.server.getScheme() : proxy;
    }

    @Override
    public String getHostPort() {
        return this.header.getHostPort();
    }

    @Override
    public int getPort() {
        String scheme = this.getScheme();
        int defaultPort = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        String hostPort = this.getHostPort();
        if (Validates.isEmpty((String)hostPort) || hostPort.indexOf(":") == -1) {
            return defaultPort;
        }
        int ind = hostPort.indexOf(":");
        return Ints.toInt((String)Strings.trim((String)hostPort.substring(ind + 1)), (int)defaultPort);
    }

    @Override
    public String getHostOnly() {
        return this.header.getHostOnly();
    }

    @Override
    public String getVirtualDirectory() {
        return this.header.getVirtualDirectory();
    }

    @Override
    public HashMapSS getHeaders() {
        return this.header.getHeaders();
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return this.header.getHeaders().keySet().iterator();
    }

    @Override
    public String getHeaderString() {
        StringBuilder strb = new StringBuilder();
        for (Map.Entry entry : this.header.getHeaders().entrySet()) {
            strb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append("\r\n");
        }
        return strb.toString();
    }

    @Override
    public String getHeader(String key) {
        return this.header.getHeader(key.toLowerCase());
    }

    @Override
    public String getHeader(String key, String defaultValue) {
        String value = this.getHeader(key);
        return Validates.isEmptyBlank((String)value) ? defaultValue : value;
    }

    @Override
    public int getHeaderInt(String key) {
        return this.getHeaderInt(key, -1);
    }

    @Override
    public int getHeaderInt(String key, int defaultValue) {
        String value = this.getHeader(key);
        return Validates.isInteger((String)value) ? Ints.toInt((String)value) : defaultValue;
    }

    @Override
    public long getHeaderLong(String key) {
        return this.getHeaderLong(key, -1L);
    }

    @Override
    public long getHeaderLong(String key, long defaultValue) {
        String value = this.getHeader(key);
        return Validates.isInteger((String)value) ? Longs.toLong((String)value) : defaultValue;
    }

    @Override
    public int getContentLength() {
        String sLen = this.getHeader("Content-Length");
        if (!Validates.isInteger((String)sLen)) {
            return 0;
        }
        return Integer.parseInt(sLen);
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getMimeType() {
        return this.header.getMimeType();
    }

    @Override
    public boolean isMimeForm() {
        return this.header.isMimeForm();
    }

    @Override
    public boolean isMimeTextPlain() {
        return this.header.isMimeTextPlain();
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.header.setCharacterEncoding(characterEncoding);
    }

    @Override
    public String getCharacterEncoding() {
        return this.header.getCharacterEncoding();
    }

    @Override
    public String getCharacterEncodingHeader() {
        return this.header.getCharacterEncodingHeader();
    }

    @Override
    public String getContentTypeMimeEncoding() {
        return String.valueOf(this.header.getMimeType()) + "; charset=" + this.header.getCharacterEncoding();
    }

    @Override
    public String getReferer() {
        return this.getHeader("Referer");
    }

    @Override
    public String getZhiqimClientType() {
        return this.isMobile() ? "mobile" : "www";
    }

    @Override
    public boolean isRequestGZip() {
        return this.header.isRequestGZip();
    }

    @Override
    public boolean isResponseGZip() {
        return this.header.isResponseGZip();
    }

    @Override
    public boolean isXMLHttpRequest() {
        return "XMLHttpRequest".equalsIgnoreCase(this.getHeader("X-Requested-With"));
    }

    @Override
    public String getUserAgent() {
        return this.header.getUserAgent();
    }

    @Override
    public boolean isMobile() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return userAgent.toLowerCase().contains("mobile") || userAgent.toLowerCase().contains("micromessenger");
    }

    @Override
    public boolean isMicroMessenger() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return userAgent.toLowerCase().contains("micromessenger");
    }

    @Override
    public boolean isIE() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).contains("msie") || userAgent.contains("trident");
    }

    @Override
    public boolean isFirefox() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return userAgent.toLowerCase().contains("firefox");
    }

    @Override
    public boolean isWebkit() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return userAgent.toLowerCase().contains("webkit");
    }

    @Override
    public boolean isChrome() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return userAgent.toLowerCase().contains("chrome");
    }

    @Override
    public boolean isSafari() {
        String userAgent = this.getUserAgent();
        if (Validates.isEmpty((String)userAgent)) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).contains("safari") && !userAgent.contains("chrome");
    }

    @Override
    public List<String> getParameterMatch() {
        return (List)this.getAttribute("org.zhiqim.httpd.HttpRequest.paramMatch");
    }

    @Override
    public String getParameterMatch(int index) {
        return this.getParameterMatch().get(index);
    }

    @Override
    public long getParameterMatchLong(int index) {
        return Longs.toLong((String)this.getParameterMatch().get(index));
    }

    @Override
    public int getParameterMatchInt(int index) {
        return Ints.toInt((String)this.getParameterMatch().get(index));
    }

    @Override
    public HashMap<String, String> getParameterMap() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(this.urlParamMap.instance());
        paramMap.putAll(this.cntParamMap.instance());
        return paramMap;
    }

    @Override
    public boolean hasParameter(String name) {
        return this.cntParamMap.containsKey(name) || this.urlParamMap.containsKey(name);
    }

    @Override
    public String getParameter(String name) {
        return Htmls.filterAll((String)(this.hasParameterOnCNT(name) ? this.cntParamMap.get(name) : this.urlParamMap.get(name)));
    }

    @Override
    public <T> T getParameter(Class<T> clazz) throws IllegalAccessException {
        return (T)Classes.newInstance(clazz, this.getParameterMap());
    }

    @Override
    public String getParameterNoFilter(String name) {
        return Strings.trim((String)(this.hasParameterOnCNT(name) ? this.cntParamMap.get(name) : this.urlParamMap.get(name)));
    }

    @Override
    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        return Validates.isEmpty((String)value) ? defaultValue : value;
    }

    @Override
    public String getParameterNoFilter(String name, String defaultValue) {
        String value = this.getParameterNoFilter(name);
        return Validates.isEmpty((String)value) ? defaultValue : value;
    }

    @Override
    public int getParameterInt(String name) {
        return Ints.toInt((String)this.getParameter(name), (int)-1);
    }

    @Override
    public int getParameterInt(String name, int defaultValue) {
        return Ints.toInt((String)this.getParameter(name), (int)defaultValue);
    }

    @Override
    public long getParameterLong(String name) {
        return Longs.toLong((String)this.getParameter(name), (long)-1L);
    }

    @Override
    public long getParameterLong(String name, long defaultValue) {
        return Longs.toLong((String)this.getParameter(name), (long)defaultValue);
    }

    @Override
    public boolean getParameterBoolean(String name) {
        return "true".equalsIgnoreCase(this.getParameter(name));
    }

    @Override
    public boolean getParameterBoolean(String name, boolean defaultValue) {
        String value = this.getParameter(name);
        if (Validates.isEmptyBlank((String)value)) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public int getParameterAmount2R(String name) {
        return Amounts.toFen((String)this.getParameter(name), (int)-1);
    }

    @Override
    public int getParameterAmount2R(String name, int defaultValue) {
        return Amounts.toFen((String)this.getParameter(name), (int)defaultValue);
    }

    @Override
    public long getParameterAmount2RLong(String name) {
        return Amounts.toFen((String)this.getParameter(name), (long)-1L);
    }

    @Override
    public long getParameterAmount2R(String name, long defaultValue) {
        return Amounts.toFen((String)this.getParameter(name), (long)defaultValue);
    }

    @Override
    public String[] getParameterValues(String name) {
        String value = this.getParameter(name);
        return value == null ? null : Arrays.toStringArray((String)value);
    }

    @Override
    public String[] getParameterValuesNoFilter(String name) {
        String value = this.getParameterNoFilter(name);
        return value == null ? null : Arrays.toStringArray((String)value);
    }

    @Override
    public HashMap<String, String> getParameterMapOnURL() {
        HashMap<String, String> paramMap = new HashMap<String, String>(this.urlParamMap.size());
        paramMap.putAll(this.urlParamMap.instance());
        return paramMap;
    }

    @Override
    public boolean hasParameterOnURL(String name) {
        return this.urlParamMap.containsKey(name);
    }

    @Override
    public String getParameterOnURL(String name) {
        return Htmls.filterAll((String)this.urlParamMap.get(name));
    }

    @Override
    public String getParameterOnURL(String name, String defaultValue) {
        String value = this.getParameterOnURL(name);
        return Validates.isEmptyBlank((String)value) ? defaultValue : value;
    }

    @Override
    public String getParameterNoFilterOnURL(String name) {
        return Strings.trim((String)this.urlParamMap.get(name));
    }

    @Override
    public String getParameterNoFilterOnURL(String name, String defaultValue) {
        String value = this.getParameterNoFilterOnURL(name);
        return Validates.isEmptyBlank((String)value) ? defaultValue : value;
    }

    @Override
    public int getParameterIntOnURL(String name) {
        return Ints.toInt((String)this.getParameterOnURL(name), (int)-1);
    }

    @Override
    public int getParameterIntOnURL(String name, int defaultValue) {
        return Ints.toInt((String)this.getParameterOnURL(name), (int)defaultValue);
    }

    @Override
    public long getParameterLongOnURL(String name) {
        return Longs.toLong((String)this.getParameterOnURL(name), (long)-1L);
    }

    @Override
    public long getParameterLongOnURL(String name, long defaultValue) {
        return Longs.toLong((String)this.getParameterOnURL(name), (long)defaultValue);
    }

    @Override
    public int getParameterAmount2ROnURL(String name, int defaultValue) {
        return Amounts.toFen((String)this.getParameterOnURL(name), (int)defaultValue);
    }

    @Override
    public long getParameterAmount2ROnURL(String name, long defaultValue) {
        return Amounts.toFen((String)this.getParameterOnURL(name), (long)defaultValue);
    }

    @Override
    public String[] getParameterValuesOnURL(String name) {
        String value = this.getParameterOnURL(name);
        return value == null ? null : Arrays.toStringArray((String)value);
    }

    @Override
    public void setParameterOnURL(String name, Object value) {
        this.urlParamMap.put(name, value == null ? null : String.valueOf(value));
    }

    @Override
    public void setParameterOnCNT(String name, Object value) {
        this.cntParamMap.put(name, value == null ? null : String.valueOf(value));
    }

    @Override
    public InputStream getInputStream() {
        return this.bis;
    }

    @Override
    public String getInputStreamString() {
        int len = this.getContentLength();
        if (len == 0) {
            return "";
        }
        try {
            byte[] buffer = new byte[len];
            this.bis.read(buffer);
            return new String(buffer, this.getCharacterEncoding());
        }
        catch (Exception e) {
            throw Asserts.exception((String)("\u89e3\u6790\u8bf7\u6c42\u5185\u5bb9\u65f6\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    @Override
    public HashMap<String, String> getParameterMapOnCNT() {
        HashMap<String, String> paramMap = new HashMap<String, String>(this.cntParamMap.size());
        paramMap.putAll(this.cntParamMap.instance());
        return paramMap;
    }

    @Override
    public boolean hasParameterOnCNT(String name) {
        return this.cntParamMap.containsKey(name);
    }

    @Override
    public String getParameterOnCNT(String name) {
        return Htmls.filterAll((String)this.cntParamMap.get(name));
    }

    @Override
    public String getParameterOnCNT(String name, String defaultValue) {
        String value = this.getParameterOnCNT(name);
        return Validates.isEmptyBlank((String)value) ? defaultValue : value;
    }

    @Override
    public String getParameterNoFileterOnCNT(String name) {
        return Strings.trim((String)this.cntParamMap.get(name));
    }

    @Override
    public String getParameterNoFileterOnCNT(String name, String defaultValue) {
        String value = this.getParameterNoFileterOnCNT(name);
        return Validates.isEmptyBlank((String)value) ? defaultValue : value;
    }

    @Override
    public int getParameterIntOnCNT(String name) {
        return Ints.toInt((String)this.getParameterOnCNT(name), (int)-1);
    }

    @Override
    public int getParameterIntOnCNT(String name, int defaultValue) {
        return Ints.toInt((String)this.getParameterOnCNT(name), (int)defaultValue);
    }

    @Override
    public long getParameterLongOnCNT(String name) {
        return Longs.toLong((String)this.getParameterOnCNT(name), (long)-1L);
    }

    @Override
    public long getParameterLongOnCNT(String name, long defaultValue) {
        return Longs.toLong((String)this.getParameterOnCNT(name), (long)defaultValue);
    }

    @Override
    public int getParameterAmount2ROnCNT(String name, int defaultValue) {
        return Amounts.toFen((String)this.getParameterOnCNT(name), (int)defaultValue);
    }

    @Override
    public long getParameterAmount2ROnCNT(String name, long defaultValue) {
        return Amounts.toFen((String)this.getParameterOnCNT(name), (long)defaultValue);
    }

    @Override
    public String[] getParameterValuesOnCNT(String name) {
        String value = this.getParameterOnCNT(name);
        return value == null ? null : Arrays.toStringArray((String)value);
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.attributeMap.instance();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        return this.hasAttribute(name) ? this.getAttribute(name) : defaultValue;
    }

    @Override
    public String getAttributeString(String name) {
        return this.getAttributeString(name, null);
    }

    @Override
    public String getAttributeString(String name, String defaultValue) {
        Object value = this.attributeMap.get(name);
        return value == null ? defaultValue : String.valueOf(value);
    }

    @Override
    public int getAttributeInt(String name) {
        return Ints.toInt((Object)this.attributeMap.get(name), (int)-1);
    }

    @Override
    public int getAttributeInt(String name, int defaultValue) {
        return Ints.toInt((Object)this.attributeMap.get(name), (int)defaultValue);
    }

    @Override
    public long getAttributeLong(String name) {
        return Longs.toLong((Object)this.attributeMap.get(name), (long)-1L);
    }

    @Override
    public long getAttributeLong(String name, int defaultValue) {
        return Longs.toLong((Object)this.attributeMap.get(name), (long)defaultValue);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    @Override
    public Object getNestAttribute(String name) {
        boolean exists = this.hasAttribute(name);
        if (exists) {
            return this.getAttribute(name);
        }
        exists = this.hasSessionAttribute(name);
        if (exists) {
            return this.getSessionAttribute(name);
        }
        exists = this.hasContextAttribute(name);
        return exists ? this.getContextAttribute(name) : null;
    }

    @Override
    public Object getNestAttribute(String name, Object defaultValue) {
        return this.hasNestAttribute(name) ? this.getNestAttribute(name) : defaultValue;
    }

    @Override
    public String getNestAttributeString(String name) {
        return this.getNestAttributeString(name, null);
    }

    @Override
    public String getNestAttributeString(String name, String defaultValue) {
        if (!this.hasNestAttribute(name)) {
            return defaultValue;
        }
        Object val = this.getNestAttribute(name);
        return val == null ? null : Strings.valueOf((Object)val);
    }

    @Override
    public int getNestAttributeInt(String name) {
        return this.getNestAttributeInt(name, -1);
    }

    @Override
    public int getNestAttributeInt(String name, int defaultValue) {
        return Ints.toInt((Object)this.getNestAttribute(name), (int)defaultValue);
    }

    @Override
    public long getNestAttributeLong(String name) {
        return this.getNestAttributeLong(name, -1);
    }

    @Override
    public long getNestAttributeLong(String name, int defaultValue) {
        return Longs.toLong((Object)this.getNestAttribute(name), (long)defaultValue);
    }

    @Override
    public boolean hasNestAttribute(String name) {
        boolean exists = this.hasAttribute(name);
        if (exists) {
            return true;
        }
        exists = this.hasSessionAttribute(name);
        if (exists) {
            return true;
        }
        return this.hasContextAttribute(name);
    }

    @Override
    public void setResponseNoCache() {
        HttpResponse response = this.getResponse();
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, must-revalidate, no-store");
        response.setHeader("P3P", "CP=\"CAO PSA OUR\"");
        response.setDateHeader("Expires", 0L);
    }

    @Override
    public void setResponsePrivateCache() {
        this.getResponse().setCacheControlPrivate();
    }

    @Override
    public void setResponseEncodingUTF8() {
        HttpResponse response = this.getResponse();
        response.setCharacterEncoding("UTF-8");
    }

    @Override
    public void forwardTo(String pathInContext) throws HttpException, IOException {
        int ind = pathInContext.indexOf("?");
        if (ind == -1) {
            this.header.setPathInContext(pathInContext);
        } else {
            Map paramMap = Urls.toMapNoEncoded((String)pathInContext);
            this.urlParamMap.putAll(paramMap);
            this.header.setPathInContext(pathInContext.substring(0, ind));
        }
        HttpResponse response = this.getResponse();
        HttpContext context = this.getContext();
        context.handle(this, response);
        this.hasForward = true;
        response.commit();
    }

    @Override
    public boolean hasForward() {
        return this.hasForward;
    }

    @Override
    public String getPathInContext() {
        return this.header.getPathInContext();
    }

    @Override
    public String getPathOnResource() {
        return this.header.getPathOnResource();
    }

    @Override
    public void setPathOnResource(String pathOnResource) {
        this.header.setPathOnResource(pathOnResource);
    }

    public String toString() {
        return this.header.toString();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException iOException) {}
            this.bis = null;
        }
        if (this.urlParamMap != null) {
            this.urlParamMap.clear();
            this.urlParamMap = null;
        }
        if (this.cntParamMap != null) {
            this.cntParamMap.clear();
            this.cntParamMap = null;
        }
        if (this.cookieMap != null) {
            this.cookieMap.clear();
            this.cookieMap = null;
        }
        if (this.attributeMap != null) {
            this.attributeMap.clear();
            this.attributeMap = null;
        }
        this.header = null;
        this.server = null;
        this.conn = null;
        this.context = null;
        this.input = null;
        this.session = null;
    }
}

