/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.seqs;

import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.seqs.SequenceFile;

public class SequenceDateFile
extends SequenceFile {
    private String date = DateTimes.getDateString();

    public SequenceDateFile(String filePath) {
        super(filePath);
    }

    public SequenceDateFile(int len, String filePath) {
        super(len, filePath);
    }

    public SequenceDateFile(long min, long max, String filePath) {
        super(min, max, min, filePath);
    }

    public SequenceDateFile(long min, long max, long seq, String filePath) {
        super(min, max, seq, filePath);
    }

    public SequenceDateFile(String filePath, boolean auto) {
        super(filePath, auto);
    }

    public SequenceDateFile(int len, String filePath, boolean auto) {
        super(len, filePath, auto);
    }

    public SequenceDateFile(long min, long max, String filePath, boolean auto) {
        super(min, max, filePath, auto);
    }

    public SequenceDateFile(long min, long max, long seq, String filePath, boolean auto) {
        super(min, max, seq, filePath, auto);
    }

    public String getDate() {
        return this.date;
    }

    @Override
    public SequenceDateFile load() {
        String seqs = this.readFile();
        if (Validates.isEmpty(seqs)) {
            return this;
        }
        String[] seqArr = Arrays.toStringArray(seqs);
        if (seqArr.length != 2) {
            return this;
        }
        String sdate = Strings.trim(seqArr[0]);
        if (!sdate.equals(this.date)) {
            return this;
        }
        String seq = Strings.trim(seqArr[1]);
        if (!Validates.isIntegerPositive(seq)) {
            return this;
        }
        this.setSequence(Ints.toInt(seq));
        return this;
    }

    @Override
    public void save() {
        String seq = Strings.suffixLen(this.sequence, 19, ' ');
        this.writeFile(this.date + "," + seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        if (!this.isValid()) {
            throw Asserts.exception("\u521b\u5efaSequenceFile\u5931\u8d25\uff0c\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\u4e14\u521b\u5efa\u5931\u8d25");
        }
        SequenceDateFile sequenceDateFile = this;
        synchronized (sequenceDateFile) {
            String curDate = DateTimes.getDateString();
            if (curDate.equals(this.date)) {
                this.chkSequence();
            } else {
                this.resetSequence();
                this.date = curDate;
            }
            long seq = this.sequence++;
            if (this.isAuto()) {
                this.save();
            }
            return seq;
        }
    }
}

