/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json.parser;

import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;

public class BaseParser
implements JsonParser {
    private static final long MAX_JS_LONG_VALUE = (long)Math.pow(2.0, 53.0);
    private Json jsonMain;

    @Override
    public JsonParser set(Json jsonMain) {
        this.jsonMain = jsonMain;
        return this;
    }

    @Override
    public String toString(Object obj) {
        if (this.jsonMain.isJsLong() && obj instanceof Long) {
            long l = (Long)obj;
            if (l > MAX_JS_LONG_VALUE) {
                return "\"" + l + "\"";
            }
        } else if (obj instanceof String) {
            String str = Jsons.addEscapeChar((String)obj, '\"');
            return "\"" + str + "\"";
        }
        return String.valueOf(obj);
    }

    @Override
    public Object toObject(String json, Class<?> cls) {
        json = Jsons.removeStartEndQuotation(json);
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.parseBoolean(json);
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.parseByte(json);
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.valueOf(json.charAt(0));
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.parseShort(json);
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Ints.toInt(json);
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Longs.toLong(json);
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.valueOf(Float.parseFloat(json));
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.parseDouble(json);
        }
        if (cls == String.class) {
            return Jsons.removeEscapeChar(json);
        }
        return null;
    }
}

