/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.config.ConfigResolver;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.config.ItemType;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.XmlConstants;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapSV;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xmls;

public class Config
implements Serializable,
ZhiqimConstants,
CodeConstants,
XmlConstants {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String path;
    private final boolean isXml;
    private final boolean ignoreCase;
    private LinkedMapSV<Group> groupMap = new LinkedMapSV();

    public Config(String name) {
        this(name, null, true, false);
    }

    public Config(String name, String path) {
        this(name, path, "xml".equals(Files.getFileExt(path)), false);
    }

    public Config(String name, String path, boolean isXml, boolean ignoreCase) {
        this.name = name;
        this.path = path;
        this.isXml = isXml;
        this.ignoreCase = ignoreCase;
    }

    public String toString() {
        if (this.isXml()) {
            StringBuilder strb = new StringBuilder();
            strb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n");
            strb.append("<!DOCTYPE ZHIQIM-CONFIG PUBLIC \"-//ZHIQIM //DTD Zhiqim-Config Configuration 1.5.0//EN\" \"http://zhiqim.org/xmldtds/zhiqim_config_1_5_0.dtd\">").append("\r\n");
            strb.append("<zhiqim-config>").append("\r\n").append("\r\n");
            for (Group group : this.groupMap.values()) {
                strb.append(group.toString()).append("\r\n").append("\r\n");
            }
            strb.append("</zhiqim-config>");
            return strb.toString();
        }
        StringBuilder strb = new StringBuilder();
        for (Group group : this.groupMap.values()) {
            strb.append(group.toString()).append("\r\n");
        }
        return strb.toString();
    }

    public Config load() throws IOException {
        if (Validates.isEmptyBlank(this.path)) {
            return this;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(this.path);){
            return this.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Config load(InputStream in) throws IOException {
        if (this.isXml()) {
            Document document = Xmls.buildDocument(in, (EntityResolver)new ConfigResolver(this.path));
            NodeList groupNodeList = document.getElementsByTagName("group");
            this.initGroup(groupNodeList);
        } else {
            Asserts.asserts(in.available() >= 3, ZhiqimI18n.configFileFormatNotCorrect, this.path);
            byte[] buffer = new byte[4096];
            int len = Streams.readLine(in, buffer, buffer.length);
            String encoding = null;
            ArrayList<String> lineList = new ArrayList<String>();
            do {
                String str;
                if (encoding == null) {
                    encoding = Streams.getStreamEncoding(buffer, len);
                }
                if (Validates.isEmpty(str = Strings.trim(new String(buffer, 0, len, encoding)))) continue;
                lineList.add(str);
            } while ((len = Streams.readLine(in, buffer, buffer.length)) != -1);
            this.initGroup(lineList);
        }
        return this;
    }

    private void initGroup(List<String> lineList) throws IllegalArgumentException {
        Group group = null;
        char symbol = '#';
        String desc = null;
        for (String line : lineList) {
            int ind;
            if (line.startsWith("[")) {
                ind = line.indexOf("]");
                if (ind == -1) {
                    throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u672c\u9875\u914d\u7f6e\u7ec4[groupId]\u4e0d\u6b63\u786e", this.path);
                }
                String groupId = line.substring(1, ind);
                group = new Group(this, groupId, desc, symbol);
                if (this.addGroup(group)) continue;
                throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u672c\u9875\u6709\u76f8\u540c\u7684\u914d\u7f6e\u7ec4[%s]", this.path, groupId);
            }
            if (line.startsWith("#") || line.startsWith(";")) {
                symbol = line.charAt(0);
                desc = line.substring(1).trim();
                continue;
            }
            if (group == null) {
                throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u672c\u9875\u914d\u7f6e\u9879[%s]\u524d\u9762\u6ca1\u6709[groupId]", this.path, line);
            }
            ind = line.indexOf("=");
            if (ind < 1) {
                throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u672c\u9875\u914d\u7f6e\u9879[%s]\u6ca1\u6709=\u53f7\u6216=\u53f7\u662f\u7b2c\u4e00\u4e2a\u5b57\u7b26", this.path, line);
            }
            String key = line.substring(0, ind).trim();
            String value = Strings.trimLeft(line.substring(ind + 1));
            ItemType type = ItemType.PROTECTED;
            if (desc != null) {
                if (desc.startsWith("protected")) {
                    desc = desc.substring("protected".length());
                } else if (desc.startsWith("private")) {
                    type = ItemType.PRIVATE;
                    desc = desc.substring("private".length());
                } else if (desc.startsWith("public")) {
                    type = ItemType.PUBLIC;
                    desc = desc.substring("public".length());
                }
            }
            if (group.add(key, value, type, desc, symbol)) continue;
            throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u7ec4[%s]\u6709\u76f8\u540c\u7684\u914d\u7f6e\u9879[%s]", this.path, group.getId(), key);
        }
    }

    private void initGroup(NodeList groupNodeList) throws IllegalArgumentException {
        int i = 0;
        while (i < groupNodeList.getLength()) {
            Node node = groupNodeList.item(i);
            if (node.getNodeType() == 1) {
                String groupDesc;
                String groupId = Xmls.getAttribute(node, "id");
                Group group = new Group(this, groupId, groupDesc = Xmls.getAttribute(node, "desc"));
                if (!this.addGroup(group)) {
                    throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u672c\u9875\u6709\u76f8\u540c\u7684\u914d\u7f6e\u7ec4[%s]", this.path, groupId);
                }
                NodeList childNodeList = node.getChildNodes();
                int j = 0;
                while (j < childNodeList.getLength()) {
                    Node childNode = childNodeList.item(j);
                    if (childNode.getNodeType() == 1) {
                        NamedNodeMap namedNodeMap = childNode.getAttributes();
                        String key = Xmls.getAttribute(namedNodeMap, "key");
                        String value = Xmls.getAttribute(namedNodeMap, "value");
                        String desc = Xmls.getAttribute(namedNodeMap, "desc");
                        String type = Xmls.getAttribute(namedNodeMap, "type");
                        if (!group.add(key, value, ItemType.toType(type), desc)) {
                            throw Asserts.exception("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6[%s]\u65f6\u7ec4[%s]\u6709\u76f8\u540c\u7684\u914d\u7f6e\u9879[%s]", this.path, groupId, key);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public Config save() throws IOException {
        if (Validates.isEmptyBlank(this.path)) {
            return this;
        }
        String content = this.toString();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(this.path);){
            fos.write(239);
            fos.write(187);
            fos.write(191);
            fos.write(content.getBytes(_UTF_8_C_));
            fos.flush();
            return this;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean addGroup(String groupId) {
        return this.addGroup(new Group(this, groupId, null));
    }

    public boolean addGroup(String groupId, String groupDesc) {
        return this.addGroup(new Group(this, groupId, groupDesc));
    }

    public boolean addGroup(String groupId, String groupDesc, char symbol) {
        return this.addGroup(new Group(this, groupId, groupDesc, symbol));
    }

    public boolean addGroup(Group group) {
        String groupIdCase = this.ignoreCase(group.getId());
        if (this.groupMap.containsKey(groupIdCase)) {
            return false;
        }
        this.groupMap.put(groupIdCase, group);
        return true;
    }

    public void removeGroup(String groupId) {
        this.groupMap.remove(groupId);
    }

    public void setString(String id, String key, String value) {
        String groupIdCase = this.ignoreCase(id);
        Group group = (Group)this.groupMap.get(groupIdCase);
        if (group == null) {
            group = new Group(this, id, null);
            group.add(key, value);
            this.groupMap.put(groupIdCase, group);
            return;
        }
        Item item = group.item(key);
        if (item == null) {
            group.add(key, value);
        } else {
            item.setValue(value);
        }
    }

    public void setInt(String id, String key, int value) {
        this.setString(id, key, String.valueOf(value));
    }

    public void setLong(String id, String key, long value) {
        this.setString(id, key, String.valueOf(value));
    }

    public void setBoolean(String id, String key, boolean value) {
        this.setString(id, key, String.valueOf(value));
    }

    public boolean remove(String id, String key) {
        Group group = (Group)this.groupMap.get(id);
        if (group == null) {
            return false;
        }
        return group.remove(key);
    }

    public boolean hasGroup(String id) {
        return this.groupMap.containsKey(this.ignoreCase(id));
    }

    public Group getGroup(String id) {
        return (Group)this.groupMap.get(this.ignoreCase(id));
    }

    public LinkedMapSV<Group> getGroupMap() {
        return this.groupMap;
    }

    public Collection<Group> getGroupList() {
        return this.groupMap.values();
    }

    public boolean hasItem(String id, String key) {
        Group group = (Group)this.groupMap.get(id);
        if (group == null) {
            return false;
        }
        return group.hasItem(key);
    }

    public MapSV<Item> getItemMap(String id) {
        return this.hasGroup(id) ? this.getGroup(id).map() : null;
    }

    public Collection<Item> getItemList(String id) {
        return this.hasGroup(id) ? this.getGroup(id).list() : null;
    }

    public String getString(String id, String key) {
        Group group = this.getGroup(id);
        return group == null ? null : group.getString(key);
    }

    public String getString(String id, String key, String defaultValue) {
        String value = this.getString(id, key);
        return value == null ? defaultValue : value;
    }

    public int getInt(String id, String key) {
        String value = this.getString(id, key);
        return value == null ? -1 : Ints.toInt(value, -1);
    }

    public int getInt(String id, String key, int defaultValue) {
        int value = this.getInt(id, key);
        return value == -1 ? defaultValue : value;
    }

    public long getLong(String id, String key) {
        String value = this.getString(id, key);
        return value == null ? -1L : Longs.toLong(value, -1L);
    }

    public long getLong(String id, String key, long defaultValue) {
        long value = this.getLong(id, key);
        return value == -1L ? defaultValue : value;
    }

    public boolean getBoolean(String id, String key, boolean defaultValue) {
        String value = this.getString(id, key);
        return value == null ? defaultValue : "true".equalsIgnoreCase(value);
    }

    public boolean isTrue(String id, String key) {
        return "true".equalsIgnoreCase(this.getString(id, key));
    }

    public boolean isFalse(String id, String key) {
        return "false".equalsIgnoreCase(this.getString(id, key));
    }

    public String ignoreCase(String value) {
        return this.ignoreCase ? value.toLowerCase() : value;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isXml() {
        return this.isXml;
    }

    public boolean isIni() {
        return !this.isXml;
    }
}

