/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import java.util.ArrayList;
import java.util.List;
import net.redxyz.top.dbo.sys.SysNavWeb;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"NavWebDao"})
@AnGlobal
public class NavWebDao {
    public List<SysNavWeb> getNav1List() throws Exception {
        ArrayList<SysNavWeb> list = new ArrayList<SysNavWeb>();
        List<SysNavWeb> navList = this.getNavList();
        for (SysNavWeb nav : navList) {
            if (nav.getNavLevel() != 1 || nav.getNavType() != 1) continue;
            list.add(nav);
        }
        return list;
    }

    public String getLinkNav1Id(HttpRequest request, String parentUrl) throws Exception {
        String path = parentUrl == null ? request.getPathInContext() : parentUrl;
        List<SysNavWeb> navList = this.getNavList();
        for (SysNavWeb nav : navList) {
            if (nav.getNavType() == 3 || nav.getNavLevel() == 3 || !nav.getNavUrl().equals(path)) continue;
            return nav.getNavLevel() == 1 ? nav.getNavId() : nav.getParentId();
        }
        return null;
    }

    public String getLinkNav2Id(HttpRequest request, String parentUrl) throws Exception {
        String path = parentUrl == null ? request.getPathInContext() : parentUrl;
        List<SysNavWeb> navList = this.getNavList();
        for (SysNavWeb nav : navList) {
            if (nav.getNavLevel() == 1 || !nav.getNavUrl().equals(path)) continue;
            return nav.getNavLevel() == 2 ? nav.getNavId() : nav.getParentId();
        }
        return null;
    }

    public boolean hasChild(String navId) throws Exception {
        List<SysNavWeb> navList = this.getNavList();
        for (SysNavWeb nav : navList) {
            if (nav.getNavType() != 1 || !nav.getParentId().equals(navId)) continue;
            return true;
        }
        return false;
    }

    public List<SysNavWeb> getChildren(String navId) throws Exception {
        ArrayList<SysNavWeb> list = new ArrayList<SysNavWeb>();
        List<SysNavWeb> navList = this.getNavList();
        for (SysNavWeb nav : navList) {
            if (nav.getNavType() != 1 || !nav.getParentId().equals(navId)) continue;
            list.add(nav);
        }
        return list;
    }

    public boolean hasUrlPermission(String pageUrl) throws Exception {
        List<SysNavWeb> navList = this.getNavList();
        for (SysNavWeb nav : navList) {
            if (!nav.getNavUrl().equals(pageUrl)) continue;
            return true;
        }
        return false;
    }

    private List<SysNavWeb> getNavList() throws Exception {
        Selector aSelector = new Selector();
        aSelector.addMaybe("navStatus", (Object)1);
        aSelector.addOrderbyAsc("navLevel");
        aSelector.addOrderbyAsc("navSeq");
        List navList = ((ZTable)Global.get(ZTable.class)).list(SysNavWeb.class, aSelector);
        for (SysNavWeb nav : navList) {
            nav.setNavId(nav.getNavId().trim());
            nav.setParentId(nav.getParentId().trim());
            nav.setNavName(nav.getNavName().trim());
            nav.setNavUrl(nav.getNavUrl().trim());
        }
        return navList;
    }
}

