/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import java.util.ArrayList;
import java.util.List;
import net.redxyz.top.dbo.sys.SysNavPc;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"NavPcDao"})
@AnGlobal
public class NavPcDao {
    public List<SysNavPc> getNav1List() throws Exception {
        ArrayList<SysNavPc> list = new ArrayList<SysNavPc>();
        List<SysNavPc> navList = this.getNavList();
        for (SysNavPc nav : navList) {
            if (nav.getNavLevel() != 1 || nav.getNavType() != 1) continue;
            list.add(nav);
        }
        return list;
    }

    public String getLinkNav1Id(HttpRequest request, String parentUrl) throws Exception {
        String path = parentUrl == null ? request.getPathInContext() : parentUrl;
        List<SysNavPc> navList = this.getNavList();
        for (SysNavPc nav : navList) {
            if (nav.getNavType() == 3 || nav.getNavLevel() == 3 || !nav.getNavUrl().equals(path)) continue;
            return nav.getNavLevel() == 1 ? nav.getNavId() : nav.getParentId();
        }
        return null;
    }

    public boolean hasChild(String navId) throws Exception {
        List<SysNavPc> navList = this.getNavList();
        for (SysNavPc nav : navList) {
            if (nav.getNavType() != 1 || !nav.getParentId().equals(navId)) continue;
            return true;
        }
        return false;
    }

    public List<SysNavPc> getChildren(String navId) throws Exception {
        List<SysNavPc> navList = this.getNavList();
        ArrayList<SysNavPc> list = new ArrayList<SysNavPc>();
        for (SysNavPc nav : navList) {
            if (nav.getNavType() != 1 || !nav.getParentId().equals(navId)) continue;
            list.add(nav);
        }
        return list;
    }

    public boolean hasUrlPermission(String pageUrl) throws Exception {
        List<SysNavPc> navList = this.getNavList();
        for (SysNavPc nav : navList) {
            if (!nav.getNavUrl().equals(pageUrl)) continue;
            return true;
        }
        return false;
    }

    private List<SysNavPc> getNavList() throws Exception {
        Selector aSelector = new Selector();
        aSelector.addMaybe("navStatus", (Object)1);
        aSelector.addOrderbyAsc("navLevel");
        aSelector.addOrderbyAsc("navSeq");
        List navList = ((ZTable)Global.get(ZTable.class)).list(SysNavPc.class, aSelector);
        for (SysNavPc nav : navList) {
            nav.setNavId(nav.getNavId().trim());
            nav.setParentId(nav.getParentId().trim());
            nav.setNavName(nav.getNavName().trim());
            nav.setNavUrl(nav.getNavUrl().trim());
        }
        return navList;
    }
}

