/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service;

import java.util.List;
import net.redxyz.top.data.item.Sku;
import org.zhiqim.kernel.util.Validates;

public class SkuUtil {
    public static Sku getSku(List<Sku> skuList, long skuId) {
        if (skuList == null) {
            return null;
        }
        for (Sku sku : skuList) {
            if (sku.getSkuId() != skuId) continue;
            return sku;
        }
        return null;
    }

    public static String[] buildSkuPriceProps(List<Sku> skuList) {
        String skuPrices = "";
        String skuQuantities = "";
        String skuProperties = "";
        String skuOuterIds = "";
        int i = 0;
        while (i < skuList.size()) {
            Sku sku = skuList.get(i);
            String price = sku.getPrice();
            String properties = sku.getProperties();
            String outer_id = sku.getOuterId();
            if (Validates.isEmpty((String)outer_id)) {
                outer_id = "";
            }
            if (i == 0) {
                skuPrices = price;
                skuQuantities = "";
                skuProperties = properties;
                skuOuterIds = outer_id;
            } else {
                skuPrices = String.valueOf(skuPrices) + "," + price;
                skuQuantities = String.valueOf(skuQuantities) + ",";
                skuProperties = String.valueOf(skuProperties) + "," + properties;
                skuOuterIds = String.valueOf(skuOuterIds) + "," + outer_id;
            }
            ++i;
        }
        return new String[]{skuPrices, skuQuantities, skuProperties, skuOuterIds};
    }

    public static String buildSkuidQuantities(List<Sku> skuList) {
        String skuidQuantities = "";
        if (skuList == null || skuList.isEmpty()) {
            return skuidQuantities;
        }
        int i = 0;
        while (i < skuList.size()) {
            Sku sku = skuList.get(i);
            long skuId = sku.getSkuId();
            int quantity = sku.getQuantity();
            if (i > 0) {
                skuidQuantities = String.valueOf(skuidQuantities) + ";";
            }
            skuidQuantities = String.valueOf(skuidQuantities) + skuId + ":" + quantity;
            ++i;
        }
        return skuidQuantities;
    }
}

