/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.redxyz.top.TaobaoException;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.security.SecretContext;
import net.redxyz.top.security.SecretData;
import net.redxyz.top.security.SecretException;
import net.redxyz.top.security.SecretUtil;
import net.redxyz.top.security.SecurityBiz;
import net.redxyz.top.security.SecurityConstants;
import net.redxyz.top.security.SecurityCore;
import net.redxyz.top.security.SecurityCounter;
import org.zhiqim.kernel.util.Validates;

public class SecurityClient
implements SecurityConstants {
    private SecurityCore secretCore;
    private SecurityCounter securityCounter = new SecurityCounter(TaobaoService.getServer().getAppKey());

    public SecurityClient() {
        this.secretCore = new SecurityCore();
    }

    public Map<String, String> decrypt(List<String> dataList, String type) throws SecretException {
        return this.decrypt(dataList, type, null);
    }

    public Map<String, String> decrypt(List<String> dataList, String type, String session) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            throw new SecretException("dataList can`t be empty");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String data : dataList) {
            if (resultMap.containsKey(data)) continue;
            String decryptValue = this.decrypt(data, type, session);
            resultMap.put(data, decryptValue);
        }
        return resultMap;
    }

    public String decrypt(String data, String type) throws SecretException {
        return this.decrypt(data, type, null);
    }

    public String decrypt(String data, String type, String session) throws SecretException {
        if (Validates.isEmpty((String)data) || data.length() < 4) {
            return data;
        }
        Character charValue = SecurityBiz.getSeparatorCharMap().get(type);
        if (charValue == null) {
            throw new SecretException("type error");
        }
        char separator = charValue.charValue();
        if (data.charAt(0) != separator || data.charAt(data.length() - 1) != separator) {
            return data;
        }
        SecretData secretDataDO = null;
        secretDataDO = data.charAt(data.length() - 2) == separator ? SecurityBiz.getIndexSecretData(data, separator) : SecurityBiz.getSecretData(data, separator);
        if (secretDataDO == null) {
            return data;
        }
        try {
            if (secretDataDO.getSecretVersion() < 0L) {
                secretDataDO.setSecretVersion(Math.abs(secretDataDO.getSecretVersion()));
                session = null;
            }
            this.securityCounter.addDecryptCount(type, session);
            SecretContext secretContextDO = this.secretCore.getSecret(session, secretDataDO.getSecretVersion());
            String decryptValue = SecretUtil.aesDecrypt(secretDataDO.getOriginalBase64Value(), secretContextDO.getSecret());
            if ("phone".equals(type) && !secretDataDO.isSearch()) {
                return String.valueOf(secretDataDO.getOriginalValue()) + decryptValue;
            }
            return decryptValue;
        }
        catch (TaobaoException e) {
            throw new SecretException("get secret error", e);
        }
    }

    public static boolean isEncryptData(List<String> dataList, String type) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (String data : dataList) {
            result = SecurityClient.isEncryptData(data, type);
            if (result) continue;
            return false;
        }
        return result;
    }

    public static boolean isPartEncryptData(List<String> dataList, String type) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (String data : dataList) {
            result = SecurityClient.isEncryptData(data, type);
            if (!result) continue;
            return true;
        }
        return result;
    }

    public static boolean isEncryptData(String data, String type) throws SecretException {
        return SecurityBiz.isEncryptData(data, type);
    }

    public String encrypt(String data, String type) throws SecretException {
        return this.encrypt(data, type, null, null);
    }

    public String encryptPrevious(String data, String type) throws SecretException {
        return this.encrypt(data, type, null, -1L);
    }

    public String encrypt(String data, String type, String session) throws SecretException {
        return this.encrypt(data, type, session, null);
    }

    public String encryptPrevious(String data, String type, String session) throws SecretException {
        return this.encrypt(data, type, session, -1L);
    }

    public String search(String data, String type) throws SecretException {
        return this.search(data, type, null, null);
    }

    public String searchPrevious(String data, String type) throws SecretException {
        return this.search(data, type, null, -1L);
    }

    public String search(String data, String type, String session) throws SecretException {
        return this.search(data, type, session, null);
    }

    public String searchPrevious(String data, String type, String session) throws SecretException {
        return this.search(data, type, session, -1L);
    }

    private String search(String data, String type, String session, Long version) throws SecretException {
        if (Validates.isEmpty((String)data)) {
            return data;
        }
        try {
            SecretContext secretContext = this.secretCore.getSecret(session, version);
            if (secretContext == null) {
                throw new SecretException("secretKey is null");
            }
            if (secretContext.getSecret() == null) {
                return data;
            }
            String separator = SecurityBiz.getSeparatorMap().get(type);
            if (separator == null) {
                throw new SecretException("type error");
            }
            if (session == null) {
                SecretContext publicSecretContext = new SecretContext();
                publicSecretContext.setSecret(secretContext.getSecret());
                publicSecretContext.setSecretVersion(-secretContext.getSecretVersion().longValue());
                secretContext = publicSecretContext;
            }
            this.securityCounter.addSearchCount(type, session);
            if ("phone".equals(type)) {
                return SecurityBiz.searchPhoneIndex(data, separator, secretContext);
            }
            int compressLen = this.secretCore.getCompressLen();
            int slideSize = this.secretCore.getSlideSize();
            return SecurityBiz.searchNormalIndex(data, compressLen, slideSize, secretContext);
        }
        catch (TaobaoException e) {
            throw new SecretException(e.getMsg());
        }
    }

    private String encrypt(String data, String type, String session, Long version) throws SecretException {
        if (Validates.isEmpty((String)data)) {
            return data;
        }
        try {
            SecretContext secretContext = this.secretCore.getSecret(session, version);
            if (secretContext == null) {
                throw new SecretException("secretKey is null");
            }
            if (secretContext.getSecret() == null) {
                return data;
            }
            String separator = SecurityBiz.getSeparatorMap().get(type);
            if (separator == null) {
                throw new SecretException("type error");
            }
            if (session == null) {
                SecretContext publicSecretContext = new SecretContext();
                publicSecretContext.setSecret(secretContext.getSecret());
                publicSecretContext.setSecretVersion(-secretContext.getSecretVersion().longValue());
                secretContext = publicSecretContext;
            }
            this.securityCounter.addEncryptCount(type, session);
            boolean isEncryptIndex = this.secretCore.isIndexEncrypt(type, version);
            if (isEncryptIndex || "search".equals(type)) {
                if ("phone".equals(type)) {
                    return SecurityBiz.encryptPhoneIndex(data, separator, secretContext);
                }
                int compressLen = this.secretCore.getCompressLen();
                int slideSize = this.secretCore.getSlideSize();
                return SecurityBiz.encryptNormalIndex(data, compressLen, slideSize, separator, secretContext);
            }
            if ("phone".equals(type)) {
                return SecurityBiz.encryptPhone(data, separator, secretContext);
            }
            return SecurityBiz.encryptNormal(data, separator, secretContext);
        }
        catch (TaobaoException e) {
            throw new SecretException(e.getMsg());
        }
    }

    public Map<String, String> encrypt(List<String> dataList, String type) throws SecretException {
        return this.encrypt(dataList, type, null);
    }

    public Map<String, String> encrypt(List<String> dataList, String type, String session) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            throw new SecretException("dataList can`t be empty");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String data : dataList) {
            if (resultMap.containsKey(data)) continue;
            String encryptValue = this.encrypt(data, type, session, null);
            resultMap.put(data, encryptValue);
        }
        return resultMap;
    }

    public static String generateCustomerSession(long userId) {
        return "_" + userId;
    }
}

