/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.actionmobile.item;

import java.util.ArrayList;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Sku;
import net.redxyz.top.message.item.ItemSellerGetResponse4_24625_Sku;
import net.redxyz.top.message.item.ItemUpdateResponse4_21_S;
import net.redxyz.top.portal.SessionUser;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;

public class MobileItemPriceModifyAction
implements Action {
    public void execute(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        long numIid = request.getParameterLong("numIid");
        request.setAttribute("numIid", (Object)numIid);
        ItemSellerGetResponse4_24625_Sku resp = TaobaoService.getItemService().getItemSku(nick, sessionId, numIid);
        if (!resp.isSuccess()) {
            request.setAlertMsg(resp.getErrorMsg());
            request.returnCloseDialog();
            return;
        }
        String price = resp.getPrice();
        String title = resp.getTitle();
        String picUrl = resp.getPicUrl();
        List<Sku> skuList = null;
        if (Validates.isNotEmpty((String)resp.getSkus())) {
            skuList = resp.getSkuList();
        }
        if (skuList == null) {
            skuList = new ArrayList<Sku>();
        }
        request.setAttribute("skuList", skuList);
        request.setAttribute("curPrice", (Object)price);
        request.setAttribute("curTitle", (Object)title);
        request.setAttribute("picUrl", (Object)picUrl);
    }

    @AnIntercept(value={"chkAjax"})
    public String updatePrice(HttpRequest request, long numIid, String price) {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String nick = sessionUser.getNick();
        String sessionId = sessionUser.getSessionId();
        ItemUpdateResponse4_21_S resp = TaobaoService.getItemService().updateItemPrice(nick, sessionId, numIid, price);
        if (!resp.isSuccess()) {
            return resp.getErrorMsg();
        }
        return "\u4fee\u6539\u6210\u529f";
    }
}

