/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.actionmobile.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Item;
import net.redxyz.top.message.item.ItemRecommandAddResponse4_166;
import net.redxyz.top.message.item.ItemRecommandDeleteResponse4_155;
import net.redxyz.top.message.item.ItemSellerGetResponse4_24625;
import net.redxyz.top.message.item.ItemUpdateDelistingResponse4_13;
import net.redxyz.top.message.item.ItemUpdateListingResponse4_32;
import net.redxyz.top.message.item.ItemUpdateResponse4_21_S;
import net.redxyz.top.portal.SessionUser;
import net.redxyz.top.service.Constants;
import net.redxyz.top.service.dao.ItemDao;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;

public class MobileItemManageAction
implements Action,
Constants {
    public void execute(HttpRequest request) throws Exception {
        String itemStatus = request.getParameter("itemStatus", "onsale");
        String flag = request.getParameter("flag");
        if (Validates.isNotEmpty((String)flag)) {
            itemStatus = flag;
        }
        request.setAttribute("itemStatus", (Object)itemStatus);
        request.setView("/zviewmobile/item/mobileItemManage.zml", null);
    }

    @AnIntercept(value={"chkAjax"})
    public String itemChoose(HttpRequest request, String numIids) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        List numIidArray = Lists.toLongList((String)numIids, (String)",");
        List<Item> itemList = TaobaoService.getItemService().getBatchItems(nick, sessionId, numIidArray);
        return Jsons.toString(itemList);
    }

    @AnIntercept(value={"chkAjax"})
    public String doUpdateItem(HttpRequest request, long numIid, String title) {
        if (Validates.isEmpty((String)title)) {
            return "\u5b9d\u8d1d\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a";
        }
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ItemUpdateResponse4_21_S resp = TaobaoService.getItemService().updateItemTitle(nick, sessionId, numIid, title);
        if (!resp.isSuccess()) {
            return resp.getErrorMsg();
        }
        return "\u4fee\u6539\u6210\u529f";
    }

    @AnIntercept(value={"chkAjax"})
    public String queryAllNum(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int totalOnsale = ItemDao.getItemListOnsalePage(itemList, nick, sessionId, "", "", 1, 1);
        int totalInventory = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, "", "", "", 1, 1);
        int totalSoldOut = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, "", "sold_out", "", 1, 1);
        int[] nums = TaobaoService.getItemService().getShowcaseNums(nick, sessionId);
        return "{\"totalOnsale\":" + totalOnsale + ",\"totalInventory\":" + totalInventory + ",\"totalShowcase\":" + nums[1] + ",\"totalSoldOut\":" + totalSoldOut + "}";
    }

    @AnIntercept(value={"chkAjax"})
    public String queryOnsale(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListOnsalePage(itemList, nick, sessionId, sellerCid, q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        HashMapSO attrMap = new HashMapSO();
        attrMap.put("result", (Object)result);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zviewmobile/item/presenter/mobileItemOnsale.zml", (MapSO)attrMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hasNext", result.hasNext());
        map.put("text", ret);
        return Jsons.toString(map);
    }

    @AnIntercept(value={"chkAjax"})
    public String queryInventory(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, sellerCid, "", q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        HashMapSO attrMap = new HashMapSO();
        attrMap.put("result", (Object)result);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zviewmobile/item/presenter/mobileItemInventory.zml", (MapSO)attrMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hasNext", result.hasNext());
        map.put("text", ret);
        return Jsons.toString(map);
    }

    @AnIntercept(value={"chkAjax"})
    public String queryShowcase(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListShowPage(itemList, nick, sessionId, sellerCid, q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zviewmobile/item/presenter/mobileItemShowcase.zml", (String)"result", (Object)result);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hasNext", result.hasNext());
        map.put("text", ret);
        return Jsons.toString(map);
    }

    @AnIntercept(value={"chkAjax"})
    public String querySoldOut(HttpRequest request, String sellerCid, String q, int page) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ArrayList<Item> itemList = new ArrayList<Item>();
        int total = ItemDao.getItemListInventoryPage(itemList, nick, sessionId, sellerCid, "sold_out", q, page, 10);
        PageResult result = PageBuilder.newResult((int)total, (int)page, (int)10, itemList);
        String ret = ZmlContexts.parseZmlPath((HttpRequest)request, (String)"/zviewmobile/item/presenter/mobileItemSoldOut.zml", (String)"result", (Object)result);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hasNext", result.hasNext());
        map.put("text", ret);
        return Jsons.toString(map);
    }

    @AnIntercept(value={"chkAjax"})
    public String doShowcase(HttpRequest request, int status, long numIid) {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        if (status == 1) {
            ItemRecommandAddResponse4_166 resp = TaobaoService.getItemService().doRecommandAdd(nick, sessionId, numIid);
            if (!resp.isSuccess()) {
                return resp.getErrorMsg();
            }
            return "\u63a8\u8350\u6210\u529f";
        }
        ItemRecommandDeleteResponse4_155 resp = TaobaoService.getItemService().doRecommandDelete(nick, sessionId, numIid);
        if (!resp.isSuccess()) {
            return resp.getErrorMsg();
        }
        return "\u53d6\u6d88\u6210\u529f";
    }

    @AnIntercept(value={"chkAjax"})
    public String doDownshelf(HttpRequest request, long numIid) {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ItemUpdateDelistingResponse4_13 resp = TaobaoService.getItemService().doDownRepost(nick, sessionId, numIid);
        if (!resp.isSuccess()) {
            return resp.getErrorMsg();
        }
        return "\u4e0b\u67b6\u6210\u529f";
    }

    @AnIntercept(value={"chkAjax"})
    public String doBatchDownshelf(HttpRequest request, String numIidstr) throws Exception {
        long[] numIids;
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        int successNum = 0;
        int failureNum = 0;
        long[] lArray = numIids = Arrays.toLongArray((String)numIidstr, (String)",");
        int n = numIids.length;
        int n2 = 0;
        while (n2 < n) {
            long numIid = lArray[n2];
            ItemUpdateDelistingResponse4_13 resp = TaobaoService.getItemService().doDownRepost(nick, sessionId, numIid);
            if (!resp.isSuccess()) {
                ++failureNum;
            } else {
                ++successNum;
            }
            ++n2;
        }
        return "\u6279\u5904\u7406\u5b8c\u6210\uff0c\u5171[" + numIids.length + "]\u4e2a\uff0c\u6210\u529f[" + successNum + "]\u4e2a\uff0c\u5931\u8d25[" + failureNum + "]\u4e2a";
    }

    @AnIntercept(value={"chkAjax"})
    public String doUpRepost(HttpRequest request, long numIid, int num) {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        ItemUpdateListingResponse4_32 resp = TaobaoService.getItemService().doAutoRepost(nick, sessionId, numIid, num);
        if (!resp.isSuccess()) {
            return resp.getErrorMsg();
        }
        return "\u4e0a\u67b6\u6210\u529f";
    }

    @AnIntercept(value={"chkAjax"})
    public String doBatchRepost(HttpRequest request, String numIidstr) throws Exception {
        long[] numIids;
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        int successNum = 0;
        int failureNum = 0;
        long[] lArray = numIids = Arrays.toLongArray((String)numIidstr, (String)",");
        int n = numIids.length;
        int n2 = 0;
        while (n2 < n) {
            long numIid = lArray[n2];
            ItemSellerGetResponse4_24625 resp0 = TaobaoService.getItemService().getItem(sessionUser.getNick(), sessionUser.getSessionId(), numIid);
            if (!resp0.isSuccess()) {
                ++failureNum;
            } else {
                int num = resp0.getItem().getNum();
                if (num <= 0 || !resp0.getItem().isInstock()) {
                    ++failureNum;
                } else {
                    ItemUpdateListingResponse4_32 resp1 = TaobaoService.getItemService().doAutoRepost(sessionUser.getNick(), sessionUser.getSessionId(), numIid, num);
                    if (!resp1.isSuccess()) {
                        ++failureNum;
                    } else {
                        ++successNum;
                    }
                }
            }
            ++n2;
        }
        return "\u6279\u5904\u7406\u5b8c\u6210\uff0c\u5171[" + numIids.length + "]\u4e2a\uff0c\u6210\u529f[" + successNum + "]\u4e2a\uff0c\u5931\u8d25[" + failureNum + "]\u4e2a";
    }
}

