/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.message;

import net.redxyz.top.message.ErrorResponse;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Validates;

public abstract class TaobaoResponse {
    private ErrorResponse error;
    private String responseText;

    protected abstract void buildResponse(String var1);

    public void buildResponseError(int code, String msg, String subCode, String subMsg, String args) {
        this.error = new ErrorResponse(code, msg, subCode, subMsg, args);
    }

    public void buildResponseText(String responseText) {
        this.responseText = responseText;
        if (responseText.indexOf("error_rsp") != -1) {
            responseText = responseText.substring(13, responseText.length() - 1);
            this.error = (ErrorResponse)Jsons.toObject((String)responseText, ErrorResponse.class);
        } else if (responseText.indexOf("error_response") != -1) {
            int code = Jsons.getInt((String)responseText, (String)"code");
            String msg = Jsons.getString((String)responseText, (String)"msg");
            String subCode = Jsons.getString((String)responseText, (String)"sub_code");
            String subMsg = Jsons.getString((String)responseText, (String)"sub_msg");
            String args = Jsons.getArray((String)responseText, (String)"arg");
            this.error = new ErrorResponse(code, msg, subCode, subMsg, args);
        } else {
            this.buildResponse(responseText);
        }
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public int getErrorCode() {
        if (this.error == null) {
            return 0;
        }
        return this.error.getCode();
    }

    public String getSubCode() {
        if (this.error == null) {
            return "unknown";
        }
        return this.error.getSubCode();
    }

    public String getErrorMsg() {
        if (this.error == null) {
            return "unknown";
        }
        if (!Validates.isEmpty((String)this.error.getSubMsg())) {
            return this.error.getSubMsg();
        }
        return this.error.getMsg();
    }

    public boolean isConnectionReset() {
        if (this.error == null) {
            return false;
        }
        return "Connection reset".equals(this.error.getMsg());
    }

    public boolean isBusinessRateFail() {
        if (this.error == null) {
            return false;
        }
        String subCode = this.error.getSubCode();
        return "isv.rate-service-error:bussiness".equals(subCode);
    }

    public boolean isUserFail() {
        return this.error == null ? false : this.error.isUserFail();
    }

    public boolean isW2() {
        if (this.error == null) {
            return false;
        }
        String subCode = this.error.getSubCode();
        return "isv.w2-security-authorize-invalid".equals(subCode);
    }

    public boolean isTaobaoFail() {
        return this.error == null ? false : this.error.isTaobaoFail();
    }

    public boolean isGetFail() {
        return this.error == null ? false : this.error.isGetFail();
    }

    public boolean isUpdateFail() {
        return this.error == null ? false : this.error.isUpdateFail();
    }

    public boolean isNotExist() {
        return this.error == null ? false : this.error.isNotExist();
    }

    public ErrorResponse getError() {
        return this.error;
    }

    public String toString() {
        if (this.error != null) {
            return this.error.toString();
        }
        return this.responseText;
    }
}

