/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.ServiceException;
import com.aliyun.mq.http.common.auth.ServiceCredentials;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.model.AsyncCallback;
import com.aliyun.mq.http.model.AsyncResult;
import com.aliyun.mq.http.model.Message;
import com.aliyun.mq.http.model.action.AckMessageAction;
import com.aliyun.mq.http.model.action.ConsumeMessageAction;
import com.aliyun.mq.http.model.request.AckMessageRequest;
import com.aliyun.mq.http.model.request.ConsumeMessageRequest;
import java.net.URI;
import java.util.List;

public class MQConsumer {
    private final ServiceClient serviceClient;
    private final String topicURL;
    private final String topicName;
    private final String consumer;
    private final String messageTag;
    private final ServiceCredentials credentials;
    private final URI endpoint;
    private String instanceId;

    protected MQConsumer(String instanceId, String topicName, String consumer, String messageTag, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.instanceId = instanceId;
        this.serviceClient = client;
        this.credentials = credentials;
        this.endpoint = endpoint;
        String uri = endpoint.toString();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        this.topicURL = uri = uri + "topics/" + topicName;
        this.topicName = topicName;
        this.consumer = consumer;
        if (this.consumer == null || this.consumer.isEmpty()) {
            throw new RuntimeException("Consumer can't be empty");
        }
        this.messageTag = messageTag;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public String getMessageTag() {
        return this.messageTag;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<Message> consumeMessage(int num, int pollingSecond) throws ServiceException, ClientException {
        ConsumeMessageRequest request = new ConsumeMessageRequest();
        request.setConsumer(this.consumer);
        request.setBatchSize(num);
        request.setTag(this.messageTag);
        request.setWaitSeconds(pollingSecond);
        request.setInstanceId(this.instanceId);
        try {
            ConsumeMessageAction action = new ConsumeMessageAction(this.serviceClient, this.credentials, this.endpoint);
            request.setRequestPath(this.topicURL + "/" + "messages");
            return (List)action.executeWithCustomHeaders(request, null);
        }
        catch (ServiceException e) {
            if ("MessageNotExist".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    public AsyncResult<List<Message>> asyncConsumeMessage(int num, int pollingSecond, AsyncCallback<List<Message>> callback) {
        ConsumeMessageRequest request = new ConsumeMessageRequest();
        request.setConsumer(this.consumer);
        request.setBatchSize(num);
        request.setTag(this.messageTag);
        request.setWaitSeconds(pollingSecond);
        request.setInstanceId(this.instanceId);
        ConsumeMessageAction action = new ConsumeMessageAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return action.executeWithCustomHeaders(request, callback, null);
    }

    public void ackMessage(List<String> receiptHandles) throws ServiceException, ClientException {
        AckMessageAction action = new AckMessageAction(this.serviceClient, this.credentials, this.endpoint);
        AckMessageRequest request = new AckMessageRequest();
        request.setRequestPath(this.topicURL + "/" + "messages");
        request.setConsumer(this.consumer);
        request.setReceiptHandles(receiptHandles);
        request.setInstanceId(this.instanceId);
        action.executeWithCustomHeaders(request, null);
    }

    public AsyncResult<Void> asyncAckMessage(List<String> receiptHandles, AsyncCallback<Void> callback) throws ServiceException, ClientException {
        AckMessageAction action = new AckMessageAction(this.serviceClient, this.credentials, this.endpoint);
        AckMessageRequest request = new AckMessageRequest();
        request.setRequestPath(this.topicURL + "/" + "messages");
        request.setConsumer(this.consumer);
        request.setReceiptHandles(receiptHandles);
        request.setInstanceId(this.instanceId);
        return action.executeWithCustomHeaders(request, callback, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MQConsumer{");
        sb.append("topicName='").append(this.topicName).append('\'');
        sb.append(", consumer='").append(this.consumer).append('\'');
        sb.append(", messageTag='").append(this.messageTag).append('\'');
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", instanceId='").append(this.instanceId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

