/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.nettyservice;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yangcai.messagebox.config.MessageBoxConfig;
import yangcai.messagebox.handler.MessageChannelHandler;

@Component
public class NettyServer {
    private static final Log log = LogFactory.getLog(NettyServer.class);
    private static MessageBoxConfig config;
    private static volatile NettyServer nettyServer;

    private NettyServer() {
    }

    @Autowired
    public void setMessageBoxConfig(MessageBoxConfig config) {
        NettyServer.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    private void init() {
        if (nettyServer != null) return;
        Class<NettyServer> clazz = NettyServer.class;
        synchronized (NettyServer.class) {
            if (nettyServer == null) {
                nettyServer = new NettyServer();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        nettyServer.startServer();
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }).start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer() throws Exception {
        NioEventLoopGroup boss = new NioEventLoopGroup();
        NioEventLoopGroup work = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)work).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(30L, 90L, 120L, TimeUnit.SECONDS)});
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new MessageChannelHandler()});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            log.info((Object)("\u3010\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f========\u7aef\u53e3\uff1a" + config.getPort() + "\u3011"));
            Channel channel = bootstrap.bind(config.getPort().intValue()).sync().channel();
            channel.closeFuture().sync();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            boss.shutdownGracefully();
            work.shutdownGracefully();
        }
    }
}

