/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.TiffImage;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.pathresources.PathResource;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUndefinedType;
import com.aspose.imaging.imageoptions.TiffOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.aK.av;
import com.aspose.imaging.internal.aK.bN;
import com.aspose.imaging.internal.aK.bq;
import com.aspose.imaging.internal.aK.by;
import com.aspose.imaging.internal.aK.cs;
import com.aspose.imaging.internal.aK.m;
import com.aspose.imaging.internal.hL.f;
import com.aspose.imaging.internal.ho.e;
import com.aspose.imaging.internal.ho.g;
import com.aspose.imaging.internal.ho.h;
import com.aspose.imaging.internal.hp.w;
import com.aspose.imaging.internal.iW.o;
import com.aspose.imaging.internal.jo.i;
import com.aspose.imaging.internal.lz.aD;
import com.aspose.imaging.internal.lz.aV;
import com.aspose.imaging.internal.lz.bc;
import com.aspose.imaging.internal.mm.l;
import com.aspose.imaging.internal.qB.d;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class TiffFrame
extends RasterCachedImage {
    private TiffOptions j;
    private int k;
    private int l;
    private ExifData m;
    private final com.aspose.imaging.internal.hP.b n;
    private boolean o;

    public TiffFrame(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    TiffFrame(Stream stream) {
        this(stream, new TiffOptions(0));
    }

    public static TiffFrame g(Stream stream) {
        return new TiffFrame(stream);
    }

    public TiffFrame(InputStream inputStream, TiffOptions tiffOptions) {
        this(Stream.fromJava(inputStream), tiffOptions);
    }

    TiffFrame(Stream stream, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bN(stream), tiffOptions);
    }

    public TiffFrame(String string) {
        this(string, new TiffOptions(0));
    }

    public TiffFrame(String string, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bN(string), tiffOptions);
    }

    public TiffFrame(RasterImage rasterImage) {
        this(rasterImage, new TiffOptions(0));
    }

    public TiffFrame(RasterImage rasterImage, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bN(rasterImage), tiffOptions);
    }

    public TiffFrame(TiffOptions tiffOptions, int n2, int n3) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.j = tiffOptions;
        this.l = n2;
        this.k = n3;
    }

    private TiffFrame(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.j = tiffOptions;
        this.l = n2;
        this.k = n3;
        if (iRasterImageArgb32PixelLoader != null) {
            this.setDataLoader(iRasterImageArgb32PixelLoader);
        }
    }

    private TiffFrame(TiffOptions tiffOptions) {
        this.setUseRawData(false);
        this.a(new com.aspose.imaging.internal.hM.a(this));
        this.n = new com.aspose.imaging.internal.hP.b(tiffOptions);
    }

    @Override
    public Color getBackgroundColor() {
        this.b(com.aspose.imaging.internal.iW.m.c());
        return this.getFrameOptions().c();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getFrameOptions().a(color);
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    @Override
    public boolean hasAlpha() {
        this.b(com.aspose.imaging.internal.iW.m.c());
        TiffOptions tiffOptions = this.getFrameOptions();
        return tiffOptions.isExtraSamplesPresent() && tiffOptions.getAlphaStorage() != 0;
    }

    @Override
    public boolean hasTransparentColor() {
        this.b(com.aspose.imaging.internal.iW.m.c());
        TiffOptions tiffOptions = this.getFrameOptions();
        return tiffOptions.isExtraSamplesPresent() && tiffOptions.getAlphaStorage() == 1;
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        this.b(com.aspose.imaging.internal.iW.m.c());
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.iW.m.c());
        return this.getFrameOptions().getBitsPerPixel();
    }

    public TiffOptions getFrameOptions() {
        this.verifyNotDisposed();
        this.b(com.aspose.imaging.internal.iW.m.c());
        return this.j;
    }

    @Override
    public int getHeight() {
        return this.k;
    }

    @Override
    public int getWidth() {
        return this.l;
    }

    public ExifData getExifData() {
        this.b(com.aspose.imaging.internal.iW.m.c());
        return this.m;
    }

    public void setExifData(ExifData exifData) {
        this.b(com.aspose.imaging.internal.iW.m.c());
        this.m = exifData;
    }

    @Override
    public double getHorizontalResolution() {
        TiffRational tiffRational = null;
        if (this.j != null) {
            tiffRational = this.j.getXresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        this.b(com.aspose.imaging.internal.iW.m.c());
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        if (this.j != null) {
            this.j.setXresolution(TiffRational.approximateFraction(d2));
        } else {
            super.setHorizontalResolution(d2);
        }
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    @Override
    public double getVerticalResolution() {
        TiffRational tiffRational = null;
        if (this.j != null) {
            tiffRational = this.j.getYresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        this.b(com.aspose.imaging.internal.iW.m.c());
        return super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double d2) {
        if (this.j != null) {
            this.j.setYresolution(TiffRational.approximateFraction(d2));
        } else {
            super.setVerticalResolution(d2);
        }
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    public java.util.List<PathResource> getPathResources() {
        return List.toJava(this.n());
    }

    public List<PathResource> n() {
        this.b(com.aspose.imaging.internal.iW.m.c());
        return this.n.a();
    }

    public void setPathResources(java.util.List<PathResource> list) {
        this.a(List.fromJava(list));
    }

    public void a(List<PathResource> list) {
        this.b(com.aspose.imaging.internal.iW.m.c());
        this.n.a(list);
    }

    @Override
    public i h() {
        return this.getContainer() != null ? this.getContainer().h() : super.h();
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        return this.getFrameOptions();
    }

    public void alignResolutions() {
        TiffDataType tiffDataType = this.getFrameOptions().getTagByType(282);
        TiffDataType tiffDataType2 = this.getFrameOptions().getTagByType(283);
        if (tiffDataType != null && tiffDataType2 != null) {
            TiffRational[] tiffRationalArray = com.aspose.imaging.internal.qB.d.c(tiffDataType.getValue(), TiffRational[].class);
            TiffRational[] tiffRationalArray2 = com.aspose.imaging.internal.qB.d.c(tiffDataType2.getValue(), TiffRational[].class);
            TiffRational tiffRational = tiffRationalArray[0];
            TiffRational tiffRational2 = tiffRationalArray2[0];
            if ((tiffRational.getNominator() & 0xFFFFFFFFL) != (tiffRational2.getNominator() & 0xFFFFFFFFL) || (tiffRational.getDenominator() & 0xFFFFFFFFL) != (tiffRational2.getDenominator() & 0xFFFFFFFFL)) {
                if (tiffRational.getValue() > tiffRational2.getValue()) {
                    double d2 = tiffRational.getValueD() / tiffRational2.getValueD();
                    int n2 = com.aspose.imaging.internal.qB.d.e((double)this.k * d2);
                    this.resize(this.l, n2, 6);
                    tiffRationalArray2[0] = new TiffRational(tiffRational.getNominator(), tiffRational.getDenominator());
                } else {
                    double d3 = tiffRational2.getValueD() / tiffRational.getValueD();
                    int n3 = com.aspose.imaging.internal.qB.d.e((double)this.l * d3);
                    this.resize(n3, this.k, 6);
                    tiffRationalArray[0] = new TiffRational(tiffRational2.getNominator(), tiffRational2.getDenominator());
                }
                this.d(true);
            }
        }
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    public static TiffFrame copyFrame(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        TiffOptions tiffOptions = (TiffOptions)((Object)com.aspose.imaging.internal.qB.d.a(tiffFrame.getFrameOptions().deepClone(), TiffOptions.class));
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.l, tiffFrame.k);
        tiffFrame2.a(tiffFrame.h(), false);
        tiffFrame2.a(tiffFrame.i);
        com.aspose.imaging.internal.ho.f f2 = (com.aspose.imaging.internal.ho.f)((Object)com.aspose.imaging.internal.qB.d.a(tiffFrame.getDataLoader(), com.aspose.imaging.internal.ho.f.class));
        if (f2 != null) {
            com.aspose.imaging.internal.ho.f f3 = f2.c();
            f3.a(tiffFrame2);
            tiffFrame2.setDataLoader(f3);
            tiffFrame2.o = true;
        } else if (tiffFrame.getDataLoader() != null) {
            tiffFrame2.setDataLoader(tiffFrame.getDataLoader());
        } else {
            tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds(), new by(tiffFrame2));
        }
        if (tiffFrame.xmpData != null) {
            tiffFrame2.xmpData = tiffFrame.xmpData.c();
        }
        tiffFrame.b(com.aspose.imaging.internal.iW.m.c());
        tiffFrame2.a(tiffFrame);
        return tiffFrame2;
    }

    public static TiffFrame createFrameFrom(TiffFrame tiffFrame, TiffOptions tiffOptions) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.l, tiffFrame.k);
        tiffFrame2.a(tiffFrame.h(), false);
        tiffFrame2.a(tiffFrame.i);
        tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds(), new by(tiffFrame2));
        tiffFrame.b(com.aspose.imaging.internal.iW.m.c());
        tiffFrame2.a(tiffFrame);
        return tiffFrame2;
    }

    public void r() {
        com.aspose.imaging.internal.ho.f f2 = (com.aspose.imaging.internal.ho.f)((Object)com.aspose.imaging.internal.qB.d.a(this.getDataLoader(), com.aspose.imaging.internal.ho.f.class));
        if (f2 != null) {
            f2.a((TiffOptions)((Object)com.aspose.imaging.internal.qB.d.a(this.getFrameOptions().deepClone(), TiffOptions.class)));
        }
    }

    public static TiffFrame a(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new TiffFrame(tiffOptions, n2, n3, iRasterImageArgb32PixelLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, TiffStreamWriter tiffStreamWriter, boolean bl2, TiffOptions tiffOptions, ExifData exifData, XmpPacketWrapper xmpPacketWrapper, Rectangle rectangle) {
        TiffOptions tiffOptions2;
        TiffOptions tiffOptions3 = tiffOptions2 = tiffOptions;
        synchronized (tiffOptions3) {
            tiffOptions = (TiffOptions)tiffOptions2.deepClone();
        }
        try {
            Object object;
            long l2;
            tiffOptions.validate();
            if (rectangle.isEmpty()) {
                rectangle = rasterImage.getBounds();
            }
            long l3 = rectangle.getWidth();
            tiffOptions.setImageWidth(l3);
            long l4 = rectangle.getHeight();
            tiffOptions.setImageLength(l4);
            boolean bl3 = tiffOptions.isTiled();
            if (bl3) {
                l2 = tiffOptions.getTileWidth();
                tiffOptions.setTileWidth((l2 & 0xFFFFFFFFL) > 0L ? l2 : l3);
                long l5 = tiffOptions.getTileLength();
                tiffOptions.setTileLength((l5 & 0xFFFFFFFFL) > 0L ? l5 : l4);
                tiffOptions.setTileOffsets(new long[]{0L});
                tiffOptions.setTileByteCounts(new long[]{0L});
            } else {
                l2 = tiffOptions.getRowsPerStrip();
                tiffOptions.setRowsPerStrip((l2 & 0xFFFFFFFFL) > 0L && (l2 & 0xFFFFFFFFL) <= (l4 & 0xFFFFFFFFL) ? l2 : l4);
                tiffOptions.setStripByteCounts(new long[]{0L});
                tiffOptions.setStripOffsets(new long[]{0L});
            }
            int n2 = tiffOptions.getPhotometric();
            int n3 = tiffOptions.getCompression();
            if (n3 == 7 || n3 == 6) {
                if (com.aspose.imaging.internal.aK.m.a(rasterImage)) {
                    if (bl3) {
                        tiffOptions.setTileWidth(l3);
                        tiffOptions.setTileLength(l4);
                    } else {
                        tiffOptions.setRowsPerStrip(l4);
                    }
                }
                if (!tiffOptions.isTagPresent(530)) {
                    int[] nArray;
                    if (n2 == 6) {
                        int[] nArray2 = new int[2];
                        nArray2[0] = 2;
                        nArray = nArray2;
                        nArray2[1] = 2;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = 1;
                        nArray = nArray3;
                        nArray3[1] = 1;
                    }
                    tiffOptions.setYCbCrSubsampling(nArray);
                }
            }
            if (n2 == 6 && !tiffOptions.isTagPresent(530)) {
                tiffOptions.setYCbCrSubsampling(new int[]{2, 2});
            }
            com.aspose.imaging.internal.hs.a a2 = com.aspose.imaging.internal.hq.b.a(tiffOptions);
            w w2 = com.aspose.imaging.internal.hq.a.a(tiffOptions, rasterImage, rectangle.Clone());
            com.aspose.imaging.internal.hr.a a3 = new com.aspose.imaging.internal.hr.a(w2, a2, true);
            a3.a(tiffOptions);
            tiffOptions.setTags(w2.a(false));
            TiffDataType[] tiffDataTypeArray = null;
            TiffDataType[] tiffDataTypeArray2 = null;
            if (exifData != null) {
                tiffDataTypeArray = exifData.getExifTags();
                tiffDataTypeArray2 = exifData.getGPSTags();
            }
            TiffDataType[] tiffDataTypeArray3 = null;
            if (tiffOptions.getXmpData() != null) {
                xmpPacketWrapper = tiffOptions.getXmpData();
            }
            if (xmpPacketWrapper != null) {
                object = new TiffUndefinedType(700);
                String string = xmpPacketWrapper.b();
                byte[] byArray = com.aspose.imaging.internal.mm.l.x().c(string);
                ((TiffUndefinedType)object).setData(byArray);
                tiffDataTypeArray3 = new TiffDataType[]{object};
            }
            object = new h(tiffOptions.getTags(), tiffDataTypeArray, tiffDataTypeArray2, tiffDataTypeArray3, tiffOptions.isDisableIccExport(), true);
            long l6 = tiffStreamWriter.getPosition();
            long l7 = ((h)object).a(tiffStreamWriter);
            a a4 = new a(tiffOptions, l6 + l7 & 0xFFFFFFFFL, tiffStreamWriter, rectangle.getWidth(), rectangle.getHeight(), rasterImage.h(), rasterImage.i);
            try {
                Object object2;
                Rectangle rectangle2 = Rectangle.intersect(rectangle, rasterImage.getBounds());
                bq bq2 = new bq(rasterImage, rectangle, a4, rasterImage.getPalette(), true);
                try {
                    if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                        boolean bl4;
                        boolean bl5 = bl4 = rasterImage.isRawDataAvailable() && rasterImage.getUseRawData() && n2 == 5 && rasterImage.getRawDataFormat() != null && (PixelDataFormat.op_Equality(rasterImage.getRawDataFormat(), PixelDataFormat.getCmyka()) || PixelDataFormat.op_Equality(rasterImage.getRawDataFormat(), PixelDataFormat.getCmyk()));
                        if (bl4) {
                            object2 = new RawDataSettings();
                            ((RawDataSettings)object2).setPixelDataFormat(PixelDataFormat.getCmyk());
                            ((RawDataSettings)object2).setLineSize(((RawDataSettings)object2).getPixelDataFormat().getChannelsCount() * rasterImage.getWidth());
                            b b2 = new b(a4, (RawDataSettings)object2);
                            rasterImage.loadRawData(rasterImage.getBounds().Clone(), (RawDataSettings)object2, b2);
                        } else {
                            object2 = bq2;
                            if (rasterImage.hasTransparentColor()) {
                                object2 = new cs(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), (IPartialArgb32PixelLoader)object2);
                            }
                            if (rasterImage.hasAlpha() && tiffOptions.getAlphaStorage() == 0) {
                                object2 = new com.aspose.imaging.internal.aP.b(tiffOptions.c().toArgb(), (IPartialArgb32PixelLoader)object2);
                            }
                            rasterImage.a(rectangle2, (IPartialArgb32PixelLoader)object2, true);
                        }
                    }
                    bq2.a();
                }
                finally {
                    bq2.close();
                }
                List<TiffDataType> list = new List<TiffDataType>();
                if (bl3) {
                    tiffOptions.setTileByteCounts(a4.b());
                    tiffOptions.setTileOffsets(a4.a());
                    list.addItem(tiffOptions.getTagByType(322));
                    list.addItem(tiffOptions.getTagByType(323));
                    list.addItem(tiffOptions.getTagByType(325));
                    list.addItem(tiffOptions.getTagByType(324));
                } else {
                    tiffOptions.setStripByteCounts(a4.b());
                    tiffOptions.setStripOffsets(a4.a());
                    tiffOptions.setRowsPerStrip(a4.c().c());
                    list.addItem(tiffOptions.getTagByType(278));
                    list.addItem(tiffOptions.getTagByType(279));
                    list.addItem(tiffOptions.getTagByType(273));
                }
                if (n2 == 5 && tiffOptions.isTagPresent(317)) {
                    object2 = (TiffShortType)((Object)com.aspose.imaging.internal.qB.d.a(tiffOptions.getTagByType(317), TiffShortType.class));
                    ((TiffShortType)object2).getValues()[0] = 1;
                    list.addItem((TiffDataType)object2);
                }
                if (n3 == 6) {
                    tiffOptions.setCompression(7);
                }
                ((h)object).a(list);
                long l8 = a4.c().d();
                Object object3 = tiffStreamWriter.getSyncRoot();
                synchronized (object3) {
                    tiffStreamWriter.setPosition(l6);
                    ((h)object).a(tiffStreamWriter, l8, bl2);
                }
            }
            finally {
                a4.dispose();
            }
        }
        finally {
            tiffOptions.dispose();
        }
    }

    @Override
    public void a(i i2, boolean bl2) {
        if (this.getContainer() != null) {
            throw new NotSupportedException("Setting a memory manager for an image-related frame is not allowed.");
        }
        super.a(i2, bl2);
    }

    @Override
    public IColorPalette p() {
        IColorPalette iColorPalette = super.p();
        if (iColorPalette == null && this.getFrameOptions() != null) {
            return this.getFrameOptions().getPalette();
        }
        return null;
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2 = super.a(iColorPalette);
        if (!bl2) {
            TiffOptions tiffOptions = this.getFrameOptions();
            boolean bl3 = bl2 = tiffOptions.getPalette() != null;
            if (bl2) {
                tiffOptions.setPalette(iColorPalette);
            }
        }
        return bl2;
    }

    private void s() {
        com.aspose.imaging.internal.ho.f f2;
        if (this.o && (f2 = (com.aspose.imaging.internal.ho.f)((Object)com.aspose.imaging.internal.qB.d.a(this.getDataLoader(), com.aspose.imaging.internal.ho.f.class))) != null) {
            f2.dispose();
        }
    }

    @Override
    protected void releaseReferences() {
        this.s();
        super.releaseReferences();
    }

    @Override
    protected void releaseManagedResources() {
        this.s();
        super.releaseManagedResources();
        this.j = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        TiffImage tiffImage = (TiffImage)((Object)com.aspose.imaging.internal.qB.d.a(this.getContainer(), TiffImage.class));
        int n2 = tiffImage == null ? 18761 : tiffImage.getByteOrder();
        bc bc2 = tiffImage == null ? com.aspose.imaging.internal.qB.d.a(TiffImage.class) : aD.b(tiffImage);
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            TiffStreamWriter tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, n2, bc2 != com.aspose.imaging.internal.qB.d.a(TiffImage.class));
            TiffFrame.a(this, tiffStreamWriter, true, this.j, this.m, this.xmpData, this.getBounds());
        }
        finally {
            streamContainer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int n2, int n3, int n4) {
        try {
            Object object = this.c;
            synchronized (object) {
                try {
                    av av2 = this.a();
                    if (av2 != null) {
                        av2.a(n2, n3, n4);
                    } else {
                        this.a(n2, n3, n4);
                        this.b(com.aspose.imaging.internal.iW.m.c());
                    }
                    this.d(true);
                }
                finally {
                    this.d(true);
                }
            }
        }
        finally {
            this.c(true);
        }
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        av av2 = this.a();
        if (av2 != null) {
            av2.a(f2, bl2, color);
        } else {
            this.a(f2, bl2, color, false);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        if (this.a() != null) {
            this.a().a(rectangle.Clone());
        } else {
            this.a(rectangle.Clone());
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.l = n2;
        this.k = n3;
        this.d(true);
    }

    private void a(bN bN2, TiffOptions tiffOptions) {
        this.setDataLoader(bN2);
        this.j = tiffOptions;
        this.l = bN2.a().getWidth();
        this.k = bN2.a().getHeight();
        this.setPalette(bN2.a().getPalette());
        TiffImage tiffImage = (TiffImage)((Object)com.aspose.imaging.internal.qB.d.a(bN2.a(), TiffImage.class));
        if (tiffImage != null) {
            this.m = tiffImage.getExifData();
            this.xmpData = tiffImage.getXmpData();
            this.a(tiffImage.i);
        }
    }

    private void a(TiffFrame tiffFrame) {
        if (!com.aspose.imaging.internal.iW.o.a(this.i, tiffFrame.i)) {
            this.i = tiffFrame.i;
        }
    }

    private static class b
    implements IPartialRawDataLoader {
        private final a a;
        private final RawDataSettings b;

        public b(a a2, RawDataSettings rawDataSettings) {
            this.a = a2;
            this.b = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.process(rectangle, byArray, point, point2, null);
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            PixelDataFormat pixelDataFormat = this.b.getPixelDataFormat();
            if (!PixelDataFormat.op_Equality(pixelDataFormat, PixelDataFormat.getCmyk()) && !PixelDataFormat.op_Equality(pixelDataFormat, PixelDataFormat.getCmyka())) {
                throw new NotSupportedException(aV.a("PixelDataFormat {0} does not support raw data loading.", new Object[]{this.b.getPixelDataFormat()}));
            }
            this.a.a(rectangle, byArray, this.b);
        }
    }

    private static class a
    extends DisposableObject
    implements IPartialArgb32PixelLoader {
        private final c a;
        private e b;
        private RawDataSettings c;

        public a(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3, i i2, o o2) {
            this.b = com.aspose.imaging.internal.ho.g.a(tiffOptions, n2, n3, i2, o2);
            long l3 = tiffOptions.getRowsPerStrip();
            this.a = new c(tiffOptions, tiffStreamWriter, l2, (long)this.b.i() & 0xFFFFFFFFL, l3, this.b.j().getFillOrder() == 2);
        }

        public long[] a() {
            return this.a.a();
        }

        public long[] b() {
            return this.a.b();
        }

        public c c() {
            return this.a;
        }

        public RawDataSettings d() {
            return this.c;
        }

        public void a(RawDataSettings rawDataSettings) {
            this.c = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            try {
                this.b.a(nArray, rectangle, this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        public void a(Rectangle rectangle, byte[] byArray, RawDataSettings rawDataSettings) {
            try {
                this.b.a(byArray, rectangle, this.a, rawDataSettings);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        @Override
        protected void releaseManagedResources() {
            if (this.b != null) {
                this.b.dispose();
                this.b = null;
            }
            super.releaseManagedResources();
        }
    }

    private static class c
    implements com.aspose.imaging.internal.iS.a {
        private final TiffStreamWriter a;
        private final long b;
        private final long[] c;
        private final long[] d;
        private final long e;
        private final boolean f;
        private long g;
        private long h;
        private long i;
        private long j;

        public c(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            long l5;
            this.f = bl2;
            this.a = tiffStreamWriter;
            this.g = l2;
            if (tiffOptions.isTiled()) {
                this.b = tiffOptions.getTileLength();
                int n2 = com.aspose.imaging.internal.hL.f.a(tiffOptions.getImageWidth() & 0xFFFFFFFFL, tiffOptions.getTileWidth() & 0xFFFFFFFFL);
                int n3 = com.aspose.imaging.internal.hL.f.a(tiffOptions.getImageLength() & 0xFFFFFFFFL, tiffOptions.getTileLength() & 0xFFFFFFFFL);
                l5 = (long)n2 * (long)n3 & 0xFFFFFFFFL;
            } else {
                this.b = l4 = (l4 & 0xFFFFFFFFL) == 0L ? l3 : l4;
                l5 = (l3 & 0xFFFFFFFFL) / (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                if (((l3 & 0xFFFFFFFFL) % (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL) != 0L) {
                    ++l5;
                }
            }
            l5 = tiffOptions.getPlanarConfiguration() == 1 ? l5 : (l5 & 0xFFFFFFFFL) * (long)(tiffOptions.getSamplesPerPixel() & 0xFFFF) & 0xFFFFFFFFL;
            this.c = new long[(int)(l5 & 0xFFFFFFFFL)];
            this.d = new long[(int)(l5 & 0xFFFFFFFFL)];
            this.a()[0] = com.aspose.imaging.internal.qB.d.h(l2, 10);
            this.e = tiffOptions.isTiled() ? (long)com.aspose.imaging.internal.hL.f.d(l3 & 0xFFFFFFFFL, tiffOptions.getTileLength() & 0xFFFFFFFFL) & 0xFFFFFFFFL : l3;
        }

        public long[] a() {
            return this.c;
        }

        public long[] b() {
            return this.d;
        }

        public long c() {
            return this.b;
        }

        public long d() {
            return this.g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processBuffer(byte[] byArray, int n2) {
            if (this.f) {
                com.aspose.imaging.internal.ho.b.a(byArray, 0, n2);
            }
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setPosition(this.g);
                this.a.write(byArray, 0, n2);
            }
            this.g = this.g + (long)n2 & 0xFFFFFFFFL;
            this.j = (this.j & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void a(MemoryStream memoryStream) {
            int n2 = (int)memoryStream.getLength();
            if (this.f) {
                byte[] byArray = new byte[n2];
                memoryStream.read(byArray, 0, n2);
                com.aspose.imaging.internal.ho.b.a(byArray, 0, n2);
                Object object = this.a.getSyncRoot();
                synchronized (object) {
                    this.a.setPosition(this.g);
                    this.a.write(byArray, 0, n2);
                }
            }
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setPosition(this.g);
                this.a.a(memoryStream);
            }
            this.g += (long)n2;
            this.j = (this.j & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }

        @Override
        public void finishRow() {
            this.finishRows(1);
        }

        @Override
        public void finishRows(int n2) {
            this.h = (this.h & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            if (((this.h & 0xFFFFFFFFL) % (this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L || ((this.h & 0xFFFFFFFFL) % (this.e & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L) {
                this.d[(int)this.i++] = this.j;
                if ((this.i & 0xFFFFFFFFL) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }
    }
}

