/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormatByFile(String filePath) {
        ImageInputStream input = null;
        try {
            input = ImageIO.createImageInputStream(new File(filePath));
            String string = ImageUtil.getImageFormat(input);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormatByBytes(byte[] content) {
        ImageInputStream input = null;
        try {
            input = new MemoryCacheImageInputStream(new ByteArrayInputStream(content));
            String string = ImageUtil.getImageFormat(input);
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormat(ImageInputStream input) {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        String format = "unknown";
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                format = reader.getFormatName();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                reader.dispose();
            }
        }
        return format;
    }

    public static HashMap<String, Integer> getImageInfoByFile(String filePath) {
        try {
            ImageInputStream input = ImageIO.createImageInputStream(new File(filePath));
            return ImageUtil.getImageInfo(input);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, Integer> getImageInfoByBytes(byte[] content) {
        MemoryCacheImageInputStream input = new MemoryCacheImageInputStream(new ByteArrayInputStream(content));
        return ImageUtil.getImageInfo(input);
    }

    public static HashMap<String, Integer> getImageInfo(ImageInputStream input) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        BufferedImage buff = null;
        try {
            buff = ImageIO.read(input);
            map.put("width", buff.getWidth());
            map.put("height", buff.getHeight());
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

