/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.uploadlarge;

import java.io.File;
import java.io.RandomAccessFile;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.enumerated.LetterCase;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.MD5;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.uploadlarge.ZulBootstrap;
import org.zhiqim.uploadlarge.ZulConstants;
import org.zhiqim.uploadlarge.ZulDao;
import org.zhiqim.uploadlarge.dbo.UpllChunk;
import org.zhiqim.uploadlarge.dbo.UpllFile;

public class ZulUploader
implements ZulConstants {
    public static UpllFile getFile(HttpRequest request, String fileId) throws Exception {
        Selector selector = new Selector("fileId", (Object)fileId);
        selector.addReplace("id", request.getNestAttributeString("orm.id"));
        return (UpllFile)ZulBootstrap.table(request).item(UpllFile.class, selector);
    }

    public static UpllFile queryFile(HttpRequest request, String fileMd5) throws Exception {
        Selector selector = new Selector("fileMd5", (Object)fileMd5);
        selector.addReplace("id", request.getNestAttributeString("orm.id"));
        return (UpllFile)ZulBootstrap.table(request).item(UpllFile.class, selector);
    }

    public static UpllChunk queryChunk(HttpRequest request, String fileMd5, int chunkSize) throws Exception {
        Selector selector = new Selector("fileMd5", (Object)fileMd5);
        selector.addMust("chunkSize", (Object)chunkSize);
        selector.addReplace("id", request.getNestAttributeString("orm.id"));
        return (UpllChunk)ZulBootstrap.table(request).item(UpllChunk.class, selector);
    }

    public static boolean saveChunkData(HttpRequest request, byte[] data, String fileRootDir, String uploadRootDir, String fileDir, String fileName, String fileMd5, long fileLength, int chunkSize, int chunkNum, int chunkNo) throws Exception {
        String filePath = null;
        if (chunkNo == 1) {
            filePath = ZulUploader.getChunkFilePath(fileDir, fileMd5);
            fileName = Files.getFileName((String)fileName);
        } else {
            UpllChunk chunk = ZulUploader.queryChunk(request, fileMd5, chunkSize);
            if (chunk == null) {
                return false;
            }
            filePath = chunk.getFilePath();
        }
        RandomAccessFile file = new RandomAccessFile(new File(filePath), "rw");
        if (chunkNo == 1) {
            file.setLength(fileLength);
        }
        file.seek((chunkNo - 1) * chunkSize);
        file.write(data);
        file.close();
        if (chunkNo == 1) {
            UpllChunk chunk = new UpllChunk();
            chunk.setId(request.getNestAttributeString("orm.id"));
            chunk.setChunkNo(chunkNo);
            chunk.setChunkNum(chunkNum);
            chunk.setChunkSize(chunkSize);
            chunk.setChunkTime(DateTimes.getDateTimeString());
            chunk.setFileExt(Files.getFileExt((String)fileName));
            chunk.setFileMd5(fileMd5);
            chunk.setFileName(fileName);
            chunk.setFilePath(filePath);
            chunk.setFileRootDir(fileRootDir);
            chunk.setFileUploadPath(Strings.removeStartsWith((String)filePath, (String)Strings.removeEndsWith((String)uploadRootDir, (String)"/")));
            ZulBootstrap.table(request).replace((Object)chunk);
        } else {
            Updater updater = new Updater();
            updater.addReplace("id", request.getNestAttributeString("orm.id"));
            updater.addField("chunkNo", (Object)chunkNo);
            updater.addField("chunkTime", (Object)DateTimes.getDateTimeString());
            updater.addMust("fileMd5", (Object)fileMd5);
            updater.addMust("chunkSize", (Object)chunkSize);
            ZulBootstrap.table(request).update(UpllChunk.class, updater);
        }
        return true;
    }

    public static void clearChunkData(HttpRequest request, String fileMd5, int chunkSize) throws Exception {
        Selector selector = new Selector("fileMd5", (Object)fileMd5);
        selector.addMust("chunkSize", (Object)chunkSize);
        selector.addReplace("id", request.getNestAttributeString("orm.id"));
        ZulBootstrap.table(request).delete(UpllChunk.class, selector);
    }

    public static UpllFile saveFile(HttpRequest request, UpllChunk chunk, String fileRootDir, String uploadRootDir, long fileLength, String contentType) throws Exception {
        String chunkFilePath = ZulDao.getFilePath(chunk);
        String fileDir = Files.getFileDir((String)chunkFilePath);
        String filePath = ZulUploader.getAvailableFilePath(fileDir, chunk.getFileName());
        String fileName = Files.getFileName((String)filePath);
        Files.renameFile((String)chunkFilePath, (String)filePath);
        String fileId = Ids.uuid();
        String fileExt = chunk.getFileExt();
        UpllFile file = new UpllFile();
        file.setId(request.getNestAttributeString("orm.id"));
        file.setFileId(fileId);
        file.setFileName(fileName);
        file.setFileLength(fileLength);
        file.setFilePath(filePath);
        file.setFileRootDir(fileRootDir);
        file.setFileUploadPath(Strings.removeStartsWith((String)filePath, (String)Strings.removeEndsWith((String)uploadRootDir, (String)"/")));
        file.setFileExt(chunk.getFileExt());
        file.setFileMd5(chunk.getFileMd5());
        file.setFileUrl("/service/upll/" + fileId + Files.fixFileExt((String)fileExt));
        file.setFileTime(DateTimes.getDateTimeString());
        file.setContentType(contentType);
        ZulBootstrap.table(request).replace((Object)file);
        ZulUploader.clearChunkData(request, chunk.getFileMd5(), chunk.getChunkSize());
        return file;
    }

    public static UpllFile saveFile(HttpRequest request, byte[] data, String filePath, String contentType) throws Exception {
        return ZulUploader.saveFile(request.getContext(), request.getNestAttributeString("orm.id"), data, filePath, contentType);
    }

    public static UpllFile saveFile(HttpContext context, String ormId, byte[] data, String filePath, String contentType) throws Exception {
        String fileId = Ids.uuid();
        String fileExt = Files.getFileExt((String)filePath);
        String fileName = Files.getFileName((String)filePath);
        long fileLength = data.length;
        String fileMd5 = String.valueOf(MD5.encode((byte[])data)) + Hexs.toHexString((byte[])Bytes.BU.toBytes(fileLength), (LetterCase)LetterCase.LOWER);
        Files.write((String)filePath, (byte[])data);
        String rootDir = context.getAttributeString("upload.large.rootDir");
        if (Validates.isEmptyBlank((String)rootDir) || !Files.mkDirectory((String)rootDir)) {
            throw new Exception("[UploadLarge][\u914d\u7f6e\u5904\u7406\u5668\u5904\u7406\u65f6\u5fc5\u987b\u914d\u7f6e\u4e0a\u4f20\u6839\u76ee\u5f55]");
        }
        String uploadRootDir = Files.toLinuxPath((String)new File(rootDir).getCanonicalPath());
        UpllFile file = new UpllFile();
        file.setId(ormId);
        file.setFileId(fileId);
        file.setFileName(fileName);
        file.setFileExt(fileExt);
        file.setFileLength(fileLength);
        file.setFileMd5(fileMd5);
        file.setFilePath(filePath);
        file.setFileRootDir(rootDir);
        file.setFileUploadPath(Strings.removeStartsWith((String)filePath, (String)Strings.removeEndsWith((String)uploadRootDir, (String)"/")));
        file.setFileUrl("/service/upll/" + fileId + Files.fixFileExt((String)fileExt));
        file.setFileTime(DateTimes.getDateTimeString());
        file.setContentType(contentType);
        ZulBootstrap.table(context).replace((Object)file);
        return file;
    }

    public static UpllFile saveFile(HttpRequest request, byte[] data, String preDir, String uploadPath, String contentType) throws Exception {
        String fileId = Ids.uuid();
        String fileExt = Files.getFileExt((String)uploadPath);
        String fileName = Files.getFileName((String)uploadPath);
        long fileLength = data.length;
        String fileMd5 = String.valueOf(MD5.encode((byte[])data)) + Hexs.toHexString((byte[])Bytes.BU.toBytes(fileLength), (LetterCase)LetterCase.LOWER);
        preDir = Strings.removeEndsWith((String)preDir, (String)"/");
        uploadPath = Strings.addStartsWith((String)uploadPath, (String)"/");
        String filePath = String.valueOf(preDir) + uploadPath;
        filePath = Files.toLinuxPath((String)new File(filePath).getCanonicalPath());
        Files.write((String)filePath, (byte[])data);
        UpllFile file = new UpllFile();
        file.setId(request.getNestAttributeString("orm.id"));
        file.setFileId(fileId);
        file.setFileName(fileName);
        file.setFileExt(fileExt);
        file.setFileLength(fileLength);
        file.setFileMd5(fileMd5);
        file.setFilePath(filePath);
        file.setFileRootDir(preDir);
        file.setFileUploadPath(uploadPath);
        file.setFileUrl("/service/upll/" + fileId + Files.fixFileExt((String)fileExt));
        file.setFileTime(DateTimes.getDateTimeString());
        file.setContentType(contentType);
        ZulBootstrap.table(request).replace((Object)file);
        return file;
    }

    public static UpllFile saveFile(HttpRequest request, UpllFile oFile) throws Exception {
        String fileId = Ids.uuid();
        String filePath = ZulDao.getFilePath(oFile);
        String fileExt = oFile.getFileExt();
        String fileName = oFile.getFileName();
        String fileRootDir = request.getContext().getAttributeString("upload.large.rootDir");
        String uploadRootDir = Files.toLinuxPath((String)new File(fileRootDir).getCanonicalPath());
        UpllFile file = new UpllFile();
        file.setId(request.getNestAttributeString("orm.id"));
        file.setFileId(fileId);
        file.setFileName(fileName);
        file.setFileExt(fileExt);
        file.setFileLength(oFile.getFileLength());
        file.setFileMd5(oFile.getFileMd5());
        file.setFilePath(filePath);
        file.setFileRootDir(fileRootDir);
        file.setFileUploadPath(Strings.removeStartsWith((String)filePath, (String)uploadRootDir));
        file.setFileUrl("/service/upll/" + fileId + Files.fixFileExt((String)fileExt));
        file.setFileTime(DateTimes.getDateTimeString());
        file.setContentType(oFile.getContentType());
        ZulBootstrap.table(request).replace((Object)file);
        return file;
    }

    public static UpllFile copyFile(HttpRequest request, UpllFile oFile, String fileDir, String fileName) throws Exception {
        String fileId = Ids.uuid();
        String filePath = ZulUploader.getAvailableFilePath(fileDir, fileName);
        String fileExt = oFile.getFileExt();
        Files.copyFile((String)ZulDao.getFilePath(oFile), (String)filePath);
        String fileRootDir = request.getContext().getAttributeString("upload.large.rootDir");
        String uploadRootDir = Files.toLinuxPath((String)new File(fileRootDir).getCanonicalPath());
        UpllFile file = new UpllFile();
        file.setId(request.getNestAttributeString("orm.id"));
        file.setFileId(fileId);
        file.setFileName(fileName);
        file.setFileExt(fileExt);
        file.setFileLength(oFile.getFileLength());
        file.setFileMd5(oFile.getFileMd5());
        file.setFilePath(filePath);
        file.setFileRootDir(fileRootDir);
        file.setFileUploadPath(Strings.removeStartsWith((String)filePath, (String)uploadRootDir));
        file.setFileUrl("/service/upll/" + fileId + Files.fixFileExt((String)fileExt));
        file.setFileTime(DateTimes.getDateTimeString());
        file.setContentType(oFile.getContentType());
        ZulBootstrap.table(request).replace((Object)file);
        return file;
    }

    private static String getChunkFilePath(String fileDir, String fileMd5) {
        return fileDir + "zhiqim_" + fileMd5 + ".upll";
    }

    private static String getAvailableFilePath(String fileDir, String fileName) {
        String fileExt = Files.getFileExt((String)fileName);
        if (!Validates.isEmpty((String)fileExt)) {
            fileExt = "." + fileExt;
            fileName = Strings.trimRight((String)fileName, (String)fileExt);
        }
        String filePath = String.valueOf(fileDir) + fileName + fileExt;
        int i = 1;
        File file;
        while ((file = new File(filePath)).exists()) {
            filePath = String.valueOf(fileDir) + fileName + "(" + i + ")" + fileExt;
            ++i;
        }
        return filePath;
    }
}

