/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.uploadlarge;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.util.Responses;
import org.zhiqim.kernel.enumerated.LetterCase;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.uploadlarge.ZulConstants;
import org.zhiqim.uploadlarge.ZulUploader;
import org.zhiqim.uploadlarge.dbo.UpllChunk;
import org.zhiqim.uploadlarge.dbo.UpllFile;

public class ZulService
implements HttpExecutor,
ZulConstants {
    private static final Log log = LogFactory.getLog(ZulService.class);
    private static final String[] FILE_DIR_NOT_FORMAT = new String[]{".", "\\", "?", ":", "*", "'", "\"", "<", ">", "|"};
    private String uploadRootDir;
    private String uploadOrm;
    private String rootDir;

    public boolean isMatch(String pathInContext) {
        return "/service/uploadlarge".equals(pathInContext);
    }

    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        String sessionName = Strings.toString((Object)request.getSessionName(), (String)"guest");
        HttpContext context = request.getContext();
        if (this.uploadRootDir == null) {
            this.rootDir = context.getAttributeString("upload.large.rootDir");
            if (Validates.isEmptyBlank((String)this.rootDir) || !Files.mkDirectory((String)this.rootDir)) {
                log.error((Object)"USER:%s IP:%s [UploadLarge][\u914d\u7f6e\u5904\u7406\u5668\u5904\u7406\u65f6\u5fc5\u987b\u914d\u7f6e\u4e0a\u4f20\u6839\u76ee\u5f55][%s]", new Object[]{sessionName, request.getRemoteAddr(), "upload.large.rootDir"});
                response.sendError(403);
                return;
            }
            this.uploadRootDir = Files.toLinuxPath((String)new File(this.rootDir).getCanonicalPath());
            this.uploadRootDir = Strings.addEndsWith((String)this.uploadRootDir, (String)"/");
        }
        if (this.uploadOrm == null) {
            this.uploadOrm = context.getAttributeString("upload.large.orm", "");
        }
        int mode = request.getHeaderInt("X-Responsed-Mode", 0);
        String fileDir = request.getHeader("X-Upload-File-Dir");
        String fileName = request.getHeader("X-Upload-File-Name");
        String fileMd5 = request.getHeader("X-Upload-File-Md5");
        int fileMd5Target = request.getHeaderInt("X-Upload-File-Md5-Target", 0);
        int fileCopy = request.getHeaderInt("X-Upload-File-Copy", 0);
        long fileLength = request.getHeaderInt("X-Upload-File-Length");
        int chunkNum = request.getHeaderInt("X-Upload-Chunk-Num");
        int chunkSize = request.getHeaderInt("X-Upload-Chunk-Size");
        int chunkNo = request.getHeaderInt("X-Upload-Chunk-No");
        int contentLength = request.getContentLength();
        if (mode < 0 || mode > 1 || fileMd5Target < 0 || fileMd5Target > 2 || !Validates.isMD5String((String)fileMd5)) {
            log.error((Object)"USER:%s IP:%s [UploadLarge][\u53c2\u6570\u4e0d\u6b63\u786e][mode:%s][fileMd5Target:%s][fileMd5:%s]", new Object[]{sessionName, request.getRemoteAddr(), mode, fileMd5Target, fileMd5});
            response.sendError(412);
            return;
        }
        if (fileLength == -1L || chunkNum < 1 || chunkNo < 1 || chunkSize < 102400 || contentLength <= 0 || fileLength < (long)contentLength || chunkNum < chunkNo) {
            log.error((Object)"USER:%s IP:%s [UploadLarge][\u53c2\u6570\u4e0d\u6b63\u786e][fileLength:%s][contentLength:%s][chunkSize:%s][chunkNo:%s]][chunkNum:%s][%s]", new Object[]{sessionName, request.getRemoteAddr(), fileLength, contentLength, chunkSize, chunkNo, chunkNum, request.getUserAgent()});
            response.sendError(412);
            return;
        }
        if (contentLength > chunkSize || chunkNo < chunkNum && contentLength != chunkSize) {
            log.error((Object)"USER:%s IP:%s [UploadLarge][\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u957f\u5ea6\u4e0d\u6b63\u786e][contentLength:%s][chunkSize:%s][chunkNo:%s][chunkNum:%s][%s]", new Object[]{sessionName, request.getRemoteAddr(), contentLength, chunkSize, chunkNo, chunkNum, request.getUserAgent()});
            response.sendError(415);
            return;
        }
        fileDir = Urls.decodeUTF8((String)fileDir);
        fileDir = Strings.removeStartsWith((String)fileDir, (String)"/");
        fileDir = Strings.removeEndsWith((String)fileDir, (String)"/");
        fileName = Urls.decodeUTF8((String)fileName);
        fileMd5 = String.valueOf(fileMd5.toLowerCase()) + Hexs.toHexString((byte[])Bytes.BU.toBytes(fileLength), (LetterCase)LetterCase.LOWER);
        if (Validates.isStrContainStrArr((String)fileDir, (String[])FILE_DIR_NOT_FORMAT) || Validates.isEmptyBlank((String)fileName)) {
            log.error((Object)"USER:%s IP:%s [UploadLarge][\u53c2\u6570\u4e0d\u6b63\u786e][fileDir:%s][fileName:%s]", new Object[]{sessionName, request.getRemoteAddr(), fileDir, fileName});
            response.sendError(412);
            return;
        }
        if (Validates.isEmptyBlank((String)fileDir)) {
            fileDir = this.uploadRootDir;
        } else {
            fileDir = Strings.addEndsWith((String)fileDir, (String)"/");
            fileDir = String.valueOf(this.uploadRootDir) + fileDir;
            if (!Files.mkDirectory((String)fileDir)) {
                log.error((Object)"USER:%s IP:%s [UploadLarge][\u4e0a\u4f20\u7684\u6587\u4ef6\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa][%s]", new Object[]{sessionName, request.getRemoteAddr(), request.getHeader("X-Upload-File-Dir")});
                response.sendError(403);
                return;
            }
        }
        if (fileName.length() > 512) {
            fileName = fileName.substring(fileName.length() - 512);
        }
        try {
            byte[] data;
            boolean isSucc;
            UpllFile file = ZulUploader.queryFile(request, fileMd5);
            if (file != null) {
                file = fileCopy == 0 ? ZulUploader.saveFile(request, file) : ZulUploader.copyFile(request, file, fileDir, fileName);
                log.info((Object)"USER:%s IP:%s [UploadLarge][\u79d2\u4f20][%s]", new Object[]{sessionName, request.getRemoteAddr(), fileMd5});
                this.doUploadCompleted(response, mode, file.getFileId(), file.getFileName(), file.getFileUrl());
                return;
            }
            UpllChunk chunk = ZulUploader.queryChunk(request, fileMd5, chunkSize);
            if (chunk == null) {
                if (chunkNo > 1) {
                    log.error((Object)"USER:%s IP:%s [UploadLarge][\u788e\u7247\u521d\u59cb\u7f16\u53f7\u4e0d\u6b63\u786e]", new Object[]{sessionName, request.getRemoteAddr()});
                    response.sendError(400);
                    return;
                }
            } else {
                int lastChunkNo = chunk.getChunkNo();
                if (chunkNo > lastChunkNo + 1) {
                    log.error((Object)"USER:%s IP:%s [UploadLarge][\u788e\u7247\u8df3\u7f16\u53f7]", new Object[]{sessionName, request.getRemoteAddr()});
                    response.sendError(400);
                    return;
                }
                if (chunkNo <= lastChunkNo) {
                    log.info((Object)"USER:%s IP:%s [UploadLarge][\u788e\u7247\u7eed\u4f20][%s]", new Object[]{sessionName, request.getRemoteAddr(), chunkNo});
                    this.doUploadChunk(response, mode, lastChunkNo);
                    return;
                }
            }
            if (!(isSucc = ZulUploader.saveChunkData(request, data = Streams.getBytes((InputStream)request.getInputStream(), (int)contentLength), this.rootDir, this.uploadRootDir, fileDir, fileName, fileMd5, fileLength, chunkSize, chunkNum, chunkNo))) {
                file = ZulUploader.queryFile(request, fileMd5);
                if (file == null) {
                    throw new Exception("\u4e0a\u4f20\u788e\u7247\u65f6\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
                }
                file = fileCopy == 0 ? ZulUploader.saveFile(request, file) : ZulUploader.copyFile(request, file, fileDir, fileName);
                log.info((Object)"USER:%s IP:%s [UploadLarge][\u4e0a\u4f20\u5b8c\u6210][\u591a\u4eba\u4e0a\u4f20\u60c5\u51b5][%s][%s]", new Object[]{sessionName, request.getRemoteAddr(), fileMd5, file.getFileName()});
                this.doUploadCompleted(response, mode, file.getFileId(), file.getFileName(), file.getFileUrl());
            } else if (chunkNo < chunkNum) {
                log.info((Object)"USER:%s IP:%s [UploadLarge][\u788e\u7247\u4e0a\u4f20][\u603b:%s][\u7b2c:%s][%s]", new Object[]{sessionName, request.getRemoteAddr(), chunkNum, chunkNo, fileMd5});
                this.doUploadChunk(response, mode, chunkNo);
            } else {
                chunk = ZulUploader.queryChunk(request, fileMd5, chunkSize);
                String contentType = request.getContentType();
                file = ZulUploader.saveFile(request, chunk, this.rootDir, this.uploadRootDir, fileLength, contentType);
                log.info((Object)"USER:%s IP:%s [UploadLarge][\u4e0a\u4f20\u5b8c\u6210][\u603b:%s][\u6700\u540e\u4e00\u4e2a\u788e\u7247][%s][%s]", new Object[]{sessionName, request.getRemoteAddr(), chunkNum, fileMd5, file.getFileName()});
                this.doUploadCompleted(response, mode, file.getFileId(), file.getFileName(), file.getFileUrl());
            }
        }
        catch (Exception e) {
            try {
                response.sendHeader(500);
            }
            catch (Exception exception) {}
            log.error((Throwable)e);
        }
    }

    private void doUploadChunk(HttpResponse response, int mode, int chunkNo) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-Upload-Chunk-No", "" + chunkNo);
        Responses.doReturnMessage((HttpResponse)response, (int)mode, headerMap);
    }

    private void doUploadCompleted(HttpResponse response, int mode, String fileId, String fileName, String fileUrl) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-Upload-File-Id", fileId);
        headerMap.put("X-Upload-File-Name", Urls.encodeUTF8((String)fileName));
        headerMap.put("X-Upload-File-Url", fileUrl);
        Responses.doReturnMessage((HttpResponse)response, (int)mode, headerMap);
    }
}

